/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.help.sections;

import com.github.rvesse.airline.Cli;
import com.github.rvesse.airline.args.Args1;
import com.github.rvesse.airline.builder.CliBuilder;
import com.github.rvesse.airline.help.sections.Args1HidesDiscussion;
import com.github.rvesse.airline.help.sections.CliWithSections;
import com.github.rvesse.airline.help.sections.HelpFormat;
import com.github.rvesse.airline.help.sections.HelpSection;
import com.github.rvesse.airline.help.sections.common.BasicSection;
import com.github.rvesse.airline.help.sections.common.DiscussionSection;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.utils.predicates.parser.CommandFinder;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHelpSectionDetection {
    @Test
    public void help_section_cli_01() {
        Cli cli = new Cli(CliWithSections.class);
        CommandFinder finder = new CommandFinder("Args1");
        CommandMetadata cmd = (CommandMetadata)CollectionUtils.find((Iterable)cli.getMetadata().getDefaultGroupCommands(), (Predicate)finder);
        Assert.assertNotNull((Object)cmd);
        Assert.assertEquals((int)cmd.getHelpSections().size(), (int)1);
        HelpSection section = (HelpSection)CollectionUtils.find((Iterable)cmd.getHelpSections(), (Predicate)new HelpSectionFinder("Discussion"));
        Assert.assertTrue((boolean)(section instanceof DiscussionSection));
        DiscussionSection discussion = (DiscussionSection)section;
        String[] paragraphs = discussion.getContentBlock(0);
        Assert.assertEquals((int)paragraphs.length, (int)2);
        Assert.assertEquals((String)paragraphs[0], (String)"Foo");
        Assert.assertEquals((String)paragraphs[1], (String)"Bar");
    }

    @Test
    public void help_section_cli_02() {
        Cli cli = new Cli(CliWithSections.class);
        CommandFinder finder = new CommandFinder("remove");
        CommandMetadata cmd = (CommandMetadata)CollectionUtils.find((Iterable)cli.getMetadata().getDefaultGroupCommands(), (Predicate)finder);
        Assert.assertNotNull((Object)cmd);
        Assert.assertEquals((int)cmd.getHelpSections().size(), (int)2);
        HelpSection section = (HelpSection)CollectionUtils.find((Iterable)cmd.getHelpSections(), (Predicate)new HelpSectionFinder("Discussion"));
        Assert.assertTrue((boolean)(section instanceof DiscussionSection));
        DiscussionSection discussion = (DiscussionSection)section;
        String[] paragraphs = discussion.getContentBlock(0);
        Assert.assertEquals((int)paragraphs.length, (int)1);
    }

    @Test
    public void help_section_cli_builder_01() {
        Cli cli = new CliBuilder("test").withHelpSection((HelpSection)new DiscussionSection(new String[]{"A", "B"})).withCommand(Args1.class).build();
        CommandFinder finder = new CommandFinder("Args1");
        CommandMetadata cmd = (CommandMetadata)CollectionUtils.find((Iterable)cli.getMetadata().getDefaultGroupCommands(), (Predicate)finder);
        Assert.assertNotNull((Object)cmd);
        Assert.assertEquals((int)cmd.getHelpSections().size(), (int)1);
        HelpSection section = (HelpSection)CollectionUtils.find((Iterable)cmd.getHelpSections(), (Predicate)new HelpSectionFinder("Discussion"));
        Assert.assertTrue((boolean)(section instanceof DiscussionSection));
        DiscussionSection discussion = (DiscussionSection)section;
        String[] paragraphs = discussion.getContentBlock(0);
        Assert.assertEquals((int)paragraphs.length, (int)2);
        Assert.assertEquals((String)paragraphs[0], (String)"A");
        Assert.assertEquals((String)paragraphs[1], (String)"B");
    }

    @Test
    public void help_section_cli_builder_02() {
        Cli cli = new CliBuilder("test").withHelpSection((HelpSection)new DiscussionSection(new String[]{"A", "B"})).withCommand(Args1HidesDiscussion.class).build();
        CommandFinder finder = new CommandFinder("Args1");
        CommandMetadata cmd = (CommandMetadata)CollectionUtils.find((Iterable)cli.getMetadata().getDefaultGroupCommands(), (Predicate)finder);
        Assert.assertNotNull((Object)cmd);
        Assert.assertEquals((int)cmd.getHelpSections().size(), (int)1);
        HelpSection section = (HelpSection)CollectionUtils.find((Iterable)cmd.getHelpSections(), (Predicate)new HelpSectionFinder("Discussion"));
        Assert.assertTrue((boolean)(section instanceof BasicSection));
        BasicSection basic = (BasicSection)section;
        Assert.assertEquals((String)basic.getTitle(), (String)"Discussion");
        Assert.assertEquals((Object)basic.getFormat(), (Object)HelpFormat.NONE_PRINTABLE);
    }

    private static class HelpSectionFinder
    implements Predicate<HelpSection> {
        private final String title;

        public HelpSectionFinder(String title) {
            this.title = title;
        }

        public boolean evaluate(HelpSection section) {
            return StringUtils.equals((CharSequence)section.getTitle(), (CharSequence)this.title);
        }
    }
}

