/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.command;

import com.github.rvesse.airline.Cli;
import com.github.rvesse.airline.command.AbstractGroupAnnotationCommand;
import com.github.rvesse.airline.command.CommandAdd;
import com.github.rvesse.airline.command.CommandWithGroupAnnotation;
import com.github.rvesse.airline.command.CommandWithGroupNames;
import com.github.rvesse.airline.command.CommandWithGroupsAnnotation;
import com.github.rvesse.airline.command.CommandWithSubGroupAnnotation;
import com.github.rvesse.airline.command.CommandWithSubGroupNames;
import com.github.rvesse.airline.command.CommandWithSubGroupsAnnotation;
import com.github.rvesse.airline.model.CommandGroupMetadata;
import com.github.rvesse.airline.model.GlobalMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.parser.errors.ParseCommandUnrecognizedException;
import com.github.rvesse.airline.utils.AirlineUtils;
import java.util.Arrays;
import java.util.Collection;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestGroupAnnotations {
    @Test
    public void groupIsCreatedFromGroupsAnnotation() {
        Cli parser = Cli.builder((String)"junk").withCommand(CommandWithGroupsAnnotation.class).build();
        GlobalMetadata global = parser.getMetadata();
        Assert.assertEquals((int)global.getCommandGroups().size(), (int)1);
        Object command = parser.parse(new String[]{"groupInsideOfGroups", "commandWithGroupsAnno", "-i", "A.java"});
        Assert.assertNotNull((Object)command, (String)"command is null");
        Assert.assertTrue((boolean)(command instanceof CommandWithGroupsAnnotation));
        CommandWithGroupsAnnotation add = (CommandWithGroupsAnnotation)command;
        Assert.assertEquals((boolean)add.interactive, (boolean)true);
        Assert.assertEquals((Collection)add.patterns, Arrays.asList("A.java"));
    }

    @Test
    public void subGroupIsCreatedFromGroupsAnnotation() {
        Cli parser = Cli.builder((String)"junk").withCommand(CommandWithSubGroupsAnnotation.class).build();
        GlobalMetadata global = parser.getMetadata();
        Assert.assertEquals((int)global.getCommandGroups().size(), (int)1);
        CommandGroupMetadata parentGroup = (CommandGroupMetadata)global.getCommandGroups().get(0);
        Assert.assertEquals((int)parentGroup.getSubGroups().size(), (int)1);
        Object command = parser.parse(new String[]{"groupInsideOfGroups", "subGroup", "commandWithSubGroupsAnno", "-i", "A.java"});
        Assert.assertNotNull((Object)command, (String)"command is null");
        Assert.assertTrue((boolean)(command instanceof CommandWithSubGroupsAnnotation));
        CommandWithSubGroupsAnnotation add = (CommandWithSubGroupsAnnotation)command;
        Assert.assertEquals((boolean)add.interactive, (boolean)true);
        Assert.assertEquals((Collection)add.patterns, Arrays.asList("A.java"));
    }

    @Test
    public void extraCommandsAreAddedFromGroupsAnnotation() {
        Cli parser = Cli.builder((String)"junk").withCommand(CommandWithGroupsAnnotation.class).build();
        Object command = parser.parse(new String[]{"groupInsideOfGroups", "add", "-i", "A.java"});
        Assert.assertNotNull((Object)command, (String)"command is null");
        Assert.assertTrue((boolean)(command instanceof CommandAdd));
        CommandAdd add = (CommandAdd)command;
        Assert.assertEquals((boolean)add.interactive, (boolean)true);
        Assert.assertEquals(add.patterns, Arrays.asList("A.java"));
    }

    @Test
    public void extraCommandsAreAddedFromSubGroupsAnnotation() {
        Cli parser = Cli.builder((String)"junk").withCommand(CommandWithSubGroupsAnnotation.class).build();
        Object command = parser.parse(new String[]{"groupInsideOfGroups", "subGroup", "add", "-i", "A.java"});
        Assert.assertNotNull((Object)command, (String)"command is null");
        Assert.assertTrue((boolean)(command instanceof CommandAdd));
        CommandAdd add = (CommandAdd)command;
        Assert.assertEquals((boolean)add.interactive, (boolean)true);
        Assert.assertEquals(add.patterns, Arrays.asList("A.java"));
    }

    @Test(expectedExceptions={ParseCommandUnrecognizedException.class})
    public void commandRemovedFromDefaultGroupWithGroupsAnnotation() {
        Cli parser = Cli.builder((String)"junk").withCommand(CommandWithGroupsAnnotation.class).build();
        parser.parse(new String[]{"commandWithGroupsAnno", "-i", "A.java"});
    }

    @Test(expectedExceptions={ParseCommandUnrecognizedException.class})
    public void commandRemovedFromDefaultGroupWithSubGroupsAnnotation() {
        Cli parser = Cli.builder((String)"junk").withCommand(CommandWithSubGroupsAnnotation.class).build();
        parser.parse(new String[]{"commandWithSubGroupsAnno", "-i", "A.java"});
    }

    @Test
    public void groupOptionsAreAddedFromGroupsAnnotation() {
        Cli parser = Cli.builder((String)"junk").withCommand(CommandWithGroupsAnnotation.class).build();
        Assert.assertEquals((int)parser.getMetadata().getCommandGroups().size(), (int)1);
        CommandGroupMetadata group = (CommandGroupMetadata)parser.getMetadata().getCommandGroups().get(0);
        Assert.assertEquals((int)group.getOptions().size(), (int)1);
        OptionMetadata option = (OptionMetadata)group.getOptions().get(0);
        Assert.assertEquals((String)"-v", (String)((String)AirlineUtils.first((Iterable)option.getOptions())));
    }

    @Test
    public void groupOptionsAreAddedFromSubGroupsAnnotation() {
        Cli parser = Cli.builder((String)"junk").withCommand(CommandWithSubGroupsAnnotation.class).build();
        Assert.assertEquals((int)parser.getMetadata().getCommandGroups().size(), (int)1);
        CommandGroupMetadata group = (CommandGroupMetadata)parser.getMetadata().getCommandGroups().get(0);
        Assert.assertEquals((int)group.getOptions().size(), (int)1);
        OptionMetadata option = (OptionMetadata)group.getOptions().get(0);
        Assert.assertEquals((String)"-v", (String)((String)AirlineUtils.first((Iterable)option.getOptions())));
        Assert.assertEquals((int)group.getSubGroups().size(), (int)1);
        group = (CommandGroupMetadata)group.getSubGroups().get(0);
        Assert.assertEquals((int)group.getOptions().size(), (int)1);
        option = (OptionMetadata)group.getOptions().get(0);
        Assert.assertEquals((String)"-v", (String)((String)AirlineUtils.first((Iterable)option.getOptions())));
    }

    @Test
    public void defaultCommandIsAddedFromGroupsAnnotation() {
        Cli parser = Cli.builder((String)"junk").withCommand(CommandWithGroupsAnnotation.class).build();
        Object command = parser.parse(new String[]{"groupInsideOfGroups", "-i", "A.java"});
        Assert.assertNotNull((Object)command, (String)"command is null");
        Assert.assertTrue((boolean)(command instanceof CommandWithGroupsAnnotation));
        CommandWithGroupsAnnotation add = (CommandWithGroupsAnnotation)command;
        Assert.assertEquals((boolean)add.interactive, (boolean)true);
        Assert.assertEquals((Collection)add.patterns, Arrays.asList("A.java"));
    }

    @Test
    public void defaultCommandIsAddedFromSubGroupsAnnotation() {
        Cli parser = Cli.builder((String)"junk").withCommand(CommandWithSubGroupsAnnotation.class).build();
        Object command = parser.parse(new String[]{"groupInsideOfGroups", "subGroup", "-i", "A.java"});
        Assert.assertNotNull((Object)command, (String)"command is null");
        Assert.assertTrue((boolean)(command instanceof CommandWithSubGroupsAnnotation));
        CommandWithSubGroupsAnnotation add = (CommandWithSubGroupsAnnotation)command;
        Assert.assertEquals((boolean)add.interactive, (boolean)true);
        Assert.assertEquals((Collection)add.patterns, Arrays.asList("A.java"));
    }

    @Test
    public void groupIsCreatedFromGroupAnnotation() {
        Cli parser = Cli.builder((String)"junk").withCommand(CommandWithGroupAnnotation.class).build();
        Object command = parser.parse(new String[]{"singleGroup", "commandWithGroup", "-i", "A.java"});
        Assert.assertNotNull((Object)command, (String)"command is null");
        Assert.assertTrue((boolean)(command instanceof CommandWithGroupAnnotation));
        AbstractGroupAnnotationCommand add = (AbstractGroupAnnotationCommand)command;
        Assert.assertEquals((boolean)add.interactive, (boolean)true);
        Assert.assertEquals(add.patterns, Arrays.asList("A.java"));
    }

    @Test
    public void groupIsCreatedFromSubGroupAnnotation() {
        Cli parser = Cli.builder((String)"junk").withCommand(CommandWithSubGroupAnnotation.class).build();
        Object command = parser.parse(new String[]{"singleGroup", "subGroup", "commandWithGroup", "-i", "A.java"});
        Assert.assertNotNull((Object)command, (String)"command is null");
        Assert.assertTrue((boolean)(command instanceof CommandWithSubGroupAnnotation));
        CommandWithSubGroupAnnotation add = (CommandWithSubGroupAnnotation)command;
        Assert.assertEquals((boolean)add.interactive, (boolean)true);
        Assert.assertEquals((Collection)add.patterns, Arrays.asList("A.java"));
    }

    @Test
    public void extraCommandsAreAddedFromGroupAnnotation() {
        Cli parser = Cli.builder((String)"junk").withCommand(CommandWithGroupAnnotation.class).build();
        Object command = parser.parse(new String[]{"singleGroup", "add", "-i", "A.java"});
        Assert.assertNotNull((Object)command, (String)"command is null");
        Assert.assertTrue((boolean)(command instanceof CommandAdd));
        CommandAdd add = (CommandAdd)command;
        Assert.assertEquals((boolean)add.interactive, (boolean)true);
        Assert.assertEquals(add.patterns, Arrays.asList("A.java"));
    }

    @Test
    public void extraCommandsAreAddedFromSubGroupAnnotation() {
        Cli parser = Cli.builder((String)"junk").withCommand(CommandWithSubGroupAnnotation.class).build();
        Object command = parser.parse(new String[]{"singleGroup", "subGroup", "add", "-i", "A.java"});
        Assert.assertNotNull((Object)command, (String)"command is null");
        Assert.assertTrue((boolean)(command instanceof CommandAdd));
        CommandAdd add = (CommandAdd)command;
        Assert.assertEquals((boolean)add.interactive, (boolean)true);
        Assert.assertEquals(add.patterns, Arrays.asList("A.java"));
    }

    @Test(expectedExceptions={ParseCommandUnrecognizedException.class})
    public void commandRemovedFromDefaultGroupWithGroupAnnotation() {
        Cli parser = Cli.builder((String)"junk").withCommand(CommandWithGroupAnnotation.class).build();
        parser.parse(new String[]{"commandWithGroup", "-i", "A.java"});
    }

    @Test(expectedExceptions={ParseCommandUnrecognizedException.class})
    public void commandRemovedFromDefaultGroupWithSubGroupAnnotation() {
        Cli parser = Cli.builder((String)"junk").withCommand(CommandWithSubGroupAnnotation.class).build();
        parser.parse(new String[]{"commandWithGroup", "-i", "A.java"});
    }

    @Test
    public void defaultCommandIsAddedFromGroupAnnotation() {
        Cli parser = Cli.builder((String)"junk").withCommand(CommandWithGroupAnnotation.class).build();
        Object command = parser.parse(new String[]{"singleGroup", "-i", "A.java"});
        Assert.assertNotNull((Object)command, (String)"command is null");
        Assert.assertTrue((boolean)(command instanceof CommandWithGroupAnnotation));
        AbstractGroupAnnotationCommand add = (AbstractGroupAnnotationCommand)command;
        Assert.assertEquals((boolean)add.interactive, (boolean)true);
        Assert.assertEquals(add.patterns, Arrays.asList("A.java"));
    }

    @Test
    public void defaultCommandIsAddedFromSubGroupAnnotation() {
        Cli parser = Cli.builder((String)"junk").withCommand(CommandWithSubGroupAnnotation.class).build();
        Object command = parser.parse(new String[]{"singleGroup", "subGroup", "-i", "A.java"});
        Assert.assertNotNull((Object)command, (String)"command is null");
        Assert.assertTrue((boolean)(command instanceof CommandWithSubGroupAnnotation));
        CommandWithSubGroupAnnotation add = (CommandWithSubGroupAnnotation)command;
        Assert.assertEquals((boolean)add.interactive, (boolean)true);
        Assert.assertEquals((Collection)add.patterns, Arrays.asList("A.java"));
    }

    @Test
    public void addedToGroupFromGroupAnnotation() {
        Cli parser = Cli.builder((String)"junk").withCommands(CommandWithGroupAnnotation.class, new Class[]{CommandWithGroupNames.class}).build();
        Object command = parser.parse(new String[]{"singleGroup", "commandWithGroupNames", "-i", "A.java"});
        Assert.assertNotNull((Object)command, (String)"command is null");
        Assert.assertTrue((boolean)(command instanceof CommandWithGroupNames));
        CommandWithGroupNames add = (CommandWithGroupNames)command;
        Assert.assertEquals((boolean)add.interactive, (boolean)true);
        Assert.assertEquals((Collection)add.patterns, Arrays.asList("A.java"));
        command = parser.parse(new String[]{"singletonGroup", "commandWithGroupNames", "-i", "A.java"});
        Assert.assertNotNull((Object)command, (String)"command is null");
        Assert.assertTrue((boolean)(command instanceof CommandWithGroupNames));
        add = (CommandWithGroupNames)command;
        Assert.assertEquals((boolean)add.interactive, (boolean)true);
        Assert.assertEquals((Collection)add.patterns, Arrays.asList("A.java"));
    }

    @Test
    public void addedToGroupFromSubGroupAnnotation() {
        Cli parser = Cli.builder((String)"junk").withCommands(CommandWithGroupAnnotation.class, new Class[]{CommandWithSubGroupNames.class}).build();
        Object command = parser.parse(new String[]{"singleGroup", "commandWithGroupNames", "-i", "A.java"});
        Assert.assertNotNull((Object)command, (String)"command is null");
        Assert.assertTrue((boolean)(command instanceof CommandWithSubGroupNames));
        CommandWithSubGroupNames add = (CommandWithSubGroupNames)command;
        Assert.assertEquals((boolean)add.interactive, (boolean)true);
        Assert.assertEquals((Collection)add.patterns, Arrays.asList("A.java"));
        command = parser.parse(new String[]{"parent", "child", "commandWithGroupNames", "-i", "A.java"});
        Assert.assertNotNull((Object)command, (String)"command is null");
        Assert.assertTrue((boolean)(command instanceof CommandWithSubGroupNames));
        add = (CommandWithSubGroupNames)command;
        Assert.assertEquals((boolean)add.interactive, (boolean)true);
        Assert.assertEquals((Collection)add.patterns, Arrays.asList("A.java"));
    }

    @Test(expectedExceptions={ParseCommandUnrecognizedException.class})
    public void commandRemovedFromDefaultGroupWithGroupNames() {
        Cli parser = Cli.builder((String)"junk").withCommand(CommandWithGroupNames.class).build();
        parser.parse(new String[]{"commandWithGroupNames", "-i", "A.java"});
    }

    @Test(expectedExceptions={ParseCommandUnrecognizedException.class})
    public void commandRemovedFromDefaultGroupWithSubGroupNames() {
        Cli parser = Cli.builder((String)"junk").withCommand(CommandWithSubGroupNames.class).build();
        parser.parse(new String[]{"commandWithSubGroupNames", "-i", "A.java"});
    }
}

