/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline;

import com.github.rvesse.airline.Cli;
import com.github.rvesse.airline.Git;
import com.github.rvesse.airline.annotations.Group;
import com.github.rvesse.airline.builder.CliBuilder;
import com.github.rvesse.airline.builder.GroupBuilder;
import com.github.rvesse.airline.help.Help;
import com.github.rvesse.airline.model.CommandGroupMetadata;
import com.github.rvesse.airline.model.GlobalMetadata;
import com.github.rvesse.airline.parser.errors.ParseCommandMissingException;
import com.github.rvesse.airline.parser.errors.ParseCommandUnrecognizedException;
import com.github.rvesse.airline.utils.predicates.parser.GroupFinder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSubGroups {
    @Test
    public void sub_groups_01() {
        CliBuilder builder = Cli.builder((String)"test");
        builder.withGroup("foo").withSubGroup("bar").withDefaultCommand(Help.class);
        Cli cli = builder.build();
        GlobalMetadata global = cli.getMetadata();
        Assert.assertEquals((int)global.getDefaultGroupCommands().size(), (int)0);
        Assert.assertEquals((int)global.getCommandGroups().size(), (int)1);
        CommandGroupMetadata parentGroup = (CommandGroupMetadata)global.getCommandGroups().get(0);
        Assert.assertEquals((String)parentGroup.getName(), (String)"foo");
        Assert.assertEquals((int)parentGroup.getCommands().size(), (int)0);
        Assert.assertEquals((int)parentGroup.getSubGroups().size(), (int)1);
        CommandGroupMetadata subGroup = (CommandGroupMetadata)parentGroup.getSubGroups().get(0);
        Assert.assertEquals((Object)parentGroup, (Object)subGroup.getParent());
        Assert.assertEquals((String)subGroup.getName(), (String)"bar");
        Assert.assertEquals((Object)subGroup.getDefaultCommand().getType(), Help.class);
        Object cmd = cli.parse(new String[]{"foo", "bar"});
        Assert.assertTrue((boolean)(cmd instanceof Help));
    }

    @Test
    public void sub_groups_02() {
        CliBuilder builder = Cli.builder((String)"test");
        GroupBuilder fooBuilder = builder.withGroup("foo");
        fooBuilder.withSubGroup("bar").withDefaultCommand(Help.class);
        fooBuilder.withSubGroup("baz");
        Cli cli = builder.build();
        GlobalMetadata global = cli.getMetadata();
        Assert.assertEquals((int)global.getDefaultGroupCommands().size(), (int)0);
        Assert.assertEquals((int)global.getCommandGroups().size(), (int)1);
        CommandGroupMetadata parentGroup = (CommandGroupMetadata)global.getCommandGroups().get(0);
        Assert.assertNull((Object)parentGroup.getParent());
        Assert.assertEquals((String)parentGroup.getName(), (String)"foo");
        Assert.assertEquals((int)parentGroup.getCommands().size(), (int)0);
        Assert.assertEquals((int)parentGroup.getSubGroups().size(), (int)2);
        CommandGroupMetadata subGroup = (CommandGroupMetadata)CollectionUtils.find((Iterable)parentGroup.getSubGroups(), (Predicate)new GroupFinder("bar"));
        Assert.assertNotNull((Object)subGroup);
        Assert.assertEquals((Object)parentGroup, (Object)subGroup.getParent());
        Assert.assertEquals((String)subGroup.getName(), (String)"bar");
        Assert.assertEquals((int)subGroup.getCommands().size(), (int)1);
        Assert.assertEquals((Object)subGroup.getDefaultCommand().getType(), Help.class);
        subGroup = (CommandGroupMetadata)CollectionUtils.find((Iterable)parentGroup.getSubGroups(), (Predicate)new GroupFinder("baz"));
        Assert.assertNotNull((Object)subGroup);
        Assert.assertEquals((Object)parentGroup, (Object)subGroup.getParent());
        Assert.assertEquals((String)subGroup.getName(), (String)"baz");
        Assert.assertEquals((int)subGroup.getCommands().size(), (int)0);
        Assert.assertNull((Object)subGroup.getDefaultCommand());
        Object cmd = cli.parse(new String[]{"foo", "bar"});
        Assert.assertTrue((boolean)(cmd instanceof Help));
    }

    @Test(expectedExceptions={ParseCommandMissingException.class})
    public void sub_groups_03() {
        CliBuilder builder = Cli.builder((String)"test");
        GroupBuilder fooBuilder = builder.withGroup("foo");
        fooBuilder.withSubGroup("bar").withDefaultCommand(Help.class);
        fooBuilder.withSubGroup("baz");
        builder.build().parse(new String[]{"foo", "baz"});
    }

    @Test
    public void sub_groups_help_01() throws IOException {
        CliBuilder builder = Cli.builder((String)"test");
        builder.withGroup("foo").withSubGroup("bar").withDefaultCommand(Help.class);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Help.help((GlobalMetadata)builder.build().getMetadata(), Collections.emptyList(), (boolean)false, (OutputStream)output);
        String actual = new String(output.toByteArray());
        String expected = StringUtils.join((Object[])new String[]{"usage: test <command> [ <args> ]", "", "Commands are:", "    foo", "", "See 'test help <command>' for more information on a specific command.", ""}, (char)'\n');
        Assert.assertEquals((String)actual, (String)expected);
    }

    @Test
    public void sub_groups_help_02() throws IOException {
        CliBuilder builder = Cli.builder((String)"test");
        builder.withGroup("foo").withSubGroup("bar").withDefaultCommand(Help.class);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Help.help((GlobalMetadata)builder.build().getMetadata(), Arrays.asList("foo", "bar"), (boolean)false, (OutputStream)output);
        String actual = new String(output.toByteArray());
        String expected = StringUtils.join((Object[])new String[]{"NAME", "        test foo bar -", "", "SYNOPSIS", "        test foo bar { help* } [--] <cmd-args>", "", "        Where command-specific arguments <cmd-args> are:", "            help: [ <command>... ]", "", "        Where * indicates the default command(s)", "        See 'test help foo bar <command>' for more information on a specific command.", ""}, (char)'\n');
        Assert.assertEquals((String)actual, (String)expected);
    }

    @Test
    public void sub_groups_help_03() throws IOException {
        CliBuilder builder = Cli.builder((String)"test");
        builder.withGroup("foo").withSubGroup("bar").withDefaultCommand(Help.class);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Help.help((GlobalMetadata)builder.build().getMetadata(), Arrays.asList("foo"), (boolean)false, (OutputStream)output);
        String actual = new String(output.toByteArray());
        String expected = StringUtils.join((Object[])new String[]{"NAME", "        test foo -", "", "SYNOPSIS", "        test foo { bar <sub-command> } [--]", "", "        Where command groups contain the following sub-groups and commands:", "            bar: help*", "", "        Where * indicates the default command(s)", "        See 'test help foo <command>' for more information on a specific command.", ""}, (char)'\n');
        Assert.assertEquals((String)actual, (String)expected);
    }

    @Test
    public void sub_groups_cli_annotation_01() {
        Cli cli = new Cli(SubGroupsCli01.class);
        GlobalMetadata global = cli.getMetadata();
        Assert.assertEquals((int)global.getDefaultGroupCommands().size(), (int)0);
        Assert.assertEquals((int)global.getCommandGroups().size(), (int)1);
        CommandGroupMetadata parentGroup = (CommandGroupMetadata)global.getCommandGroups().get(0);
        Assert.assertEquals((String)parentGroup.getName(), (String)"foo");
        Assert.assertEquals((int)parentGroup.getCommands().size(), (int)0);
        Assert.assertEquals((int)parentGroup.getSubGroups().size(), (int)1);
        CommandGroupMetadata subGroup = (CommandGroupMetadata)parentGroup.getSubGroups().get(0);
        Assert.assertEquals((Object)parentGroup, (Object)subGroup.getParent());
        Assert.assertEquals((String)subGroup.getName(), (String)"bar");
        Assert.assertEquals((Object)subGroup.getDefaultCommand().getType(), Help.class);
        Object cmd = cli.parse(new String[]{"foo", "bar"});
        Assert.assertTrue((boolean)(cmd instanceof Help));
    }

    @Test
    public void sub_groups_cli_annotation_02() {
        Cli cli = new Cli(SubGroupsCli02.class);
        GlobalMetadata global = cli.getMetadata();
        Assert.assertEquals((int)global.getDefaultGroupCommands().size(), (int)0);
        Assert.assertEquals((int)global.getCommandGroups().size(), (int)1);
        CommandGroupMetadata parentGroup = (CommandGroupMetadata)global.getCommandGroups().get(0);
        Assert.assertNull((Object)parentGroup.getParent());
        Assert.assertEquals((String)parentGroup.getName(), (String)"foo");
        Assert.assertEquals((int)parentGroup.getCommands().size(), (int)0);
        Assert.assertEquals((int)parentGroup.getSubGroups().size(), (int)2);
        CommandGroupMetadata subGroup = (CommandGroupMetadata)CollectionUtils.find((Iterable)parentGroup.getSubGroups(), (Predicate)new GroupFinder("bar"));
        Assert.assertNotNull((Object)subGroup);
        Assert.assertEquals((Object)parentGroup, (Object)subGroup.getParent());
        Assert.assertEquals((String)subGroup.getName(), (String)"bar");
        Assert.assertEquals((int)subGroup.getCommands().size(), (int)1);
        Assert.assertEquals((Object)subGroup.getDefaultCommand().getType(), Help.class);
        subGroup = (CommandGroupMetadata)CollectionUtils.find((Iterable)parentGroup.getSubGroups(), (Predicate)new GroupFinder("baz"));
        Assert.assertNotNull((Object)subGroup);
        Assert.assertEquals((Object)parentGroup, (Object)subGroup.getParent());
        Assert.assertEquals((String)subGroup.getName(), (String)"baz");
        Assert.assertEquals((int)subGroup.getCommands().size(), (int)0);
        Assert.assertNull((Object)subGroup.getDefaultCommand());
        Object cmd = cli.parse(new String[]{"foo", "bar"});
        Assert.assertTrue((boolean)(cmd instanceof Help));
    }

    @Test(expectedExceptions={ParseCommandMissingException.class})
    public void sub_groups_cli_annotation_03() {
        Cli cli = new Cli(SubGroupsCli02.class);
        cli.parse(new String[]{"foo", "baz"});
    }

    @Test(timeOut=3000L)
    public void sub_groups_mixed_01() {
        CliBuilder builder = Cli.builder((String)"test");
        builder.withGroup("foo").withCommand(Git.Add.class).withSubGroup("bar").withDefaultCommand(Help.class);
        Cli cli = builder.build();
        GlobalMetadata global = cli.getMetadata();
        Assert.assertEquals((int)global.getDefaultGroupCommands().size(), (int)0);
        Assert.assertEquals((int)global.getCommandGroups().size(), (int)1);
        CommandGroupMetadata parentGroup = (CommandGroupMetadata)global.getCommandGroups().get(0);
        Assert.assertEquals((String)parentGroup.getName(), (String)"foo");
        Assert.assertEquals((int)parentGroup.getCommands().size(), (int)1);
        Assert.assertEquals((int)parentGroup.getSubGroups().size(), (int)1);
        CommandGroupMetadata subGroup = (CommandGroupMetadata)parentGroup.getSubGroups().get(0);
        Assert.assertEquals((Object)parentGroup, (Object)subGroup.getParent());
        Assert.assertEquals((String)subGroup.getName(), (String)"bar");
        Assert.assertEquals((Object)subGroup.getDefaultCommand().getType(), Help.class);
        Object cmd = cli.parse(new String[]{"foo", "add"});
        Assert.assertTrue((boolean)(cmd instanceof Git.Add));
    }

    @Test(timeOut=3000L)
    public void sub_groups_mixed_02() {
        CliBuilder builder = Cli.builder((String)"test");
        builder.withGroup("foo").withCommand(Git.Add.class).withSubGroup("bar").withDefaultCommand(Help.class);
        Cli cli = builder.build();
        GlobalMetadata global = cli.getMetadata();
        Assert.assertEquals((int)global.getDefaultGroupCommands().size(), (int)0);
        Assert.assertEquals((int)global.getCommandGroups().size(), (int)1);
        CommandGroupMetadata parentGroup = (CommandGroupMetadata)global.getCommandGroups().get(0);
        Assert.assertEquals((String)parentGroup.getName(), (String)"foo");
        Assert.assertEquals((int)parentGroup.getCommands().size(), (int)1);
        Assert.assertEquals((int)parentGroup.getSubGroups().size(), (int)1);
        CommandGroupMetadata subGroup = (CommandGroupMetadata)parentGroup.getSubGroups().get(0);
        Assert.assertEquals((Object)parentGroup, (Object)subGroup.getParent());
        Assert.assertEquals((String)subGroup.getName(), (String)"bar");
        Assert.assertEquals((Object)subGroup.getDefaultCommand().getType(), Help.class);
        Object cmd = cli.parse(new String[]{"foo", "bar"});
        Assert.assertTrue((boolean)(cmd instanceof Help));
    }

    @Test(timeOut=3000L, expectedExceptions={ParseCommandUnrecognizedException.class})
    public void sub_groups_mixed_03() {
        CliBuilder builder = Cli.builder((String)"test");
        builder.withGroup("foo").withCommand(Git.Add.class).withSubGroup("bar").withDefaultCommand(Help.class);
        Cli cli = builder.build();
        GlobalMetadata global = cli.getMetadata();
        Assert.assertEquals((int)global.getDefaultGroupCommands().size(), (int)0);
        Assert.assertEquals((int)global.getCommandGroups().size(), (int)1);
        CommandGroupMetadata parentGroup = (CommandGroupMetadata)global.getCommandGroups().get(0);
        Assert.assertEquals((String)parentGroup.getName(), (String)"foo");
        Assert.assertEquals((int)parentGroup.getCommands().size(), (int)1);
        Assert.assertEquals((int)parentGroup.getSubGroups().size(), (int)1);
        CommandGroupMetadata subGroup = (CommandGroupMetadata)parentGroup.getSubGroups().get(0);
        Assert.assertEquals((Object)parentGroup, (Object)subGroup.getParent());
        Assert.assertEquals((String)subGroup.getName(), (String)"bar");
        Assert.assertEquals((Object)subGroup.getDefaultCommand().getType(), Help.class);
        cli.parse(new String[]{"foo", "missing"});
    }

    @Test(timeOut=3000L)
    public void sub_groups_mixed_04() {
        CliBuilder builder = Cli.builder((String)"test");
        builder.withGroup("foo").withCommand(Git.Add.class).withSubGroup("bar").withCommand(Git.RemoteShow.class).withSubGroup("faz").withDefaultCommand(Help.class);
        Cli cli = builder.build();
        GlobalMetadata global = cli.getMetadata();
        Assert.assertEquals((int)global.getDefaultGroupCommands().size(), (int)0);
        Assert.assertEquals((int)global.getCommandGroups().size(), (int)1);
        CommandGroupMetadata parentGroup = (CommandGroupMetadata)global.getCommandGroups().get(0);
        Assert.assertEquals((String)parentGroup.getName(), (String)"foo");
        Assert.assertEquals((int)parentGroup.getCommands().size(), (int)1);
        Assert.assertEquals((int)parentGroup.getSubGroups().size(), (int)1);
        CommandGroupMetadata subGroup = (CommandGroupMetadata)parentGroup.getSubGroups().get(0);
        Assert.assertEquals((Object)parentGroup, (Object)subGroup.getParent());
        Assert.assertEquals((String)subGroup.getName(), (String)"bar");
        Assert.assertEquals((int)subGroup.getCommands().size(), (int)1);
        CommandGroupMetadata leafGroup = (CommandGroupMetadata)subGroup.getSubGroups().get(0);
        Assert.assertEquals((Object)subGroup, (Object)leafGroup.getParent());
        Assert.assertEquals((String)leafGroup.getName(), (String)"faz");
        Assert.assertEquals((Object)leafGroup.getDefaultCommand().getType(), Help.class);
        Object cmd = cli.parse(new String[]{"foo", "bar", "faz"});
        Assert.assertTrue((boolean)(cmd instanceof Help));
        cmd = cli.parse(new String[]{"foo", "add"});
        Assert.assertTrue((boolean)(cmd instanceof Git.Add));
        cmd = cli.parse(new String[]{"foo", "bar", "show"});
        Assert.assertTrue((boolean)(cmd instanceof Git.RemoteShow));
    }

    @com.github.rvesse.airline.annotations.Cli(name="test", groups={@Group(name="foo bar", defaultCommand=Help.class, commands={Help.class}), @Group(name="foo baz")})
    private static class SubGroupsCli02 {
        private SubGroupsCli02() {
        }
    }

    @com.github.rvesse.airline.annotations.Cli(name="test", groups={@Group(name="foo bar", defaultCommand=Help.class, commands={Help.class})})
    private static class SubGroupsCli01 {
        private SubGroupsCli01() {
        }
    }
}

