/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline;

import com.github.rvesse.airline.Cli;
import com.github.rvesse.airline.args.ArgsGlobal;
import com.github.rvesse.airline.builder.CliBuilder;
import com.github.rvesse.airline.parser.ParseResult;
import com.github.rvesse.airline.parser.errors.handlers.CollectAll;
import com.github.rvesse.airline.parser.errors.handlers.ParserErrorHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestOptionScope {
    private Cli<ArgsGlobal> createCli() {
        CliBuilder builder = ((CliBuilder)new CliBuilder("test").withGroup("group").withCommand(ArgsGlobal.class).parent()).withCommand(ArgsGlobal.class);
        builder.withParser().withErrorHandler((ParserErrorHandler)new CollectAll());
        return builder.build();
    }

    @Test
    public void option_scope_global_01() {
        Cli<ArgsGlobal> cli = this.createCli();
        ArgsGlobal cmd = (ArgsGlobal)cli.parse(new String[]{"--global", "command"});
        Assert.assertTrue((boolean)cmd.global);
    }

    @Test
    public void option_scope_global_02() {
        Cli<ArgsGlobal> cli = this.createCli();
        ArgsGlobal cmd = (ArgsGlobal)cli.parse(new String[]{"group", "--global", "command"});
        Assert.assertTrue((boolean)cmd.global);
    }

    @Test
    public void option_scope_global_03() {
        Cli<ArgsGlobal> cli = this.createCli();
        ArgsGlobal cmd = (ArgsGlobal)cli.parse(new String[]{"group", "command", "--global"});
        Assert.assertTrue((boolean)cmd.global);
    }

    @Test
    public void option_scope_group_01() {
        Cli<ArgsGlobal> cli = this.createCli();
        ParseResult result = cli.parseWithResult(new String[]{"--group"});
        Assert.assertFalse((boolean)result.wasSuccessful());
    }

    @Test
    public void option_scope_group_02() {
        Cli<ArgsGlobal> cli = this.createCli();
        ArgsGlobal cmd = (ArgsGlobal)cli.parse(new String[]{"group", "--group", "command"});
        Assert.assertTrue((boolean)cmd.group);
    }

    @Test
    public void option_scope_group_03() {
        Cli<ArgsGlobal> cli = this.createCli();
        ArgsGlobal cmd = (ArgsGlobal)cli.parse(new String[]{"group", "command", "--group"});
        Assert.assertTrue((boolean)cmd.group);
    }

    @Test
    public void option_scope_command_01() {
        Cli<ArgsGlobal> cli = this.createCli();
        ParseResult result = cli.parseWithResult(new String[]{"--command"});
        Assert.assertFalse((boolean)result.wasSuccessful());
    }

    @Test
    public void option_scope_command_02() {
        Cli<ArgsGlobal> cli = this.createCli();
        ParseResult result = cli.parseWithResult(new String[]{"group", "--command", "command"});
        Assert.assertFalse((boolean)result.wasSuccessful());
    }

    @Test
    public void option_scope_command_03() {
        Cli<ArgsGlobal> cli = this.createCli();
        ArgsGlobal cmd = (ArgsGlobal)cli.parse(new String[]{"group", "command", "--command"});
        Assert.assertTrue((boolean)cmd.command);
    }
}

