/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline;

import com.github.rvesse.airline.Cli;
import com.github.rvesse.airline.Git;
import com.github.rvesse.airline.SingleCommand;
import com.github.rvesse.airline.args.Args1;
import com.github.rvesse.airline.args.Args2;
import com.github.rvesse.airline.args.ArgsAllowedValues;
import com.github.rvesse.airline.args.ArgsArityString;
import com.github.rvesse.airline.args.ArgsArityStringPartialTitles;
import com.github.rvesse.airline.args.ArgsBooleanArity;
import com.github.rvesse.airline.args.ArgsCopyrightAndLicense;
import com.github.rvesse.airline.args.ArgsExamples;
import com.github.rvesse.airline.args.ArgsExitCodes;
import com.github.rvesse.airline.args.ArgsHiddenDiscussion;
import com.github.rvesse.airline.args.ArgsInherited;
import com.github.rvesse.airline.args.ArgsInheritedDiscussion;
import com.github.rvesse.airline.args.ArgsMultiLineDescription;
import com.github.rvesse.airline.args.ArgsMultiParagraphDiscussion;
import com.github.rvesse.airline.args.ArgsRequired;
import com.github.rvesse.airline.args.ArgsRestoredDiscussion;
import com.github.rvesse.airline.args.ArgsVersion;
import com.github.rvesse.airline.args.ArgsVersion2;
import com.github.rvesse.airline.args.ArgsVersion3;
import com.github.rvesse.airline.args.ArgsVersionMissing;
import com.github.rvesse.airline.args.ArgsVersionMissingSuppressed;
import com.github.rvesse.airline.args.CommandHidden;
import com.github.rvesse.airline.args.GlobalOptionsHidden;
import com.github.rvesse.airline.args.OptionsHidden;
import com.github.rvesse.airline.args.OptionsRequired;
import com.github.rvesse.airline.builder.CliBuilder;
import com.github.rvesse.airline.command.CommandRemove;
import com.github.rvesse.airline.help.Help;
import com.github.rvesse.airline.help.UsageHelper;
import com.github.rvesse.airline.help.cli.CliCommandUsageGenerator;
import com.github.rvesse.airline.help.cli.CliGlobalUsageGenerator;
import com.github.rvesse.airline.help.cli.CliGlobalUsageSummaryGenerator;
import com.github.rvesse.airline.help.sections.CliWithSections;
import com.github.rvesse.airline.help.sections.HelpSection;
import com.github.rvesse.airline.help.sections.common.VersionSection;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.GlobalMetadata;
import com.github.rvesse.airline.parser.resources.ClasspathLocator;
import com.github.rvesse.airline.parser.resources.ResourceLocator;
import com.github.rvesse.airline.restrictions.partial.PartialAnnotated;
import com.github.rvesse.airline.utils.predicates.parser.CommandFinder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test
public class TestHelp {
    private final Charset utf8 = Charset.forName("utf-8");

    private void testStringAssert(String actual, String expected) {
        if (!actual.equals(expected)) {
            if (actual.length() != expected.length()) {
                System.err.println("Different lengths, expected " + expected.length() + " but got " + actual.length());
            }
            for (int i = 0; i < expected.length(); ++i) {
                char e = expected.charAt(i);
                if (i >= actual.length()) {
                    System.err.println("Expected character '" + e + "' (Code " + e + ") is at position " + i + " which is beyond the length of the actual string");
                    break;
                }
                char a = actual.charAt(i);
                if (e == a) continue;
                System.err.println("Expected character '" + e + "' (Code " + e + ") at position " + i + " does not match actual character '" + a + "' (Code " + a + ")");
                int start = Math.max(0, i - 10);
                int end = Math.min(expected.length(), i + 10);
                System.err.println("Expected Context:");
                System.err.println(expected.substring(start, end));
                System.err.println("Actual Context:");
                end = Math.min(actual.length(), i + 10);
                System.err.println(actual.substring(start, end));
                break;
            }
        }
        Assert.assertEquals((String)actual, (String)expected);
    }

    public void testMultiLineDescriptions() throws IOException {
        SingleCommand cmd = SingleCommand.singleCommand(ArgsMultiLineDescription.class);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Help.help((CommandMetadata)cmd.getCommandMetadata(), (OutputStream)out);
        Assert.assertEquals((String)new String(out.toByteArray(), this.utf8), (String)"NAME\n        ArgsMultiLineDescription - Has\n        some\n        new lines\n\nSYNOPSIS\n        ArgsMultiLineDescription [ -v ]\n\nOPTIONS\n        -v\n            Verbose descriptions\n            have new lines\n\n");
    }

    public void testMultiParagraphDiscussion() throws IOException {
        SingleCommand cmd = SingleCommand.singleCommand(ArgsMultiParagraphDiscussion.class);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Help.help((CommandMetadata)cmd.getCommandMetadata(), (OutputStream)out);
        this.testStringAssert(new String(out.toByteArray(), this.utf8), "NAME\n        ArgsMultiParagraphDiscussion -\n\nSYNOPSIS\n        ArgsMultiParagraphDiscussion\n\nDISCUSSION\n        First paragraph\n\n        Middle paragraph\n\n        Final paragraph\n\n");
    }

    public void testInheritedDiscussion() throws IOException {
        SingleCommand cmd = SingleCommand.singleCommand(ArgsInheritedDiscussion.class);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Help.help((CommandMetadata)cmd.getCommandMetadata(), (OutputStream)out);
        this.testStringAssert(new String(out.toByteArray(), this.utf8), "NAME\n        ArgsInheritedDiscussion -\n\nSYNOPSIS\n        ArgsInheritedDiscussion\n\nDISCUSSION\n        First paragraph\n\n        Middle paragraph\n\n        Final paragraph\n\n");
    }

    public void testHiddenDiscussion() throws IOException {
        SingleCommand cmd = SingleCommand.singleCommand(ArgsHiddenDiscussion.class);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Help.help((CommandMetadata)cmd.getCommandMetadata(), (OutputStream)out);
        this.testStringAssert(new String(out.toByteArray(), this.utf8), "NAME\n        ArgsHiddenDiscussion -\n\nSYNOPSIS\n        ArgsHiddenDiscussion\n\n");
    }

    public void testRestoredDiscussion() throws IOException {
        SingleCommand cmd = SingleCommand.singleCommand(ArgsRestoredDiscussion.class);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Help.help((CommandMetadata)cmd.getCommandMetadata(), (OutputStream)out);
        this.testStringAssert(new String(out.toByteArray(), this.utf8), "NAME\n        ArgsRestoredDiscussion -\n\nSYNOPSIS\n        ArgsRestoredDiscussion\n\nDISCUSSION\n        Restored\n\n");
    }

    public void testExamples() throws IOException {
        SingleCommand cmd = SingleCommand.singleCommand(ArgsExamples.class);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Help.help((CommandMetadata)cmd.getCommandMetadata(), (OutputStream)out);
        this.testStringAssert(new String(out.toByteArray(), this.utf8), "NAME\n        ArgsExamples -\n\nSYNOPSIS\n        ArgsExamples\n\nEXAMPLES\n        ArgsExample\n\n            Does nothing\n\n        ArgsExample foo bar\n\n            Foos a bar\n\n");
    }

    public void testCopyrightLicense() throws IOException {
        SingleCommand cmd = SingleCommand.singleCommand(ArgsCopyrightAndLicense.class);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Help.help((CommandMetadata)cmd.getCommandMetadata(), (OutputStream)out);
        this.testStringAssert(new String(out.toByteArray(), this.utf8), "NAME\n        ArgsCopyrightAndLicense -\n\nSYNOPSIS\n        ArgsCopyrightAndLicense\n\nCOPYRIGHT\n        Copyright (c) Acme Inc 2015-2016\n\nLICENSE\n        This software is open source under the Apache License 2.0\n\n        Please see http://apache.org/licenses/LICENSE-2.0 for more information\n\n");
    }

    public void testGit() throws IOException {
        CliBuilder builder = Cli.builder((String)"git").withDescription("the stupid content tracker").withDefaultCommand(Help.class).withCommand(Help.class).withCommand(Git.Add.class);
        builder.withGroup("remote").withDescription("Manage set of tracked repositories").withDefaultCommand(Git.RemoteShow.class).withCommand(Git.RemoteShow.class).withCommand(Git.RemoteAdd.class);
        Cli gitParser = builder.build();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Help.help((GlobalMetadata)gitParser.getMetadata(), Collections.emptyList(), (OutputStream)out);
        Assert.assertEquals((String)new String(out.toByteArray(), this.utf8), (String)"usage: git [ -v ] <command> [ <args> ]\n\nCommands are:\n    add      Add file contents to the index\n    help     Display help information\n    remote   Manage set of tracked repositories\n\nSee 'git help <command>' for more information on a specific command.\n");
        out = new ByteArrayOutputStream();
        Help.help((GlobalMetadata)gitParser.getMetadata(), Collections.singletonList("add"), (OutputStream)out);
        Assert.assertEquals((String)new String(out.toByteArray(), this.utf8), (String)"NAME\n        git add - Add file contents to the index\n\nSYNOPSIS\n        git [ -v ] add [ -i ] [--] [ <patterns>... ]\n\nOPTIONS\n        -i\n            Add modified contents interactively.\n\n        -v\n            Verbose mode\n\n        --\n            This option can be used to separate command-line options from the\n            list of arguments (useful when arguments might be mistaken for\n            command-line options)\n\n        <patterns>\n            Patterns of files to be added\n\n");
        out = new ByteArrayOutputStream();
        Help.help((GlobalMetadata)gitParser.getMetadata(), Collections.singletonList("remote"), (OutputStream)out);
        Assert.assertEquals((String)new String(out.toByteArray(), this.utf8), (String)"NAME\n        git remote - Manage set of tracked repositories\n\nSYNOPSIS\n        git [ -v ] remote { add | show* } [--] [cmd-options] <cmd-args>\n\n        Where command-specific options [cmd-options] are:\n            add: [ -t <branch> ]\n            show: [ -n ]\n\n        Where command-specific arguments <cmd-args> are:\n            add: [ <name> <url>... ]\n            show: [ <remote> ]\n\n        Where * indicates the default command(s)\n        See 'git help remote <command>' for more information on a specific command.\nOPTIONS\n        -v\n            Verbose mode\n\n");
        out = new ByteArrayOutputStream();
        Help.help((GlobalMetadata)gitParser.getMetadata(), Arrays.asList("remote", "add"), (OutputStream)out);
        Assert.assertEquals((String)new String(out.toByteArray(), this.utf8), (String)"NAME\n        git remote add - Adds a remote\n\nSYNOPSIS\n        git [ -v ] remote add [ -t <branch> ] [--] [ <name> <url>... ]\n\nOPTIONS\n        -t <branch>\n            Track only a specific branch\n\n        -v\n            Verbose mode\n\n        --\n            This option can be used to separate command-line options from the\n            list of arguments (useful when arguments might be mistaken for\n            command-line options)\n\n        <name> <url>\n            Name and URL of remote repository to add\n\n");
    }

    @Test
    public void testArgs1() throws IOException {
        CliBuilder builder = Cli.builder((String)"test").withDescription("Test commandline").withDefaultCommand(Help.class).withCommands(Help.class, new Class[]{Args1.class});
        Cli parser = builder.build();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Help.help((GlobalMetadata)parser.getMetadata(), Collections.singletonList("Args1"), (OutputStream)out);
        this.testStringAssert(new String(out.toByteArray(), this.utf8), "NAME\n        test Args1 - args1 description\n\nSYNOPSIS\n        test Args1 [ -bigdecimal <bigd> ] [ -date <date> ] [ -debug ]\n                [ -double <doub> ] [ -float <floa> ] [ -groups <groups> ]\n                [ {-log | -verbose} <verbose> ] [ -long <l> ] [--] [ <parameters>... ]\n\nOPTIONS\n        -bigdecimal <bigd>\n            A BigDecimal number\n\n        -date <date>\n            An ISO 8601 formatted date.\n\n        -debug\n            Debug mode\n\n        -double <doub>\n            A double number\n\n        -float <floa>\n            A float number\n\n        -groups <groups>\n            Comma-separated list of group names to be run\n\n        -log <verbose>, -verbose <verbose>\n            Level of verbosity\n\n        -long <l>\n            A long number\n\n        --\n            This option can be used to separate command-line options from the\n            list of arguments (useful when arguments might be mistaken for\n            command-line options)\n\n        <parameters>\n\n\n");
    }

    @Test
    public void testArgs2() throws IOException {
        CliBuilder builder = Cli.builder((String)"test").withDescription("Test commandline").withDefaultCommand(Help.class).withCommands(Help.class, new Class[]{Args2.class});
        Cli parser = builder.build();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Help.help((GlobalMetadata)parser.getMetadata(), Collections.singletonList("Args2"), (OutputStream)out);
        Assert.assertEquals((String)new String(out.toByteArray(), this.utf8), (String)"NAME\n        test Args2 -\n\nSYNOPSIS\n        test Args2 [ -debug ] [ -groups <groups> ] [ -host <hosts>... ]\n                [ {-log | -verbose} <verbose> ] [--] [ <parameters>... ]\n\nOPTIONS\n        -debug\n            Debug mode\n\n        -groups <groups>\n            Comma-separated list of group names to be run\n\n        -host <hosts>\n            The host\n\n        -log <verbose>, -verbose <verbose>\n            Level of verbosity\n\n        --\n            This option can be used to separate command-line options from the\n            list of arguments (useful when arguments might be mistaken for\n            command-line options)\n\n        <parameters>\n            List of parameters\n\n");
    }

    @Test
    public void testArgsAllowedValues() throws IOException {
        SingleCommand command = SingleCommand.singleCommand(ArgsAllowedValues.class);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        new CliCommandUsageGenerator().usage("test", null, command.getCommandMetadata().getName(), command.getCommandMetadata(), null, (OutputStream)out);
        Assert.assertEquals((String)new String(out.toByteArray(), this.utf8), (String)"NAME\n        test ArgsAllowedValues - ArgsAllowedValues description\n\nSYNOPSIS\n        test ArgsAllowedValues [ -mode <mode> ]\n\nOPTIONS\n        -mode <mode>\n            A string from a restricted set of values\n\n            This options value is restricted to the following set of values:\n                a\n                b\n                c\n\n");
    }

    @Test
    public void testPartialRestriction() throws IOException {
        SingleCommand command = SingleCommand.singleCommand(PartialAnnotated.class);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        new CliCommandUsageGenerator().usage("test", null, command.getCommandMetadata().getName(), command.getCommandMetadata(), null, (OutputStream)out);
        Assert.assertEquals((String)new String(out.toByteArray()), (String)StringUtils.join((Object[])new String[]{"NAME", "        test partial -", "", "SYNOPSIS", "        test partial [ --kvp <Key> <Value>... ] [--] [ <args>... ]", "", "OPTIONS", "        --kvp <Key> <Value>", "", "", "            The following restriction only applies to the 1st value:", "            This options value cannot be blank (empty or all whitespace)", "", "", "        --", "            This option can be used to separate command-line options from the", "            list of arguments (useful when arguments might be mistaken for", "            command-line options)", "", "        <args>", "", "", ""}, (char)'\n'));
    }

    @Test
    public void testArgsAritySting() throws IOException {
        CliBuilder builder = Cli.builder((String)"test").withDescription("Test commandline").withDefaultCommand(Help.class).withCommands(Help.class, new Class[]{ArgsArityString.class});
        Cli parser = builder.build();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Help.help((GlobalMetadata)parser.getMetadata(), Collections.singletonList("ArgsArityString"), (OutputStream)out);
        Assert.assertEquals((String)new String(out.toByteArray(), this.utf8), (String)"NAME\n        test ArgsArityString -\n\nSYNOPSIS\n        test ArgsArityString [ -pairs <Key> <Value>... ] [--] [ <rest>... ]\n\nOPTIONS\n        -pairs <Key> <Value>\n            Pairs\n\n        --\n            This option can be used to separate command-line options from the\n            list of arguments (useful when arguments might be mistaken for\n            command-line options)\n\n        <rest>\n            Rest\n\n");
    }

    @Test
    public void testArgsArityStingPartialTitles() throws IOException {
        CliBuilder builder = Cli.builder((String)"test").withDescription("Test commandline").withDefaultCommand(Help.class).withCommands(Help.class, new Class[]{ArgsArityStringPartialTitles.class});
        Cli parser = builder.build();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Help.help((GlobalMetadata)parser.getMetadata(), Collections.singletonList("ArgsArityStringPartialTitles"), (OutputStream)out);
        Assert.assertEquals((String)new String(out.toByteArray(), this.utf8), (String)"NAME\n        test ArgsArityStringPartialTitles -\n\nSYNOPSIS\n        test ArgsArityStringPartialTitles [ -pairs <Value> <Value>... ] [--] [ <rest>... ]\n\nOPTIONS\n        -pairs <Value> <Value>\n            Pairs\n\n        --\n            This option can be used to separate command-line options from the\n            list of arguments (useful when arguments might be mistaken for\n            command-line options)\n\n        <rest>\n            Rest\n\n");
    }

    @Test
    public void testArgsBooleanArity() throws IOException {
        CliBuilder builder = Cli.builder((String)"test").withDescription("Test commandline").withDefaultCommand(Help.class).withCommands(Help.class, new Class[]{ArgsBooleanArity.class});
        Cli parser = builder.build();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Help.help((GlobalMetadata)parser.getMetadata(), Collections.singletonList("ArgsBooleanArity"), (OutputStream)out);
        Assert.assertEquals((String)new String(out.toByteArray(), this.utf8), (String)"NAME\n        test ArgsBooleanArity -\n\nSYNOPSIS\n        test ArgsBooleanArity [ -debug <debug> ]\n\nOPTIONS\n        -debug <debug>\n\n\n");
    }

    @Test
    public void testArgsInherited() throws IOException {
        CliBuilder builder = Cli.builder((String)"test").withDescription("Test commandline").withDefaultCommand(Help.class).withCommands(Help.class, new Class[]{ArgsInherited.class});
        Cli parser = builder.build();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Help.help((GlobalMetadata)parser.getMetadata(), Collections.singletonList("ArgsInherited"), (OutputStream)out);
        Assert.assertEquals((String)new String(out.toByteArray(), this.utf8), (String)"NAME\n        test ArgsInherited -\n\nSYNOPSIS\n        test ArgsInherited [ -child <child> ] [ -debug ] [ -groups <groups> ]\n                [ -level <level> ] [ -log <log> ] [--] [ <parameters>... ]\n\nOPTIONS\n        -child <child>\n            Child parameter\n\n        -debug\n            Debug mode\n\n        -groups <groups>\n            Comma-separated list of group names to be run\n\n        -level <level>\n            A long number\n\n        -log <log>\n            Level of verbosity\n\n        --\n            This option can be used to separate command-line options from the\n            list of arguments (useful when arguments might be mistaken for\n            command-line options)\n\n        <parameters>\n\n\n");
    }

    @Test
    public void testArgsRequired() throws IOException {
        CliBuilder builder = Cli.builder((String)"test").withDescription("Test commandline").withDefaultCommand(Help.class).withCommands(Help.class, new Class[]{ArgsRequired.class});
        Cli parser = builder.build();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Help.help((GlobalMetadata)parser.getMetadata(), Collections.singletonList("ArgsRequired"), (OutputStream)out);
        Assert.assertEquals((String)new String(out.toByteArray(), this.utf8), (String)"NAME\n        test ArgsRequired -\n\nSYNOPSIS\n        test ArgsRequired [--] <parameters>...\n\nOPTIONS\n        --\n            This option can be used to separate command-line options from the\n            list of arguments (useful when arguments might be mistaken for\n            command-line options)\n\n        <parameters>\n            List of files\n\n");
    }

    @Test
    public void testOptionsRequired() throws IOException {
        CliBuilder builder = Cli.builder((String)"test").withDescription("Test commandline").withDefaultCommand(Help.class).withCommands(Help.class, new Class[]{OptionsRequired.class});
        Cli parser = builder.build();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Help.help((GlobalMetadata)parser.getMetadata(), Collections.singletonList("OptionsRequired"), (OutputStream)out);
        Assert.assertEquals((String)new String(out.toByteArray(), this.utf8), (String)"NAME\n        test OptionsRequired -\n\nSYNOPSIS\n        test OptionsRequired [ --optional <optionalOption> ]\n                --required <requiredOption>\n\nOPTIONS\n        --optional <optionalOption>\n\n\n        --required <requiredOption>\n\n\n");
    }

    @Test
    public void testOptionsHidden01() throws IOException {
        CliBuilder builder = Cli.builder((String)"test").withDescription("Test commandline").withDefaultCommand(Help.class).withCommands(Help.class, new Class[]{OptionsHidden.class});
        Cli parser = builder.build();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Help.help((GlobalMetadata)parser.getMetadata(), Collections.singletonList("OptionsHidden"), (OutputStream)out);
        Assert.assertEquals((String)new String(out.toByteArray(), this.utf8), (String)"NAME\n        test OptionsHidden -\n\nSYNOPSIS\n        test OptionsHidden [ --optional <optionalOption> ]\n\nOPTIONS\n        --optional <optionalOption>\n\n\n");
    }

    @Test
    public void testOptionsHidden02() throws IOException {
        CliBuilder builder = Cli.builder((String)"test").withDescription("Test commandline").withDefaultCommand(Help.class).withCommands(Help.class, new Class[]{OptionsHidden.class});
        Cli parser = builder.build();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        CliCommandUsageGenerator generator = new CliCommandUsageGenerator(true);
        CommandMetadata metadata = (CommandMetadata)CollectionUtils.find((Iterable)parser.getMetadata().getDefaultGroupCommands(), (Predicate)new CommandFinder("OptionsHidden"));
        Assert.assertNotNull((Object)metadata);
        generator.usage("test", null, "OptionsHidden", metadata, null, (OutputStream)out);
        Assert.assertEquals((String)new String(out.toByteArray(), this.utf8), (String)"NAME\n        test OptionsHidden -\n\nSYNOPSIS\n        test OptionsHidden [ --hidden <hiddenOption> ]\n                [ --optional <optionalOption> ]\n\nOPTIONS\n        --hidden <hiddenOption>\n\n\n        --optional <optionalOption>\n\n\n");
    }

    @Test
    public void testGlobalOptionsHidden() throws IOException {
        CliBuilder builder = Cli.builder((String)"test").withDescription("Test commandline").withDefaultCommand(Help.class).withCommands(Help.class, new Class[]{GlobalOptionsHidden.class});
        Cli parser = builder.build();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Help.help((GlobalMetadata)parser.getMetadata(), Collections.singletonList("GlobalOptionsHidden"), (OutputStream)out);
        Assert.assertEquals((String)new String(out.toByteArray(), this.utf8), (String)"NAME\n        test GlobalOptionsHidden -\n\nSYNOPSIS\n        test [ {-op | --optional} ] GlobalOptionsHidden\n\nOPTIONS\n        -op, --optional\n\n\n");
    }

    @Test
    public void testCommandHidden() throws IOException {
        CliBuilder builder = Cli.builder((String)"test").withDescription("Test commandline").withDefaultCommand(Help.class).withCommands(Help.class, new Class[]{ArgsRequired.class, CommandHidden.class});
        Cli parser = builder.build();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Help.help((GlobalMetadata)parser.getMetadata(), Collections.emptyList(), (OutputStream)out);
        Assert.assertEquals((String)new String(out.toByteArray(), this.utf8), (String)"usage: test <command> [ <args> ]\n\nCommands are:\n    ArgsRequired\n    help           Display help information\n\nSee 'test help <command>' for more information on a specific command.\n");
        out = new ByteArrayOutputStream();
        Help.help((GlobalMetadata)parser.getMetadata(), Collections.singletonList("CommandHidden"), (OutputStream)out);
        Assert.assertEquals((String)new String(out.toByteArray(), this.utf8), (String)"NAME\n        test CommandHidden -\n\nSYNOPSIS\n        test CommandHidden [ --optional <optionalOption> ]\n\nOPTIONS\n        --optional <optionalOption>\n\n\n");
    }

    @Test
    public void testGroups() throws IOException {
        CliBuilder builder = Cli.builder((String)"test").withDescription("Test commandline").withCommand(Help.class);
        builder.withGroup("visible").withDescription("Visible group").withCommands(ArgsRequired.class, new Class[0]);
        Cli parser = builder.build();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Help.help((GlobalMetadata)parser.getMetadata(), Collections.emptyList(), (OutputStream)out);
        Assert.assertEquals((String)new String(out.toByteArray(), this.utf8), (String)"usage: test <command> [ <args> ]\n\nCommands are:\n    help      Display help information\n    visible   Visible group\n\nSee 'test help <command>' for more information on a specific command.\n");
    }

    @Test
    public void testGroupsHidden01() throws IOException {
        CliBuilder builder = Cli.builder((String)"test").withDescription("Test commandline").withCommand(Help.class);
        builder.withGroup("visible").withDescription("Visible group").withCommands(ArgsRequired.class, new Class[0]);
        builder.withGroup("hidden").withDescription("Hidden group").withCommands(ArgsRequired.class, new Class[0]).makeHidden();
        Cli parser = builder.build();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Help.help((GlobalMetadata)parser.getMetadata(), Collections.emptyList(), (OutputStream)out);
        Assert.assertEquals((String)new String(out.toByteArray(), this.utf8), (String)"usage: test <command> [ <args> ]\n\nCommands are:\n    help      Display help information\n    visible   Visible group\n\nSee 'test help <command>' for more information on a specific command.\n");
    }

    @Test
    public void testGroupsHidden02() throws IOException {
        CliBuilder builder = Cli.builder((String)"test").withDescription("Test commandline").withCommand(Help.class);
        builder.withGroup("visible").withDescription("Visible group").withCommands(ArgsRequired.class, new Class[0]);
        builder.withGroup("hidden").withDescription("Hidden group").withCommands(ArgsRequired.class, new Class[0]).makeHidden();
        Cli parser = builder.build();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        CliGlobalUsageSummaryGenerator generator = new CliGlobalUsageSummaryGenerator(true);
        generator.usage(parser.getMetadata(), (OutputStream)out);
        Assert.assertEquals((String)new String(out.toByteArray(), this.utf8), (String)"usage: test <command> [ <args> ]\n\nCommands are:\n    help      Display help information\n    hidden    Hidden group\n    visible   Visible group\n\nSee 'test help <command>' for more information on a specific command.\n");
    }

    @Test
    public void testExamplesAndDiscussion() throws IOException {
        Cli parser = Cli.builder((String)"git").withCommand(CommandRemove.class).build();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Help.help((GlobalMetadata)parser.getMetadata(), Collections.singletonList("remove"), (OutputStream)out);
        String discussion = "DISCUSSION\n        More details about how this removes files from the index.\n\n";
        String examples = "EXAMPLES\n        $ git remove -i myfile.java\n\n            This is a usage example";
        String usage = new String(out.toByteArray(), this.utf8);
        System.out.println(usage);
        Assert.assertTrue((boolean)usage.contains(discussion), (String)"Expected the discussion section to be present in the help");
        Assert.assertTrue((boolean)usage.contains(examples), (String)"Expected the examples section to be present in the help");
    }

    @Test
    public void testSingleCommandArgs1() throws IOException {
        SingleCommand command = SingleCommand.singleCommand(Args1.class);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        new CliCommandUsageGenerator().usage(null, null, "test", command.getCommandMetadata(), null, (OutputStream)out);
        Assert.assertEquals((String)new String(out.toByteArray(), this.utf8), (String)"NAME\n        test - args1 description\n\nSYNOPSIS\n        test [ -bigdecimal <bigd> ] [ -date <date> ] [ -debug ]\n                [ -double <doub> ] [ -float <floa> ] [ -groups <groups> ]\n                [ {-log | -verbose} <verbose> ] [ -long <l> ] [--] [ <parameters>... ]\n\nOPTIONS\n        -bigdecimal <bigd>\n            A BigDecimal number\n\n        -date <date>\n            An ISO 8601 formatted date.\n\n        -debug\n            Debug mode\n\n        -double <doub>\n            A double number\n\n        -float <floa>\n            A float number\n\n        -groups <groups>\n            Comma-separated list of group names to be run\n\n        -log <verbose>, -verbose <verbose>\n            Level of verbosity\n\n        -long <l>\n            A long number\n\n        --\n            This option can be used to separate command-line options from the\n            list of arguments (useful when arguments might be mistaken for\n            command-line options)\n\n        <parameters>\n\n\n");
    }

    @Test
    public void testExitCodes() throws IOException {
        SingleCommand command = SingleCommand.singleCommand(ArgsExitCodes.class);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        new CliCommandUsageGenerator().usage(null, null, "test", command.getCommandMetadata(), null, (OutputStream)out);
        this.testStringAssert(new String(out.toByteArray(), this.utf8), "NAME\n        test - ArgsExitCodes description\n\nSYNOPSIS\n        test\n\nEXIT CODES\n        This command returns one of the following exit codes:\n\n            0   Success\n            1\n            2   Error 2\n\n");
    }

    @Test
    public void testVersion() throws IOException {
        SingleCommand command = SingleCommand.singleCommand(ArgsVersion.class);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        new CliCommandUsageGenerator().usage(null, null, "test", command.getCommandMetadata(), null, (OutputStream)out);
        this.testStringAssert(new String(out.toByteArray(), this.utf8), "NAME\n        test - ArgsVersion description\n\nSYNOPSIS\n        test\n\nVERSION\n            Component: Airline Test\n            Version: 1.2.3\n            Build: 12345abcde\n");
    }

    @Test
    public void testVersionCli() throws IOException {
        Cli cli = new CliBuilder("test").withCommand(Args1.class).withHelpSection((HelpSection)new VersionSection(new String[]{"/test.version"}, new ResourceLocator[]{new ClasspathLocator()}, "component", "version", "build", "buildDate", new String[0], new String[0], false, false)).build();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        new CliGlobalUsageGenerator().usage(cli.getMetadata(), (OutputStream)out);
        this.testStringAssert(new String(out.toByteArray(), this.utf8), "NAME\n        test -\n\nSYNOPSIS\n        test <command> [ <args> ]\n\nCOMMANDS\n        Args1\n            args1 description\n\nVERSION\n            Component: Airline Test\n            Version: 1.2.3\n            Build: 12345abcde\n");
    }

    @Test
    public void testVersionCli2() throws IOException {
        Cli cli = new CliBuilder("test").withCommand(Args1.class).withHelpSection((HelpSection)new VersionSection(new String[]{"/test.version"}, new ResourceLocator[]{new ClasspathLocator()}, "component", "version", "build", "buildDate", new String[0], new String[0], false, false)).build();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        new CliGlobalUsageSummaryGenerator().usage(cli.getMetadata(), (OutputStream)out);
        this.testStringAssert(new String(out.toByteArray(), this.utf8), "usage: test <command> [ <args> ]\n\nCommands are:\n    Args1   args1 description\n\nSee 'test help <command>' for more information on a specific command.\n\nVERSION\n            Component: Airline Test\n            Version: 1.2.3\n            Build: 12345abcde\n");
    }

    @Test
    public void testVersionComponents() throws IOException {
        SingleCommand command = SingleCommand.singleCommand(ArgsVersion2.class);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        new CliCommandUsageGenerator().usage(null, null, "test", command.getCommandMetadata(), null, (OutputStream)out);
        this.testStringAssert(new String(out.toByteArray(), this.utf8), "NAME\n        test - Multiple component versions\n\nSYNOPSIS\n        test\n\nVERSION\n            Component: Airline Test\n            Version: 1.2.3\n            Build: 12345abcde\n\n            Component: Foo\n            Build: 789\n            Build Date: Feb 2016\n            Author: Mr Foo\n\n            Component: Bar\n            Version: 1.0.7\n            Built With: Oracle JDK 1.7\n            Author: Mrs Bar\n");
    }

    @Test
    public void testVersionComponentsTabular() throws IOException {
        SingleCommand command = SingleCommand.singleCommand(ArgsVersion3.class);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        new CliCommandUsageGenerator().usage(null, null, "test", command.getCommandMetadata(), null, (OutputStream)out);
        this.testStringAssert(new String(out.toByteArray(), this.utf8), "NAME\n        test - Multiple component versions\n\nSYNOPSIS\n        test\n\nVERSION\n            Component      Version   Build        Build Date   Author    Built With\n            Airline Test   1.2.3     12345abcde\n            Foo                      789          Feb 2016     Mr Foo\n            Bar            1.0.7                               Mrs Bar   Oracle JDK 1.7\n\n");
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp=".*missing\\.version.*")
    public void testVersionMissing() throws IOException {
        SingleCommand.singleCommand(ArgsVersionMissing.class);
    }

    @Test
    public void testVersionMissingSupressed() throws IOException {
        SingleCommand command = SingleCommand.singleCommand(ArgsVersionMissingSuppressed.class);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        new CliCommandUsageGenerator().usage(null, null, "test", command.getCommandMetadata(), null, (OutputStream)out);
        this.testStringAssert(new String(out.toByteArray(), this.utf8), "NAME\n        test - Missing version information\n\nSYNOPSIS\n        test\n\n");
    }

    @Test
    public void testCommandSorting() {
        CliBuilder builder = Cli.builder((String)"git").withDescription("the stupid content tracker").withDefaultCommand(Help.class).withCommand(Help.class).withCommand(Git.Add.class);
        builder.withGroup("remote").withDescription("Manage set of tracked repositories").withDefaultCommand(Git.RemoteShow.class).withCommand(Git.RemoteShow.class).withCommand(Git.RemoteAdd.class);
        Cli gitParser = builder.build();
        ArrayList defCommands = new ArrayList(gitParser.getMetadata().getDefaultGroupCommands());
        Collections.sort(defCommands, UsageHelper.DEFAULT_COMMAND_COMPARATOR);
        Assert.assertEquals((String)((CommandMetadata)defCommands.get(0)).getName(), (String)"add");
        Assert.assertEquals((String)((CommandMetadata)defCommands.get(1)).getName(), (String)"help");
        Collections.sort(defCommands, UsageHelper.DEFAULT_COMMAND_COMPARATOR);
        Assert.assertEquals((String)((CommandMetadata)defCommands.get(0)).getName(), (String)"add");
        Assert.assertEquals((String)((CommandMetadata)defCommands.get(1)).getName(), (String)"help");
    }

    @Test
    public void testCliSectionsAnnotated() throws IOException {
        Cli cli = new Cli(CliWithSections.class);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        new CliGlobalUsageGenerator().usage(cli.getMetadata(), (OutputStream)out);
        this.testStringAssert(new String(out.toByteArray(), this.utf8), "NAME\n        test -\n\nSYNOPSIS\n        test [ -v ] <command> [ <args> ]\n\nOPTIONS\n        -v\n            Verbose mode\n\nCOMMANDS\n        Args1\n            args1 description\n\n        help\n            Display help information\n\n        remove\n            Remove file contents to the index\n\nDISCUSSION\n        Foo\n\n        Bar\n\n");
    }

    @Test
    public void testCliSectionsAnnotated2() throws IOException {
        Cli cli = new Cli(CliWithSections.class);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        new CliGlobalUsageSummaryGenerator().usage(cli.getMetadata(), (OutputStream)out);
        this.testStringAssert(new String(out.toByteArray(), this.utf8), "usage: test [ -v ] <command> [ <args> ]\n\nCommands are:\n    Args1    args1 description\n    help     Display help information\n    remove   Remove file contents to the index\n\nSee 'test help <command>' for more information on a specific command.\n\nDISCUSSION\n        Foo\n\n        Bar\n\n");
    }
}

