/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline;

import com.github.rvesse.airline.Cli;
import com.github.rvesse.airline.annotations.Arguments;
import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.Option;
import com.github.rvesse.airline.annotations.OptionType;
import com.github.rvesse.airline.annotations.restrictions.Required;
import com.github.rvesse.airline.builder.CliBuilder;
import com.github.rvesse.airline.help.Help;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.GlobalMetadata;
import com.github.rvesse.airline.utils.AirlineTestUtils;
import com.github.rvesse.airline.utils.predicates.parser.CommandFinder;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestGalaxyCommandLineParser {
    @Test
    public void test_parsing() {
        this.run(new String[0]);
        this.run("help");
        this.run("help", "galaxy");
        this.run("help", "show");
        this.run("help", "install");
        this.run("help", "upgrade");
        this.run("help", "upgrade");
        this.run("help", "terminate");
        this.run("help", "start");
        this.run("help", "stop");
        this.run("help", "restart");
        this.run("help", "reset-to-actual");
        this.run("help", "ssh");
        this.run("help", "agent");
        this.run("help", "agent", "show");
        this.run("help", "agent", "add");
        this.run("--debug");
        this.run("--debug", "show", "-u", "b2", "--state", "r");
        this.run("--debug", "install", "com.proofpoint.discovery:discovery-server:1.1", "@discovery:general:1.0");
        this.run("--debug", "upgrade", "-u", "b2", "1.1", "@1.0");
        this.run("--debug", "upgrade", "-u", "b2", "1.1", "@1.0", "-s", "r");
        this.run("--debug", "terminate", "-u", "b2");
        this.run("--debug", "start", "-u", "b2");
        this.run("--debug", "stop", "-u", "b2");
        this.run("--debug", "restart", "-u", "b2");
        this.run("--debug", "reset-to-actual", "-u", "b2");
        this.run("--debug", "ssh");
        this.run("--debug", "ssh", "-u", "b2", "--state", "r", "tail -F var/log/launcher.log");
        this.run("--debug", "agent");
        this.run("--debug", "agent", "show");
        this.run("--debug", "agent", "add", "--count", "4", "t1.micro");
    }

    @Test
    public void test_default_command_01() {
        GalaxyCommand command = this.parse(new String[0]);
        Assert.assertTrue((boolean)(command instanceof HelpCommand));
    }

    @Test
    public void test_default_command_02() {
        GalaxyCommand command = this.parse("--debug");
        Assert.assertTrue((boolean)(command instanceof HelpCommand));
    }

    @Test
    public void test_default_command_03() {
        GalaxyCommand command = this.parse("agent");
        Assert.assertTrue((boolean)(command instanceof AgentShowCommand));
    }

    @Test
    public void test_metadata() {
        Cli<GalaxyCommand> cli = this.createParser();
        GlobalMetadata global = cli.getMetadata();
        Assert.assertEquals((int)global.getOptions().size(), (int)2);
        CommandMetadata show = (CommandMetadata)CollectionUtils.find((Iterable)global.getDefaultGroupCommands(), (Predicate)new CommandFinder("show"));
        Assert.assertNotNull((Object)show);
        Assert.assertEquals((int)show.getCommandOptions().size(), (int)6);
        Assert.assertEquals((int)show.getAllOptions().size(), (int)8);
    }

    protected Cli<GalaxyCommand> createParser() {
        CliBuilder builder = Cli.builder((String)"galaxy").withDescription("cloud management system").withDefaultCommand(HelpCommand.class).withCommand(HelpCommand.class).withCommand(ShowCommand.class).withCommand(InstallCommand.class).withCommand(UpgradeCommand.class).withCommand(TerminateCommand.class).withCommand(StartCommand.class).withCommand(StopCommand.class).withCommand(RestartCommand.class).withCommand(SshCommand.class).withCommand(ResetToActualCommand.class);
        builder.withGroup("agent").withDescription("Manage agents").withDefaultCommand(AgentShowCommand.class).withCommand(AgentShowCommand.class).withCommand(AgentAddCommand.class).withCommand(AgentTerminateCommand.class);
        return builder.build();
    }

    private void run(String ... args) {
        GalaxyCommand command = this.parse(args);
        command.execute();
        System.out.println();
    }

    protected GalaxyCommand parse(String ... args) {
        System.out.println("$ galaxy " + StringUtils.join((Object[])args, (char)' '));
        GalaxyCommand command = (GalaxyCommand)this.createParser().parse(args);
        return command;
    }

    @Command(name="terminate", description="Provision a new agent")
    public static class AgentTerminateCommand
    extends GalaxyCommand {
        @Arguments(title={"agent-id"}, description="Agent to terminate")
        @Required
        public String agentId;

        public String toString() {
            return AirlineTestUtils.toStringHelper(this).add("agentId", this.agentId).add("globalOptions", this.globalOptions).toString();
        }
    }

    @Command(name="show", description="Show agent details")
    public static class AgentShowCommand
    extends GalaxyCommand {
        @Inject
        public final AgentFilter agentFilter = new AgentFilter();

        public String toString() {
            return AirlineTestUtils.toStringHelper(this).add("agentFilter", this.agentFilter).add("globalOptions", this.globalOptions).toString();
        }
    }

    @Command(name="add", description="Provision a new agent")
    public static class AgentAddCommand
    extends GalaxyCommand {
        @Option(name={"--count"}, description="Number of agents to provision")
        public int count = 1;
        @Option(name={"--availability-zone"}, description="Availability zone to provision")
        public String availabilityZone;
        @Arguments(description="Instance type to provision")
        public String instanceType;

        public String toString() {
            return AirlineTestUtils.toStringHelper(this).add("count", this.count).add("availabilityZone", this.availabilityZone).add("instanceType", this.instanceType).add("globalOptions", this.globalOptions).toString();
        }
    }

    @Command(name="ssh", description="ssh to slot installation")
    public static class SshCommand
    extends GalaxyCommand {
        @Inject
        public final SlotFilter slotFilter = new SlotFilter();
        @Arguments(description="Command to execute on the remote host")
        public String command;

        public String toString() {
            return AirlineTestUtils.toStringHelper(this).add("slotFilter", this.slotFilter).add("command", this.command).toString();
        }
    }

    @Command(name="reset-to-actual", description="Reset slot expected state to actual")
    public static class ResetToActualCommand
    extends GalaxyCommand {
        @Inject
        public final SlotFilter slotFilter = new SlotFilter();

        public String toString() {
            return AirlineTestUtils.toStringHelper(this).add("slotFilter", this.slotFilter).add("globalOptions", this.globalOptions).toString();
        }
    }

    @Command(name="restart", description="Restart server")
    public static class RestartCommand
    extends GalaxyCommand {
        @Inject
        public final SlotFilter slotFilter = new SlotFilter();

        public String toString() {
            return AirlineTestUtils.toStringHelper(this).add("slotFilter", this.slotFilter).add("globalOptions", this.globalOptions).toString();
        }
    }

    @Command(name="stop", description="Stop a server")
    public static class StopCommand
    extends GalaxyCommand {
        @Inject
        public final SlotFilter slotFilter = new SlotFilter();

        public String toString() {
            return AirlineTestUtils.toStringHelper(this).add("slotFilter", this.slotFilter).add("globalOptions", this.globalOptions).toString();
        }
    }

    @Command(name="start", description="Start a server")
    public static class StartCommand
    extends GalaxyCommand {
        @Inject
        public final SlotFilter slotFilter = new SlotFilter();

        public String toString() {
            return AirlineTestUtils.toStringHelper(this).add("slotFilter", this.slotFilter).add("globalOptions", this.globalOptions).toString();
        }
    }

    @Command(name="terminate", description="Terminate (remove) a slot")
    public static class TerminateCommand
    extends GalaxyCommand {
        @Inject
        public final SlotFilter slotFilter = new SlotFilter();

        public String toString() {
            return AirlineTestUtils.toStringHelper(this).add("slotFilter", this.slotFilter).add("globalOptions", this.globalOptions).toString();
        }
    }

    @Command(name="upgrade", description="Upgrade software in a slot")
    public static class UpgradeCommand
    extends GalaxyCommand {
        @Inject
        public final SlotFilter slotFilter = new SlotFilter();
        @Arguments(description="Version of the binary and/or @configuration")
        public final List<String> versions = new ArrayList<String>();

        public String toString() {
            return AirlineTestUtils.toStringHelper(this).add("slotFilter", this.slotFilter).add("versions", this.versions).add("globalOptions", this.globalOptions).toString();
        }
    }

    @Command(name="install", description="Install software in a new slot")
    public static class InstallCommand
    extends GalaxyCommand {
        @Option(name={"--count"}, description="Number of instances to install")
        public int count = 1;
        @Inject
        public final AgentFilter agentFilter = new AgentFilter();
        @Arguments(description="The binary and @configuration to install.  The default packaging is tar.gz")
        public final List<String> assignment = new ArrayList<String>();

        public String toString() {
            return AirlineTestUtils.toStringHelper(this).add("count", this.count).add("agentFilter", this.agentFilter).add("assignment", this.assignment).add("globalOptions", this.globalOptions).toString();
        }
    }

    @Command(name="show", description="Show state of all slots")
    public static class ShowCommand
    extends GalaxyCommand {
        @Inject
        public final SlotFilter slotFilter = new SlotFilter();

        public String toString() {
            return AirlineTestUtils.toStringHelper(this).add("slotFilter", this.slotFilter).add("globalOptions", this.globalOptions).toString();
        }
    }

    @Command(name="help", description="Display help information about galaxy")
    public static class HelpCommand
    extends GalaxyCommand {
        @Inject
        public Help<GalaxyCommand> help;

        @Override
        public void execute() {
            this.help.call();
        }
    }

    public static abstract class GalaxyCommand {
        @Inject
        public GlobalOptions globalOptions = new GlobalOptions();

        public void execute() {
            System.out.println(this);
        }
    }

    public static class AgentFilter {
        @Option(name={"-i", "--host"}, description="Select slots on the given host")
        public final List<String> host = new ArrayList<String>();
        @Option(name={"-I", "--ip"}, description="Select slots at the given IP address")
        public final List<String> ip = new ArrayList<String>();
        @Option(name={"-u", "--uuid"}, description="Select slot with the given UUID")
        public final List<String> uuid = new ArrayList<String>();
        @Option(name={"-s", "--state"}, description="Select 'r{unning}', 's{topped}' or 'unknown' slots")
        public final List<String> state = new ArrayList<String>();

        public String toString() {
            return AirlineTestUtils.toStringHelper(this).add("host", this.host).add("ip", this.ip).add("uuid", this.uuid).add("state", this.state).toString();
        }
    }

    public static class SlotFilter {
        @Option(name={"-b", "--binary"}, description="Select slots with a given binary")
        public List<String> binary;
        @Option(name={"-c", "--config"}, description="Select slots with a given configuration")
        public List<String> config;
        @Option(name={"-i", "--host"}, description="Select slots on the given host")
        public List<String> host;
        @Option(name={"-I", "--ip"}, description="Select slots at the given IP address")
        public List<String> ip;
        @Option(name={"-u", "--uuid"}, description="Select slot with the given UUID")
        public List<String> uuid;
        @Option(name={"-s", "--state"}, description="Select 'r{unning}', 's{topped}' or 'unknown' slots")
        public List<String> state;

        public String toString() {
            return AirlineTestUtils.toStringHelper(this).add("binary", this.binary).add("config", this.config).add("host", this.host).add("ip", this.ip).add("uuid", this.uuid).add("state", this.state).toString();
        }
    }

    public static class GlobalOptions {
        @Option(type=OptionType.GLOBAL, name={"--debug"}, description="Enable debug messages")
        public boolean debug = false;
        @Option(type=OptionType.GLOBAL, name={"--coordinator"}, description="Galaxy coordinator host (overrides GALAXY_COORDINATOR)")
        public String coordinator = AirlineTestUtils.firstNonNull(System.getenv("GALAXY_COORDINATOR"), "http://localhost:64000");

        public String toString() {
            return AirlineTestUtils.toStringHelper(this).add("debug", this.debug).add("coordinator", this.coordinator).toString();
        }
    }
}

