/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline;

import com.github.rvesse.airline.Cli;
import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.builder.CliBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestCommandSuppression {
    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp=".*both declare the command name 'a'.*")
    public void suppressed_01() {
        new CliBuilder("test").withCommands(A.class, new Class[]{A2.class}).build();
    }

    @Test
    public void suppressed_02() {
        Cli cli = new CliBuilder("test").withCommands(A.class, new Class[]{A.class}).build();
        Object cmd = cli.parse(new String[]{"a"});
        Assert.assertEquals(cmd.getClass(), A.class);
    }

    @Test
    public void suppressed_03() {
        CliBuilder builder = new CliBuilder("test").withCommand(A.class);
        builder.withGroup("sub").withCommand(A2.class);
        Cli cli = builder.build();
        Object cmd = cli.parse(new String[]{"a"});
        Assert.assertEquals(cmd.getClass(), A.class);
        cmd = cli.parse(new String[]{"sub", "a"});
        Assert.assertEquals(cmd.getClass(), A2.class);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp=".*both declare the command name 'a'.*'sub'.*")
    public void suppressed_04() {
        CliBuilder builder = new CliBuilder("test").withCommand(A.class);
        builder.withGroup("sub").withCommands(A.class, new Class[]{A2.class});
        builder.build();
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp=".*both declare the command name 'a'.*'sub foo bar'.*")
    public void suppressed_05() {
        CliBuilder builder = new CliBuilder("test").withCommand(A.class);
        builder.withGroup("sub").withSubGroup("foo").withSubGroup("bar").withCommands(A.class, new Class[]{A2.class});
        builder.build();
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp=".*both declare the command name 'a'.*")
    public void suppressed_06() {
        new CliBuilder("test").withCommand(A.class).withDefaultCommand(A2.class).build();
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp=".*both declare the command name 'a'.*")
    public void suppressed_07() {
        ((CliBuilder)new CliBuilder("test").withGroup("sub").withCommand(A.class).withDefaultCommand(A2.class).parent()).build();
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp=".*both declare the command name 'a'.*")
    public void suppressed_08() {
        ((CliBuilder)new CliBuilder("test").withGroup("sub").withSubGroup("foo").withSubGroup("bar").withCommand(A.class).withDefaultCommand(A2.class).parent()).build();
    }

    @Command(name="a")
    public static class A2 {
    }

    @Command(name="a")
    public static class A {
    }
}

