/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline;

import com.github.rvesse.airline.ArgsRequiredWrongMain;
import com.github.rvesse.airline.Cli;
import com.github.rvesse.airline.SingleCommand;
import com.github.rvesse.airline.TestArityGreediness;
import com.github.rvesse.airline.TestingUtil;
import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.Option;
import com.github.rvesse.airline.args.Args1;
import com.github.rvesse.airline.args.Args2;
import com.github.rvesse.airline.args.ArgsAllowedValues;
import com.github.rvesse.airline.args.ArgsArityLimited;
import com.github.rvesse.airline.args.ArgsArityString;
import com.github.rvesse.airline.args.ArgsBooleanArity;
import com.github.rvesse.airline.args.ArgsBooleanArity0;
import com.github.rvesse.airline.args.ArgsDefaultOption;
import com.github.rvesse.airline.args.ArgsDefaultOptionAndArguments;
import com.github.rvesse.airline.args.ArgsDefaultOptionBadArity;
import com.github.rvesse.airline.args.ArgsDefaultOptionGlobalScope;
import com.github.rvesse.airline.args.ArgsDefaultOptionGroupScope;
import com.github.rvesse.airline.args.ArgsEnum;
import com.github.rvesse.airline.args.ArgsInherited;
import com.github.rvesse.airline.args.ArgsMultipleDefaultOptions;
import com.github.rvesse.airline.args.ArgsMultipleUnparsed;
import com.github.rvesse.airline.args.ArgsNoArguments;
import com.github.rvesse.airline.args.ArgsNoArgumentsIgnored;
import com.github.rvesse.airline.args.ArgsOutOfMemory;
import com.github.rvesse.airline.args.ArgsPrivate;
import com.github.rvesse.airline.args.ArgsRequired;
import com.github.rvesse.airline.args.ArgsSingleChar;
import com.github.rvesse.airline.args.Arity1;
import com.github.rvesse.airline.args.OptionsRequired;
import com.github.rvesse.airline.builder.CliBuilder;
import com.github.rvesse.airline.command.CommandAdd;
import com.github.rvesse.airline.command.CommandCommit;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.parser.ParseResult;
import com.github.rvesse.airline.parser.errors.ParseArgumentsUnexpectedException;
import com.github.rvesse.airline.parser.errors.ParseException;
import com.github.rvesse.airline.parser.errors.ParseOptionMissingException;
import com.github.rvesse.airline.parser.errors.ParseTooManyArgumentsException;
import com.github.rvesse.airline.parser.options.GreedyClassicGetOptParser;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestCommand {
    private static final List<String> V = Arrays.asList("a", "b", "c", "d");

    @Test
    public void simpleArgs() throws ParseException {
        Args1 args = (Args1)TestingUtil.singleCommandParser(Args1.class).parse(new String[]{"-debug", "-log", "2", "-float", "1.2", "-double", "1.3", "-bigdecimal", "1.4", "-groups", "unit", "a", "b", "c"});
        Assert.assertTrue((boolean)args.debug);
        Assert.assertEquals((int)args.verbose, (int)2);
        Assert.assertEquals((String)args.groups, (String)"unit");
        Assert.assertEquals(args.parameters, Arrays.asList("a", "b", "c"));
        Assert.assertEquals((float)args.floa, (float)1.2f, (float)0.1f);
        Assert.assertEquals((double)args.doub, (double)1.3f, (double)0.1f);
        Assert.assertEquals((Object)args.bigd, (Object)new BigDecimal("1.4"));
    }

    @Test
    public void equalsArgs() throws ParseException {
        Args1 args = (Args1)TestingUtil.singleCommandParser(Args1.class).parse(new String[]{"-debug", "-log=2", "-float=1.2", "-double=1.3", "-bigdecimal=1.4", "-groups=unit", "a", "b", "c"});
        Assert.assertTrue((boolean)args.debug);
        Assert.assertEquals((int)args.verbose, (int)2);
        Assert.assertEquals((String)args.groups, (String)"unit");
        Assert.assertEquals(args.parameters, Arrays.asList("a", "b", "c"));
        Assert.assertEquals((float)args.floa, (float)1.2f, (float)0.1f);
        Assert.assertEquals((double)args.doub, (double)1.3f, (double)0.1f);
        Assert.assertEquals((Object)args.bigd, (Object)new BigDecimal("1.4"));
    }

    @Test
    public void classicGetoptArgs() throws ParseException {
        ArgsSingleChar args = (ArgsSingleChar)TestingUtil.singleCommandParser(ArgsSingleChar.class).parse(new String[]{"-lg", "-dsm", "-pa-p", "-2", "-f-x", "--Dfoo"});
        Assert.assertTrue((boolean)args.l);
        Assert.assertTrue((boolean)args.g);
        Assert.assertTrue((boolean)args.d);
        Assert.assertEquals((String)args.s, (String)"m");
        Assert.assertEquals((String)args.p, (String)"a-p");
        Assert.assertFalse((boolean)args.n);
        Assert.assertTrue((boolean)args.two);
        Assert.assertEquals((String)args.f, (String)"-x");
        Assert.assertFalse((boolean)args.z);
        Assert.assertEquals((String)args.dir, null);
        Assert.assertEquals(args.parameters, Arrays.asList("--Dfoo"));
    }

    @Test
    public void classicGetoptArgsGreedy() throws ParseException {
        ArgsSingleChar args = (ArgsSingleChar)TestingUtil.singleCommandParser(ArgsSingleChar.class, TestArityGreediness.useSpecificOptionParser(new GreedyClassicGetOptParser())).parse(new String[]{"-lg", "-dsn", "-pa-p", "-2f", "-z", "--Dfoo"});
        Assert.assertTrue((boolean)args.l);
        Assert.assertTrue((boolean)args.g);
        Assert.assertTrue((boolean)args.d);
        Assert.assertEquals((String)args.s, (String)"n");
        Assert.assertEquals((String)args.p, (String)"a-p");
        Assert.assertFalse((boolean)args.n);
        Assert.assertTrue((boolean)args.two);
        Assert.assertEquals((String)args.f, (String)"-z");
        Assert.assertFalse((boolean)args.z);
        Assert.assertEquals((String)args.dir, null);
        Assert.assertEquals(args.parameters, Arrays.asList("--Dfoo"));
    }

    @Test
    public void classicGetoptFailure() throws ParseException {
        ArgsSingleChar args = (ArgsSingleChar)TestingUtil.singleCommandParser(ArgsSingleChar.class).parse(new String[]{"-lgX"});
        Assert.assertFalse((boolean)args.l);
        Assert.assertFalse((boolean)args.g);
        Assert.assertEquals(args.parameters, Arrays.asList("-lgX"));
    }

    @Test
    public void repeatedArgs() {
        SingleCommand<Args1> parser = TestingUtil.singleCommandParser(Args1.class);
        CommandMetadata command = parser.getCommandMetadata();
        Assert.assertEquals((int)command.getAllOptions().size(), (int)8);
    }

    @Test(expectedExceptions={ParseException.class}, expectedExceptionsMessageRegExp="No command specified")
    public void nonexistentCommandShouldThrow() {
        TestingUtil.singleCli(Args1.class).parse(new String[0]);
    }

    @Test(expectedExceptions={ParseException.class}, expectedExceptionsMessageRegExp="Command 'foo' not recognized")
    public void unrecognizedCommandShouldThrow() {
        TestingUtil.singleCli(Args1.class).parse(new String[]{"foo"});
    }

    private void multipleNames(String option) {
        Args1 args = (Args1)TestingUtil.singleCommandParser(Args1.class).parse(new String[]{option, "2"});
        Assert.assertEquals((int)args.verbose, (int)2);
    }

    @Test
    public void multipleNames1() {
        this.multipleNames("-log");
    }

    @Test
    public void multipleNames2() {
        this.multipleNames("-verbose");
    }

    @Test
    public void arityString() {
        ArgsArityString args = (ArgsArityString)TestingUtil.singleCommandParser(ArgsArityString.class).parse(new String[]{"-pairs", "pair0", "pair1", "rest"});
        Assert.assertEquals((int)args.pairs.size(), (int)2);
        Assert.assertEquals((String)args.pairs.get(0), (String)"pair0");
        Assert.assertEquals((String)args.pairs.get(1), (String)"pair1");
        Assert.assertEquals((int)args.rest.size(), (int)1);
        Assert.assertEquals((String)args.rest.get(0), (String)"rest");
    }

    @Test(expectedExceptions={ParseException.class})
    public void arity2Fail() {
        TestingUtil.singleCommandParser(ArgsArityString.class).parse(new String[]{"-pairs", "pair0"});
    }

    @Test
    public void argumentsRestrictedArity() {
        ArgsArityLimited args = (ArgsArityLimited)TestingUtil.singleCommandParser(ArgsArityLimited.class).parse(new String[]{"one", "two", "three"});
        Assert.assertEquals((int)args.args.size(), (int)3);
    }

    @Test(expectedExceptions={ParseTooManyArgumentsException.class})
    public void argumentsRestrictedArityFail() {
        TestingUtil.singleCommandParser(ArgsArityLimited.class).parse(new String[]{"one", "two", "three", "four"});
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void multipleUnparsedFail() {
        TestingUtil.singleCommandParser(ArgsMultipleUnparsed.class).parse(new String[0]);
    }

    @Test
    public void privateArgs() {
        ArgsPrivate args = (ArgsPrivate)TestingUtil.singleCommandParser(ArgsPrivate.class).parse(new String[]{"-verbose", "3"});
        Assert.assertEquals((int)args.getVerbose(), (int)3);
    }

    private void argsBoolean1(String[] params, Boolean expected) {
        ArrayList<String> values = new ArrayList<String>();
        values.addAll(Arrays.asList(params));
        ArgsBooleanArity args = (ArgsBooleanArity)TestingUtil.singleCommandParser(ArgsBooleanArity.class).parse(values);
        Assert.assertEquals((Object)args.debug, (Object)expected);
    }

    private void argsBoolean0(String[] params, Boolean expected) {
        ArrayList<String> values = new ArrayList<String>();
        values.addAll(Arrays.asList(params));
        ArgsBooleanArity0 args = (ArgsBooleanArity0)TestingUtil.singleCommandParser(ArgsBooleanArity0.class).parse(values);
        Assert.assertEquals((Object)args.debug, (Object)expected);
    }

    @Test
    public void booleanArity1() {
        this.argsBoolean1(new String[0], Boolean.FALSE);
        this.argsBoolean1(new String[]{"-debug", "true"}, Boolean.TRUE);
    }

    @Test
    public void booleanArity0() {
        this.argsBoolean0(new String[0], Boolean.FALSE);
        this.argsBoolean0(new String[]{"-debug"}, Boolean.TRUE);
    }

    @Test(expectedExceptions={ParseException.class})
    public void badParameterShouldThrowParameter1Exception() {
        TestingUtil.singleCommandParser(Args1.class).parse(new String[]{"-log", "foo"});
    }

    @Test(expectedExceptions={ParseException.class})
    public void badParameterShouldThrowParameter2Exception() {
        TestingUtil.singleCommandParser(Args1.class).parse(new String[]{"-long", "foo"});
    }

    @Test
    public void listParameters() {
        Args2 a = (Args2)TestingUtil.singleCommandParser(Args2.class).parse(new String[]{"-log", "2", "-groups", "unit", "a", "b", "c", "-host", "host2"});
        Assert.assertEquals((int)a.verbose, (int)2);
        Assert.assertEquals((String)a.groups, (String)"unit");
        Assert.assertEquals(a.hosts, Arrays.asList("host2"));
        Assert.assertEquals(a.parameters, Arrays.asList("a", "b", "c"));
    }

    @Test
    public void inheritance() {
        ArgsInherited args = (ArgsInherited)TestingUtil.singleCommandParser(ArgsInherited.class).parse(new String[]{"-log", "3", "-child", "2"});
        Assert.assertEquals((int)args.child, (int)2);
        Assert.assertEquals((int)args.log, (int)3);
    }

    @Test
    public void negativeNumber() {
        Args1 a = (Args1)TestingUtil.singleCommandParser(Args1.class).parse(new String[]{"-verbose", "-3"});
        Assert.assertEquals((int)a.verbose, (int)-3);
    }

    @Test(expectedExceptions={ParseException.class})
    public void requiredMainParameters() {
        TestingUtil.singleCommandParser(ArgsRequired.class).parse(new String[0]);
    }

    @Test(expectedExceptions={ParseException.class}, expectedExceptionsMessageRegExp=".*option.*missing.*")
    public void requiredOptions() {
        TestingUtil.singleCommandParser(OptionsRequired.class).parse(new String[0]);
    }

    @Test
    public void ignoresOptionalOptions() {
        TestingUtil.singleCommandParser(OptionsRequired.class).parse(new String[]{"--required", "foo"});
    }

    private void verifyCommandOrdering(String[] commandNames, Class<?> ... commands) {
        CliBuilder builder = Cli.builder((String)"foo");
        for (Class<?> command : commands) {
            builder = builder.withCommand(command);
        }
        Cli parser = builder.build();
        List commandParsers = parser.getMetadata().getDefaultGroupCommands();
        Assert.assertEquals((int)commandParsers.size(), (int)commands.length);
        int i = 0;
        for (CommandMetadata commandParser : commandParsers) {
            Assert.assertEquals((String)commandParser.getName(), (String)commandNames[i++]);
        }
    }

    @Test
    public void commandsShouldBeShownInOrderOfInsertion() {
        this.verifyCommandOrdering(new String[]{"add", "commit"}, CommandAdd.class, CommandCommit.class);
        this.verifyCommandOrdering(new String[]{"commit", "add"}, CommandCommit.class, CommandAdd.class);
    }

    @DataProvider
    public static Object[][] f() {
        return new Integer[][]{{3, 5, 1}, {3, 8, 1}, {3, 12, 2}, {8, 12, 2}, {9, 10, 1}};
    }

    @Test(expectedExceptions={ParseException.class})
    public void arity1Fail() {
        TestingUtil.singleCommandParser(Arity1.class).parse(new String[]{"-inspect"});
    }

    @Test
    public void arity1Success1() {
        Arity1 arguments = (Arity1)TestingUtil.singleCommandParser(Arity1.class).parse(new String[]{"-inspect", "true"});
        Assert.assertTrue((boolean)arguments.inspect);
    }

    @Test
    public void arity1Success2() {
        Arity1 arguments = (Arity1)TestingUtil.singleCommandParser(Arity1.class).parse(new String[]{"-inspect", "false"});
        Assert.assertFalse((boolean)arguments.inspect);
    }

    @Test(expectedExceptions={ParseException.class}, description="Verify that the main parameter's type is checked to be a List")
    public void wrongMainTypeShouldThrow() {
        TestingUtil.singleCommandParser(ArgsRequiredWrongMain.class).parse(new String[]{"f1", "f2"});
    }

    @Test(description="This used to run out of memory")
    public void oom() {
        TestingUtil.singleCommandParser(ArgsOutOfMemory.class).parse(new String[0]);
    }

    @Test
    public void getParametersShouldNotNpe() {
        TestingUtil.singleCommandParser(Args1.class).parse(new String[0]);
    }

    @DataProvider
    public Object[][] variable() {
        return new Object[][]{{0, V.subList(0, 0), V}, {1, V.subList(0, 1), V.subList(1, 4)}, {2, V.subList(0, 2), V.subList(2, 4)}, {3, V.subList(0, 3), V.subList(3, 4)}, {4, V.subList(0, 4), V.subList(4, 4)}};
    }

    @Test
    public void enumArgs() {
        ArgsEnum args = (ArgsEnum)TestingUtil.singleCommandParser(ArgsEnum.class).parse(new String[]{"-choice", "ONE"});
        Assert.assertEquals((Object)((Object)args.choice), (Object)((Object)ArgsEnum.ChoiceType.ONE));
    }

    @Test(expectedExceptions={ParseException.class})
    public void enumArgsFail() {
        TestingUtil.singleCommandParser(ArgsEnum.class).parse(new String[]{"-choice", "A"});
    }

    @Test(expectedExceptions={ParseException.class})
    public void shouldThrowIfUnknownOption() {
        @Command(name="A")
        class A {
            @Option(name={"-long"})
            public long l;

            A() {
            }
        }
        TestingUtil.singleCommandParser(A.class).parse(new String[]{"-lon", "32"});
    }

    @Test(expectedExceptions={ParseException.class})
    public void commandAbbreviationsDisallowedByDefault() {
        TestingUtil.singleCli(Args1.class).parse(new String[]{"Args"});
    }

    @Test
    public void commandAbbreviationsEnabled() {
        TestingUtil.singleAbbreviatedCommandParser(Args1.class).parse(new String[]{"Args"});
    }

    @Test
    public void optionAbbreviationsDisabledByDefault01() {
        Args1 args = (Args1)TestingUtil.singleCli(Args1.class).parse(new String[]{"Args1", "-deb"});
        Assert.assertFalse((boolean)args.debug);
        Assert.assertTrue((boolean)args.parameters.contains("-deb"));
    }

    @Test(expectedExceptions={ParseException.class})
    public void optionAbbreviationsDisabledByDefault02() {
        TestingUtil.singleCli(ArgsAllowedValues.class).parse(new String[]{"ArgsAllowedValues", "-mo"});
    }

    @Test
    public void optionAbbreviationsEnabled() {
        Args1 args = (Args1)TestingUtil.singleAbbreviatedOptionParser(Args1.class).parse(new String[]{"Args1", "-deb"});
        Assert.assertTrue((boolean)args.debug);
    }

    @Test
    public void defaultOption01() {
        ArgsDefaultOption cmd = (ArgsDefaultOption)TestingUtil.singleCommandParser(ArgsDefaultOption.class).parse(new String[]{"--test", "example"});
        Assert.assertEquals((String)cmd.arg, (String)"example");
    }

    @Test
    public void defaultOption02() {
        ArgsDefaultOption cmd = (ArgsDefaultOption)TestingUtil.singleCommandParser(ArgsDefaultOption.class).parse(new String[]{"example"});
        Assert.assertEquals((String)cmd.arg, (String)"example");
    }

    @Test(expectedExceptions={ParseOptionMissingException.class})
    public void defaultOption03() {
        TestingUtil.singleCommandParser(ArgsDefaultOption.class).parse(new String[0]);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void defaultOptionIncorrectArity() {
        TestingUtil.singleCommandParser(ArgsDefaultOptionBadArity.class);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void defaultOptionMultipleDeclarationsForbidden() {
        TestingUtil.singleCommandParser(ArgsMultipleDefaultOptions.class);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void defaultOptionAndArgumentsForbidden() {
        TestingUtil.singleCommandParser(ArgsDefaultOptionAndArguments.class);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void defaultOptionOnGroupOptionForbidden() {
        TestingUtil.singleCommandParser(ArgsDefaultOptionGroupScope.class);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void defaultOptionOnGlobalOptionForbidden() {
        TestingUtil.singleCommandParser(ArgsDefaultOptionGlobalScope.class);
    }

    @Test
    public void unexpectedArgs1() {
        ArgsNoArguments args = (ArgsNoArguments)TestingUtil.singleCommandParser(ArgsNoArguments.class).parse(new String[]{"-f"});
        Assert.assertTrue((boolean)args.flag);
    }

    @Test(expectedExceptions={ParseArgumentsUnexpectedException.class})
    public void unexpectedArgs2() {
        TestingUtil.singleCommandParser(ArgsNoArguments.class).parse(new String[]{"foo"});
    }

    @Test
    public void unexpectedArgs3() {
        ArgsNoArgumentsIgnored args = (ArgsNoArgumentsIgnored)TestingUtil.singleCommandParser(ArgsNoArgumentsIgnored.class).parse(new String[]{"-f", "foo"});
        Assert.assertTrue((boolean)args.flag);
        ParseResult result = TestingUtil.singleCommandParser(ArgsNoArgumentsIgnored.class).parseWithResult(new String[]{"-f", "foo"});
        Assert.assertTrue((boolean)result.wasSuccessful());
        Assert.assertEquals((int)result.getState().getUnparsedInput().size(), (int)1);
        Assert.assertEquals((String)((String)result.getState().getUnparsedInput().get(0)), (String)"foo");
    }
}

