/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline;

import com.github.rvesse.airline.SingleCommand;
import com.github.rvesse.airline.args.ArgsArityGreediness;
import com.github.rvesse.airline.builder.ParserBuilder;
import com.github.rvesse.airline.model.ParserMetadata;
import com.github.rvesse.airline.parser.errors.ParseOptionMissingValueException;
import com.github.rvesse.airline.parser.options.ClassicGetOptParser;
import com.github.rvesse.airline.parser.options.ListValueOptionParser;
import com.github.rvesse.airline.parser.options.MaybeListValueOptionParser;
import com.github.rvesse.airline.parser.options.OptionParser;
import com.github.rvesse.airline.parser.options.StandardOptionParser;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestArityGreediness {
    @Test(expectedExceptions={ParseOptionMissingValueException.class})
    public void arity_greediness_01() {
        SingleCommand.singleCommand(ArgsArityGreediness.class).parse(new String[]{"--help", "--debug", "--open"});
    }

    @Test(expectedExceptions={ParseOptionMissingValueException.class})
    public void arity_greediness_02() {
        ArgsArityGreediness args = (ArgsArityGreediness)SingleCommand.singleCommand(ArgsArityGreediness.class).parse(new String[]{"--help", "--open", "--debug"});
        Assert.assertNotEquals((Object)args.open, (Object)"--debug", (String)"Parser erroneously consumed --debug option as value for --open");
    }

    public static <T> ParserMetadata<T> useSpecificOptionParser(OptionParser<T> optionParser) {
        ParserBuilder builder = new ParserBuilder().withOptionParser(optionParser);
        ParserMetadata parser = builder.build();
        Assert.assertEquals((int)parser.getOptionParsers().size(), (int)1);
        Assert.assertEquals(parser.getOptionParsers().get(0), optionParser);
        return parser;
    }

    @Test(expectedExceptions={ParseOptionMissingValueException.class})
    public void arity_greediness_03() {
        SingleCommand.singleCommand(ArgsArityGreediness.class, TestArityGreediness.useSpecificOptionParser(new ClassicGetOptParser())).parse(new String[]{"-hdo"});
    }

    @Test(expectedExceptions={ParseOptionMissingValueException.class})
    public void arity_greediness_04() {
        ArgsArityGreediness args = (ArgsArityGreediness)SingleCommand.singleCommand(ArgsArityGreediness.class, TestArityGreediness.useSpecificOptionParser(new ClassicGetOptParser())).parse(new String[]{"-h", "-o", "-d"});
        Assert.assertNotEquals((Object)args.open, (Object)"--debug", (String)"Parser erroneously consumed --debug option as value for --open");
    }

    @Test(expectedExceptions={ParseOptionMissingValueException.class})
    public void arity_greediness_05() {
        SingleCommand.singleCommand(ArgsArityGreediness.class, TestArityGreediness.useSpecificOptionParser(new ClassicGetOptParser())).parse(new String[]{"-h", "-d", "-o"});
    }

    @Test(expectedExceptions={ParseOptionMissingValueException.class})
    public void arity_greediness_06() {
        ArgsArityGreediness args = (ArgsArityGreediness)SingleCommand.singleCommand(ArgsArityGreediness.class, TestArityGreediness.useSpecificOptionParser(new ClassicGetOptParser())).parse(new String[]{"-hod"});
        Assert.assertNotEquals((Object)args.open, (Object)"--debug", (String)"Parser erroneously consumed --debug option as value for --open");
    }

    @Test(expectedExceptions={ParseOptionMissingValueException.class})
    public void arity_greediness_07() {
        SingleCommand.singleCommand(ArgsArityGreediness.class, TestArityGreediness.useSpecificOptionParser(new StandardOptionParser())).parse(new String[]{"--help", "--debug", "--open"});
    }

    @Test(expectedExceptions={ParseOptionMissingValueException.class})
    public void arity_greediness_08() {
        ArgsArityGreediness args = (ArgsArityGreediness)SingleCommand.singleCommand(ArgsArityGreediness.class, TestArityGreediness.useSpecificOptionParser(new StandardOptionParser())).parse(new String[]{"--help", "--open", "--debug"});
        Assert.assertNotEquals((Object)args.open, (Object)"--debug", (String)"Parser erroneously consumed --debug option as value for --open");
    }

    @Test(expectedExceptions={ParseOptionMissingValueException.class})
    public void arity_greediness_09() {
        SingleCommand.singleCommand(ArgsArityGreediness.class, TestArityGreediness.useSpecificOptionParser(new ListValueOptionParser())).parse(new String[]{"--help", "--debug", "--open"});
    }

    @Test(expectedExceptions={ParseOptionMissingValueException.class})
    public void arity_greediness_10() {
        ArgsArityGreediness args = (ArgsArityGreediness)SingleCommand.singleCommand(ArgsArityGreediness.class, TestArityGreediness.useSpecificOptionParser(new ListValueOptionParser())).parse(new String[]{"--help", "--open", "--debug"});
        Assert.assertNotEquals((Object)args.open, (Object)"--debug", (String)"Parser erroneously consumed --debug option as value for --open");
    }

    @Test(expectedExceptions={ParseOptionMissingValueException.class})
    public void arity_greediness_11() {
        SingleCommand.singleCommand(ArgsArityGreediness.class, TestArityGreediness.useSpecificOptionParser(new MaybeListValueOptionParser())).parse(new String[]{"--help", "--debug", "--open"});
    }

    @Test(expectedExceptions={ParseOptionMissingValueException.class})
    public void arity_greediness_12() {
        ArgsArityGreediness args = (ArgsArityGreediness)SingleCommand.singleCommand(ArgsArityGreediness.class, TestArityGreediness.useSpecificOptionParser(new MaybeListValueOptionParser())).parse(new String[]{"--help", "--open", "--debug"});
        Assert.assertNotEquals((Object)args.open, (Object)"--debug", (String)"Parser erroneously consumed --debug option as value for --open");
    }
}

