/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline;

import com.github.rvesse.airline.Channels;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ChannelsTest {
    @Test
    public void testOutput() {
        PrintStream oldOutput = System.out;
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            System.setOut(new PrintStream(output));
            Channels.output().append("some output");
            Assert.assertEquals((String)output.toString(), (String)"some output");
        }
        finally {
            System.setOut(oldOutput);
        }
    }

    @Test
    public void testError() {
        PrintStream oldError = System.err;
        try {
            ByteArrayOutputStream error = new ByteArrayOutputStream();
            System.setErr(new PrintStream(error));
            Channels.error().append("some error");
            Assert.assertEquals((String)error.toString(), (String)"some error");
        }
        finally {
            System.setErr(oldError);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInput() throws IOException {
        InputStream oldInput = System.in;
        try {
            byte[] inputData = "some input".getBytes();
            ByteArrayInputStream input = new ByteArrayInputStream(inputData);
            System.setIn(input);
            byte[] readData = new byte[inputData.length];
            Channels.input().read(readData);
            Assert.assertEquals((String)new String(readData), (String)"some input");
        }
        finally {
            System.setIn(oldInput);
        }
    }
}

