/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.apache.tools.ant.types.selectors.modifiedselector;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import shadow.org.apache.tools.ant.types.selectors.modifiedselector.Cache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesfileCache
implements Cache {
    private File cachefile = null;
    private Properties cache = new Properties();
    private boolean cacheLoaded = false;
    private boolean cacheDirty = true;

    public PropertiesfileCache() {
    }

    public PropertiesfileCache(File cachefile) {
        this.cachefile = cachefile;
    }

    public void setCachefile(File file) {
        this.cachefile = file;
    }

    public File getCachefile() {
        return this.cachefile;
    }

    @Override
    public boolean isValid() {
        return this.cachefile != null;
    }

    @Override
    public void load() {
        if (this.cachefile != null && this.cachefile.isFile() && this.cachefile.canRead()) {
            try {
                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(this.cachefile));
                this.cache.load(bis);
                bis.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.cacheLoaded = true;
        this.cacheDirty = false;
    }

    @Override
    public void save() {
        if (!this.cacheDirty) {
            return;
        }
        if (this.cachefile != null && this.cache.propertyNames().hasMoreElements()) {
            try {
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(this.cachefile));
                this.cache.store(bos, null);
                bos.flush();
                bos.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.cacheDirty = false;
    }

    @Override
    public void delete() {
        this.cache = new Properties();
        this.cachefile.delete();
        this.cacheLoaded = true;
        this.cacheDirty = false;
    }

    @Override
    public Object get(Object key) {
        if (!this.cacheLoaded) {
            this.load();
        }
        try {
            return this.cache.getProperty(String.valueOf(key));
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    @Override
    public void put(Object key, Object value) {
        this.cache.put(String.valueOf(key), String.valueOf(value));
        this.cacheDirty = true;
    }

    @Override
    public Iterator<String> iterator() {
        Vector<String> v = new Vector<String>();
        Enumeration<?> en = this.cache.propertyNames();
        while (en.hasMoreElements()) {
            v.add(en.nextElement().toString());
        }
        return v.iterator();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<PropertiesfileCache:");
        buf.append("cachefile=").append(this.cachefile);
        buf.append(";noOfEntries=").append(this.cache.size());
        buf.append(">");
        return buf.toString();
    }
}

