/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.apache.tools.ant.types;

import java.util.ArrayList;
import java.util.List;
import shadow.org.apache.tools.ant.Project;
import shadow.org.apache.tools.ant.ProjectHelper;
import shadow.org.apache.tools.ant.Target;
import shadow.org.apache.tools.ant.Task;
import shadow.org.apache.tools.ant.UnknownElement;
import shadow.org.apache.tools.ant.helper.ProjectHelperImpl;
import shadow.org.apache.tools.ant.types.DataType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Description
extends DataType {
    public void addText(String text) {
        ProjectHelper ph = (ProjectHelper)this.getProject().getReference("ant.projectHelper");
        if (!(ph instanceof ProjectHelperImpl)) {
            return;
        }
        String currentDescription = this.getProject().getDescription();
        if (currentDescription == null) {
            this.getProject().setDescription(text);
        } else {
            this.getProject().setDescription(currentDescription + text);
        }
    }

    public static String getDescription(Project project) {
        List targets = (List)project.getReference("ant.targets");
        if (targets == null) {
            return null;
        }
        StringBuilder description = new StringBuilder();
        for (Target t : targets) {
            Description.concatDescriptions(project, t, description);
        }
        return description.toString();
    }

    private static void concatDescriptions(Project project, Target t, StringBuilder description) {
        if (t == null) {
            return;
        }
        for (Task task : Description.findElementInTarget(project, t, "description")) {
            UnknownElement ue;
            String descComp;
            if (!(task instanceof UnknownElement) || (descComp = (ue = (UnknownElement)task).getWrapper().getText().toString()) == null) continue;
            description.append(project.replaceProperties(descComp));
        }
    }

    private static List<Task> findElementInTarget(Project project, Target t, String name) {
        ArrayList<Task> elems = new ArrayList<Task>();
        for (Task task : t.getTasks()) {
            if (!name.equals(task.getTaskName())) continue;
            elems.add(task);
        }
        return elems;
    }
}

