/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.apache.tools.ant.taskdefs;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import shadow.org.apache.tools.ant.BuildException;
import shadow.org.apache.tools.ant.DirectoryScanner;
import shadow.org.apache.tools.ant.Task;
import shadow.org.apache.tools.ant.types.FileSet;
import shadow.org.apache.tools.ant.types.Path;
import shadow.org.apache.tools.ant.util.FileUtils;

public class MakeUrl
extends Task {
    private String property;
    private File file;
    private String separator = " ";
    private List<FileSet> filesets = new LinkedList<FileSet>();
    private List<Path> paths = new LinkedList<Path>();
    private boolean validate = true;
    public static final String ERROR_MISSING_FILE = "A source file is missing: ";
    public static final String ERROR_NO_PROPERTY = "No property defined";
    public static final String ERROR_NO_FILES = "No files defined";

    public void setProperty(String property) {
        this.property = property;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void addFileSet(FileSet fileset) {
        this.filesets.add(fileset);
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public void addPath(Path path) {
        this.paths.add(path);
    }

    private String filesetsToURL() {
        if (this.filesets.isEmpty()) {
            return "";
        }
        int count = 0;
        StringBuilder urls = new StringBuilder();
        ListIterator<FileSet> list = this.filesets.listIterator();
        while (list.hasNext()) {
            FileSet set = list.next();
            DirectoryScanner scanner = set.getDirectoryScanner(this.getProject());
            String[] files = scanner.getIncludedFiles();
            for (int i = 0; i < files.length; ++i) {
                File f = new File(scanner.getBasedir(), files[i]);
                this.validateFile(f);
                String asUrl = this.toURL(f);
                urls.append(asUrl);
                this.log(asUrl, 4);
                urls.append(this.separator);
                ++count;
            }
        }
        return this.stripTrailingSeparator(urls, count);
    }

    private String stripTrailingSeparator(StringBuilder urls, int count) {
        if (count > 0) {
            urls.delete(urls.length() - this.separator.length(), urls.length());
            return new String(urls);
        }
        return "";
    }

    private String pathsToURL() {
        if (this.paths.isEmpty()) {
            return "";
        }
        int count = 0;
        StringBuilder urls = new StringBuilder();
        ListIterator<Path> list = this.paths.listIterator();
        while (list.hasNext()) {
            Path path = list.next();
            String[] elements = path.list();
            for (int i = 0; i < elements.length; ++i) {
                File f = new File(elements[i]);
                this.validateFile(f);
                String asUrl = this.toURL(f);
                urls.append(asUrl);
                this.log(asUrl, 4);
                urls.append(this.separator);
                ++count;
            }
        }
        return this.stripTrailingSeparator(urls, count);
    }

    private void validateFile(File fileToCheck) {
        if (this.validate && !fileToCheck.exists()) {
            throw new BuildException(ERROR_MISSING_FILE + fileToCheck.toString());
        }
    }

    public void execute() throws BuildException {
        String pathURL;
        String url;
        this.validate();
        if (this.getProject().getProperty(this.property) != null) {
            return;
        }
        String filesetURL = this.filesetsToURL();
        if (this.file != null) {
            this.validateFile(this.file);
            url = this.toURL(this.file);
            if (filesetURL.length() > 0) {
                url = url + this.separator + filesetURL;
            }
        } else {
            url = filesetURL;
        }
        if ((pathURL = this.pathsToURL()).length() > 0) {
            url = url.length() > 0 ? url + this.separator + pathURL : pathURL;
        }
        this.log("Setting " + this.property + " to URL " + url, 3);
        this.getProject().setNewProperty(this.property, url);
    }

    private void validate() {
        if (this.property == null) {
            throw new BuildException(ERROR_NO_PROPERTY);
        }
        if (this.file == null && this.filesets.isEmpty() && this.paths.isEmpty()) {
            throw new BuildException(ERROR_NO_FILES);
        }
    }

    private String toURL(File fileToConvert) {
        String url = FileUtils.getFileUtils().toURI(fileToConvert.getAbsolutePath());
        return url;
    }
}

