/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.util.temporal;

import com.floragunn.searchsupport.config.validation.ConfigValidationException;
import com.floragunn.searchsupport.config.validation.InvalidAttributeValue;
import com.floragunn.searchsupport.util.temporal.DurationFormat;
import com.floragunn.searchsupport.util.temporal.PeriodFormat;
import java.time.Duration;
import java.time.Period;
import java.time.temporal.TemporalAmount;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TemporalAmountFormat {
    public static final TemporalAmountFormat INSTANCE = new TemporalAmountFormat();
    private final Pattern pattern = Pattern.compile("((?<period>((?<y>[0-9]+)y)?\\s*((?<M>[0-9]+)M)?\\s*((?<pw>[0-9]+)w)?\\s*((?<pd>[0-9]+)d)?\\s*)|(?<duration>((?<w>[0-9]+)w)??\\s*((?<d>[0-9]+)d)??\\s*((?<h>[0-9]+)h)?\\s*((?<m>[0-9]+)m)?\\s*((?<s>[0-9]+)s)?\\s*((?<ms>[0-9]+)ms)?))");

    public TemporalAmount parse(String temporalAmountString) throws ConfigValidationException {
        if (temporalAmountString == null) {
            return null;
        }
        if (temporalAmountString.equals("0")) {
            return Duration.ZERO;
        }
        Matcher matcher = this.pattern.matcher(temporalAmountString);
        if (!matcher.matches()) {
            throw new ConfigValidationException(new InvalidAttributeValue(null, (Object)temporalAmountString, "<Years>y? <Months>M? <Weeks>w? <Days>d?  |  <Days>d? <Hours>h? <Minutes>m? <Seconds>s? <Milliseconds>ms?"));
        }
        if (matcher.group("period") != null) {
            return PeriodFormat.INSTANCE.parse(matcher);
        }
        return DurationFormat.INSTANCE.parse(matcher);
    }

    public String format(TemporalAmount temporalAmount) {
        if (temporalAmount == null) {
            return null;
        }
        if (temporalAmount instanceof Duration) {
            return DurationFormat.INSTANCE.format((Duration)temporalAmount);
        }
        if (temporalAmount instanceof Period) {
            return PeriodFormat.INSTANCE.format((Period)temporalAmount);
        }
        throw new IllegalArgumentException("Unknown temporalAmount value: " + temporalAmount);
    }

    static Long getNumericMatch(Matcher matcher, String name) {
        String group = matcher.group(name);
        if (group != null) {
            return Long.parseLong(group);
        }
        return null;
    }
}

