/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.util.temporal;

import com.floragunn.searchsupport.config.validation.ConfigValidationException;
import com.floragunn.searchsupport.config.validation.InvalidAttributeValue;
import com.floragunn.searchsupport.util.temporal.TemporalAmountFormat;
import java.time.Period;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PeriodFormat {
    public static final PeriodFormat INSTANCE = new PeriodFormat();
    static final String PATTERN_STRING = "((?<y>[0-9]+)y)?\\s*((?<M>[0-9]+)M)?\\s*((?<pw>[0-9]+)w)?\\s*((?<pd>[0-9]+)d)?\\s*";
    private final Pattern pattern = Pattern.compile("((?<y>[0-9]+)y)?\\s*((?<M>[0-9]+)M)?\\s*((?<pw>[0-9]+)w)?\\s*((?<pd>[0-9]+)d)?\\s*");

    public Period parse(String periodString) throws ConfigValidationException {
        if (periodString == null) {
            return null;
        }
        if (periodString.equals("0")) {
            return Period.ZERO;
        }
        Matcher matcher = this.pattern.matcher(periodString);
        if (!matcher.matches()) {
            throw new ConfigValidationException(new InvalidAttributeValue(null, (Object)periodString, "<Years>y? <Months>M? <Weeks>w? <Days>d? "));
        }
        return this.parse(matcher);
    }

    Period parse(Matcher matcher) {
        Long d;
        Long w;
        Long m;
        Period result = Period.ZERO;
        Long y = TemporalAmountFormat.getNumericMatch(matcher, "y");
        if (y != null) {
            result = result.plusYears(y);
        }
        if ((m = TemporalAmountFormat.getNumericMatch(matcher, "M")) != null) {
            result = result.plusMonths(m);
        }
        if ((w = TemporalAmountFormat.getNumericMatch(matcher, "pw")) != null) {
            result = result.plusDays(w * 7L);
        }
        if ((d = TemporalAmountFormat.getNumericMatch(matcher, "pd")) != null) {
            result = result.plusDays(d);
        }
        return result;
    }

    public String format(Period period) {
        int days;
        int months;
        if (period == null) {
            return null;
        }
        if (period.isZero()) {
            return "0";
        }
        if (period.isNegative()) {
            throw new IllegalArgumentException("Negative periods are not supported");
        }
        StringBuilder result = new StringBuilder();
        int years = period.getYears();
        if (years != 0) {
            result.append(years).append("y");
        }
        if ((months = period.getMonths()) != 0) {
            result.append(months).append("M");
        }
        if ((days = period.getDays()) != 0) {
            result.append(days).append("d");
        }
        return result.toString();
    }
}

