/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.util.temporal;

import com.floragunn.searchsupport.config.validation.ConfigValidationException;
import com.floragunn.searchsupport.config.validation.InvalidAttributeValue;
import com.floragunn.searchsupport.util.temporal.TemporalAmountFormat;
import java.time.Duration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DurationFormat {
    public static final DurationFormat INSTANCE = new DurationFormat();
    static final String PATTERN_STRING = "((?<w>[0-9]+)w)??\\s*((?<d>[0-9]+)d)??\\s*((?<h>[0-9]+)h)?\\s*((?<m>[0-9]+)m)?\\s*((?<s>[0-9]+)s)?\\s*((?<ms>[0-9]+)ms)?";
    private final Pattern pattern = Pattern.compile("((?<w>[0-9]+)w)??\\s*((?<d>[0-9]+)d)??\\s*((?<h>[0-9]+)h)?\\s*((?<m>[0-9]+)m)?\\s*((?<s>[0-9]+)s)?\\s*((?<ms>[0-9]+)ms)?");

    public Duration parse(String durationString) throws ConfigValidationException {
        if (durationString == null) {
            return null;
        }
        if (durationString.equals("0")) {
            return Duration.ZERO;
        }
        Matcher matcher = this.pattern.matcher(durationString);
        if (!matcher.matches()) {
            throw new ConfigValidationException(new InvalidAttributeValue(null, (Object)durationString, "<Weeks>w? <Days>d? <Hours>h? <Minutes>m? <Seconds>s? <Milliseconds>ms?"));
        }
        return this.parse(matcher);
    }

    Duration parse(Matcher matcher) {
        Long ms;
        Long s;
        Long m;
        Long h;
        Long d;
        Duration result = Duration.ZERO;
        Long w = TemporalAmountFormat.getNumericMatch(matcher, "w");
        if (w != null) {
            result = result.plusDays(7L * w);
        }
        if ((d = TemporalAmountFormat.getNumericMatch(matcher, "d")) != null) {
            result = result.plusDays(d);
        }
        if ((h = TemporalAmountFormat.getNumericMatch(matcher, "h")) != null) {
            result = result.plusHours(h);
        }
        if ((m = TemporalAmountFormat.getNumericMatch(matcher, "m")) != null) {
            result = result.plusMinutes(m);
        }
        if ((s = TemporalAmountFormat.getNumericMatch(matcher, "s")) != null) {
            result = result.plusSeconds(s);
        }
        if ((ms = TemporalAmountFormat.getNumericMatch(matcher, "ms")) != null) {
            result = result.plusMillis(ms);
        }
        return result;
    }

    public String format(Duration duration) {
        if (duration == null) {
            return null;
        }
        if (duration.isZero()) {
            return "0";
        }
        if (duration.isNegative()) {
            throw new IllegalArgumentException("Negative durations are not supported");
        }
        StringBuilder result = new StringBuilder();
        long seconds = duration.getSeconds();
        int nanos = duration.getNano();
        long minutes = seconds / 60L;
        seconds -= minutes * 60L;
        long hours = minutes / 60L;
        minutes -= hours * 60L;
        long days = hours / 24L;
        hours -= days * 24L;
        long weeks = days / 7L;
        days -= weeks * 7L;
        int millis = nanos / 1000000;
        if (weeks != 0L) {
            result.append(weeks).append("w");
        }
        if (days != 0L) {
            result.append(days).append("d");
        }
        if (hours != 0L) {
            result.append(hours).append("h");
        }
        if (minutes != 0L) {
            result.append(minutes).append("m");
        }
        if (seconds != 0L) {
            result.append(seconds).append("s");
        }
        if (millis != 0) {
            result.append(millis).append("ms");
        }
        return result.toString();
    }
}

