/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.util;

import com.google.common.collect.Iterators;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class SingleElementBlockingQueue<E>
implements BlockingQueue<E> {
    private final AtomicReference<E> element = new AtomicReference();
    private final ReentrantLock takeLock = new ReentrantLock();
    private final Condition notEmpty = this.takeLock.newCondition();

    @Override
    public E remove() {
        E result = this.element.getAndSet(null);
        if (result == null) {
            throw new NoSuchElementException();
        }
        return result;
    }

    @Override
    public E poll() {
        return this.element.getAndSet(null);
    }

    @Override
    public E element() {
        E result = this.element.get();
        if (result == null) {
            throw new NoSuchElementException();
        }
        return result;
    }

    @Override
    public E peek() {
        return this.element.get();
    }

    @Override
    public int size() {
        return this.element.get() != null ? 1 : 0;
    }

    @Override
    public boolean isEmpty() {
        return this.element.get() == null;
    }

    @Override
    public Iterator<E> iterator() {
        E e = this.element.get();
        if (e == null) {
            return Collections.emptyIterator();
        }
        return Collections.singletonList(e).iterator();
    }

    @Override
    public Object[] toArray() {
        E e = this.element.get();
        if (e == null) {
            return new Object[0];
        }
        return new Object[]{e};
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size;
        E e = this.element.get();
        int n = size = e != null ? 1 : 0;
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        if (e != null) {
            a[0] = e;
        }
        return a;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        E e = this.element.get();
        if (e == null) {
            return c.size() == 0;
        }
        for (Object o : c) {
            if (o == e) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        Object last = Iterators.getLast(c.iterator());
        return this.add(last);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object e : c) {
            changed |= this.remove(e);
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        E e = this.element.get();
        boolean contains = false;
        for (Object o : c) {
            if (o != e) continue;
            contains = true;
        }
        if (!contains) {
            return this.element.compareAndSet(e, null);
        }
        return false;
    }

    @Override
    public void clear() {
        this.element.set(null);
    }

    @Override
    public boolean add(E e) {
        if (e == null) {
            throw new IllegalArgumentException("null not allowed");
        }
        this.element.set(e);
        this.notEmpty.signal();
        return true;
    }

    @Override
    public boolean offer(E e) {
        this.element.set(e);
        return true;
    }

    @Override
    public void put(E e) throws InterruptedException {
        this.element.set(e);
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        this.element.set(e);
        return true;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public E take() throws InterruptedException {
        e = this.element.getAndSet(null);
        if (e != null) {
            return e;
        }
        this.takeLock.lockInterruptibly();
        try {
            e = this.element.getAndSet(null);
            if (e == null) ** GOTO lbl-1000
            var3_2 = e;
            this.takeLock.unlock();
            return var3_2;
        }
        catch (Throwable var2_4) {
            this.takeLock.unlock();
            throw var2_4;
        }
lbl-1000:
        // 1 sources

        {
            while (true) {
                if (e != null) {
                    var3_3 = e;
                    break;
                }
                this.notEmpty.await();
                e = this.element.getAndSet(null);
            }
        }
        this.takeLock.unlock();
        return var3_3;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        e = this.element.getAndSet(null);
        if (e != null) {
            return e;
        }
        this.takeLock.lockInterruptibly();
        try {
            e = this.element.getAndSet(null);
            if (e == null) ** GOTO lbl-1000
            var6_4 = e;
            this.takeLock.unlock();
            return var6_4;
        }
        catch (Throwable var5_6) {
            this.takeLock.unlock();
            throw var5_6;
        }
lbl-1000:
        // 1 sources

        {
            while (true) {
                if (e != null) {
                    var6_5 = e;
                    break;
                }
                this.notEmpty.await(timeout, unit);
                e = this.element.getAndSet(null);
            }
        }
        this.takeLock.unlock();
        return var6_5;
    }

    @Override
    public int remainingCapacity() {
        E e = this.element.get();
        return e == null ? 1 : 0;
    }

    @Override
    public boolean remove(Object o) {
        return this.element.compareAndSet(o, null);
    }

    @Override
    public boolean contains(Object o) {
        E e = this.element.get();
        return e == o;
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        Object e = this.element.getAndSet(null);
        if (e != null) {
            c.add(e);
            return 1;
        }
        return 0;
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        if (maxElements <= 0) {
            return 0;
        }
        return this.drainTo(c);
    }
}

