/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;

public class BasicJsonWriter {
    private static JsonFactory jsonFactory = new JsonFactory();
    private JsonGenerator generator;
    private int maxDepth = 20;

    public static String writeAsString(Object object) {
        try {
            StringWriter writer = new StringWriter();
            try {
                JsonGenerator generator = jsonFactory.createGenerator((Writer)writer);
                try {
                    new BasicJsonWriter(generator).write(object);
                    generator.flush();
                    writer.flush();
                    String str = writer.toString();
                    if (generator != null) {
                        generator.close();
                    }
                    writer.close();
                    return str;
                }
                catch (Throwable throwable) {
                    if (generator != null) {
                        try {
                            generator.close();
                        }
                        catch (Throwable throwable1) {
                            throwable.addSuppressed(throwable1);
                        }
                    }
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                try {
                    writer.close();
                }
                catch (Throwable throwable1) {
                    throwable.addSuppressed(throwable1);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public BasicJsonWriter(JsonGenerator generator) {
        this.generator = generator;
    }

    public void write(Object object) throws IOException {
        this.write(object, 0);
    }

    private void write(Object object, int depth) throws IOException {
        if (depth > this.maxDepth) {
            throw new JsonGenerationException("Max JSON depth exceeded", this.generator);
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            this.generator.writeStartArray();
            for (Object element : collection) {
                this.write(element, depth + 1);
            }
            this.generator.writeEndArray();
        } else if (object instanceof Map) {
            Map map = (Map)object;
            this.generator.writeStartObject();
            for (Map.Entry entry : map.entrySet()) {
                this.generator.writeFieldName(String.valueOf(entry.getKey()));
                this.write(entry.getValue(), depth + 1);
            }
            this.generator.writeEndObject();
        } else if (object instanceof String) {
            this.generator.writeString((String)object);
        } else if (object instanceof Character) {
            this.generator.writeString(object.toString());
        } else if (object instanceof Integer) {
            this.generator.writeNumber(((Integer)object).intValue());
        } else if (object instanceof Long) {
            this.generator.writeNumber(((Long)object).longValue());
        } else if (object instanceof Short) {
            this.generator.writeNumber(((Short)object).shortValue());
        } else if (object instanceof Float) {
            this.generator.writeNumber(((Float)object).floatValue());
        } else if (object instanceof Double) {
            this.generator.writeNumber(((Double)object).doubleValue());
        } else if (object instanceof BigDecimal) {
            this.generator.writeNumber((BigDecimal)object);
        } else if (object instanceof BigInteger) {
            this.generator.writeNumber((BigInteger)object);
        } else if (object instanceof Number) {
            this.generator.writeNumber(object.toString());
        } else if (object instanceof Boolean) {
            this.generator.writeBoolean(((Boolean)object).booleanValue());
        } else if (object instanceof Enum) {
            this.generator.writeString(((Enum)object).name());
        } else if (object == null) {
            this.generator.writeNull();
        } else {
            throw new JsonGenerationException("Unsupported object type: " + object, this.generator);
        }
    }
}

