/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.diag;

import java.util.Map;
import java.util.function.Supplier;
import org.apache.logging.log4j.CloseableThreadContext;
import org.apache.logging.log4j.ThreadContext;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.util.concurrent.ThreadContext;

public final class LogContextPreservingActionListener<R>
implements ActionListener<R> {
    private final ActionListener<R> delegate;
    private final Supplier<ThreadContext.StoredContext> context;
    private final Map<String, String> logThreadContextMap;

    public LogContextPreservingActionListener(Supplier<ThreadContext.StoredContext> contextSupplier, Map<String, String> logThreadContextMap, ActionListener<R> delegate) {
        this.delegate = delegate;
        this.context = contextSupplier;
        this.logThreadContextMap = logThreadContextMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onResponse(R r) {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            ThreadContext.StoredContext ignore = this.context.get();
            try {
                try (CloseableThreadContext.Instance ctc = CloseableThreadContext.putAll(this.logThreadContextMap);){
                    this.delegate.onResponse(r);
                }
                if (ignore == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (ignore == null) throw throwable;
                ignore.close();
                throw throwable;
            }
            ignore.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onFailure(Exception e) {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            ThreadContext.StoredContext ignore = this.context.get();
            try {
                try (CloseableThreadContext.Instance ctc = CloseableThreadContext.putAll(this.logThreadContextMap);){
                    this.delegate.onFailure(e);
                }
                if (ignore == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (ignore == null) throw throwable;
                ignore.close();
                throw throwable;
            }
            ignore.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "/" + this.delegate.toString();
    }

    public static <R> LogContextPreservingActionListener<R> wrapPreservingContext(ActionListener<R> listener, org.elasticsearch.common.util.concurrent.ThreadContext threadContext) {
        return new LogContextPreservingActionListener<R>(threadContext.newRestorableContext(true), ThreadContext.getImmutableContext(), listener);
    }
}

