/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.diag;

import com.floragunn.searchsupport.diag.LogContextPreservingActionListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.action.support.ActionFilterChain;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.tasks.Task;

public final class DiagnosticContext {
    private static final Logger log = LogManager.getLogger(DiagnosticContext.class);
    public static final Setting<Boolean> ACTION_STACK_ENABLED = Setting.boolSetting((String)"searchguard.diagnosis.action_stack.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> ADD_EXTENDED_HEADERS_TO_LOG_CONTEXT = Setting.boolSetting((String)"searchguard.logging.context.extended", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final List<Setting<?>> SETTINGS = Arrays.asList(ACTION_STACK_ENABLED, ADD_EXTENDED_HEADERS_TO_LOG_CONTEXT);
    public static final String ACTION_STACK_HEADER = "x_action_stack";
    public static final String ACTION_STACK_EXTENSION_TRANSIENT = "x_action_stack_ext";
    public static final Collection<String> CLEAR_TRANSIENT_HEADERS_ON_APPLY = Arrays.asList("x_action_stack_ext");
    private final boolean trackActionStack;
    private final boolean addExtendedHeadersToLogContext;
    private final org.elasticsearch.common.util.concurrent.ThreadContext threadContext;
    private static final Handle NOP_CLOSEABLE = new Handle(){};

    public DiagnosticContext(Settings settings, org.elasticsearch.common.util.concurrent.ThreadContext threadContext) {
        this.trackActionStack = (Boolean)ACTION_STACK_ENABLED.get(settings);
        this.addExtendedHeadersToLogContext = (Boolean)ADD_EXTENDED_HEADERS_TO_LOG_CONTEXT.get(settings);
        this.threadContext = threadContext;
    }

    public void traceActionStack(String action) {
        if (!this.trackActionStack || action == null || action.length() == 0) {
            return;
        }
        String currentActionStack = this.getActionStack();
        this.traceActionStack(currentActionStack, action);
    }

    public void traceActionStack(String currentActionStack, String action) {
        if (!this.trackActionStack || action == null || action.length() == 0) {
            return;
        }
        String newActionStack = this.pushToActionStack(currentActionStack, action);
        if (this.threadContext.getTransient(ACTION_STACK_EXTENSION_TRANSIENT) == null) {
            this.threadContext.putTransient(ACTION_STACK_EXTENSION_TRANSIENT, (Object)newActionStack);
        } else {
            log.error("Could not set new action stack to ThreadContext. Make sure you pushed the context before. currentActionStack: " + currentActionStack + "; action: " + action, (Throwable)new Exception());
        }
        ThreadContext.put((String)"action_stack", (String)newActionStack);
    }

    public Handle pushActionStack(String action) {
        if (!this.trackActionStack || action == null || action.length() == 0) {
            return NOP_CLOSEABLE;
        }
        final String currentActionStack = this.getActionStack();
        final ThreadContext.StoredContext ctx = this.threadContext.newStoredContext(true, CLEAR_TRANSIENT_HEADERS_ON_APPLY);
        try {
            String newActionStack = this.pushToActionStack(currentActionStack, action);
            this.threadContext.putTransient(ACTION_STACK_EXTENSION_TRANSIENT, (Object)newActionStack);
            ThreadContext.put((String)"action_stack", (String)newActionStack);
            return new Handle(){

                @Override
                public void close() {
                    ctx.close();
                    ThreadContext.put((String)"action_stack", (String)currentActionStack);
                }
            };
        }
        catch (RuntimeException e) {
            ctx.close();
            throw e;
        }
    }

    public String getActionStack() {
        return DiagnosticContext.getActionStack(this.threadContext);
    }

    public void addHeadersToLogContext(ClusterService clusterService, org.elasticsearch.common.util.concurrent.ThreadContext threadContext) {
        if (!this.addExtendedHeadersToLogContext) {
            return;
        }
        ClusterName clusterName = clusterService.getClusterName();
        if (clusterName != null) {
            ThreadContext.put((String)"cluster_name", (String)clusterName.value());
        }
        ThreadContext.put((String)"node_name", (String)clusterService.getNodeName());
        ThreadContext.put((String)"sg_origin", (String)((String)threadContext.getTransient("_sg_origin")));
        ThreadContext.put((String)"sg_channel_type", (String)((String)threadContext.getTransient("_sg_channel_type")));
    }

    private String pushToActionStack(String currentActionStack, String action) {
        if (currentActionStack != null) {
            return String.valueOf(currentActionStack) + " > " + action;
        }
        return action;
    }

    public ActionTraceFilter getActionTraceFilter() {
        if (this.trackActionStack) {
            return new ActionTraceFilter();
        }
        return null;
    }

    public static void fixupLoggingContext(org.elasticsearch.common.util.concurrent.ThreadContext threadContext) {
        ThreadContext.put((String)"action_stack", (String)DiagnosticContext.getActionStack(threadContext));
    }

    public static String getActionStack(org.elasticsearch.common.util.concurrent.ThreadContext threadContext) {
        String currentActionStack = (String)threadContext.getTransient(ACTION_STACK_EXTENSION_TRANSIENT);
        if (currentActionStack != null) {
            return currentActionStack;
        }
        return threadContext.getHeader(ACTION_STACK_HEADER);
    }

    private class ActionTraceFilter
    implements ActionFilter {
        private ActionTraceFilter() {
        }

        public int order() {
            return 0;
        }

        public <Request extends ActionRequest, Response extends ActionResponse> void apply(Task task, String action, Request request, ActionListener<Response> listener, ActionFilterChain<Request, Response> chain) {
            String actionStack = DiagnosticContext.this.getActionStack();
            LogContextPreservingActionListener<Response> wrappedListener = LogContextPreservingActionListener.wrapPreservingContext(listener, DiagnosticContext.this.threadContext);
            Throwable throwable = null;
            Object var9_10 = null;
            try (ThreadContext.StoredContext ctx = DiagnosticContext.this.threadContext.newStoredContext(true, CLEAR_TRANSIENT_HEADERS_ON_APPLY);){
                DiagnosticContext.this.traceActionStack(actionStack, action);
                chain.proceed(task, action, request, wrappedListener);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public static class Handle
    implements AutoCloseable {
        @Override
        public void close() {
        }
    }
}

