/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.config.validation;

import com.floragunn.searchsupport.config.validation.ConfigValidationException;
import com.floragunn.searchsupport.config.validation.ValidationError;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.json.JsonXContent;

public class ValidationErrors
implements ToXContent {
    private static final Logger log = LogManager.getLogger(ValidationErrors.class);
    private Multimap<String, ValidationError> attributeToErrorMap;
    private ValidationErrors parent;
    private String attributeInParent;

    public ValidationErrors() {
    }

    public ValidationErrors(ValidationErrors parent, String attributeInParent) {
        this.parent = parent;
        this.attributeInParent = attributeInParent;
    }

    public ValidationErrors(Multimap<String, ValidationError> multimap) {
        this.attributeToErrorMap = multimap;
    }

    public ValidationErrors(ValidationError singleValidationError) {
        this.attributeToErrorMap = ImmutableListMultimap.of((Object)singleValidationError.getAttribute(), (Object)singleValidationError);
    }

    public void throwExceptionForPresentErrors() throws ConfigValidationException {
        if (this.hasErrors()) {
            throw new ConfigValidationException(this);
        }
    }

    public boolean hasErrors() {
        return this.attributeToErrorMap.size() > 0;
    }

    public ValidationErrors add(ValidationError validationError) {
        this.attributeToErrorMap.put((Object)validationError.getAttribute(), (Object)validationError);
        if (this.parent != null) {
            this.parent.add(this.attributeInParent, new ValidationErrors(validationError));
        }
        return this;
    }

    public ValidationErrors add(String attribute, ValidationErrors validationErrors) {
        for (Map.Entry entry : validationErrors.attributeToErrorMap.entries()) {
            String subAttribute = attribute != null && !"_".equals(attribute) ? (entry.getKey() != null && !"_".equals(entry.getKey()) ? (((String)entry.getKey()).startsWith("[") ? String.valueOf(attribute) + (String)entry.getKey() : String.valueOf(attribute) + "." + (String)entry.getKey()) : attribute) : (entry.getKey() != null && !"_".equals(entry.getKey()) ? (String)entry.getKey() : "_");
            this.attributeToErrorMap.put((Object)subAttribute, (Object)((ValidationError)entry.getValue()));
        }
        if (this.parent != null) {
            this.parent.add(attribute == null ? this.attributeInParent : String.valueOf(attribute) + "." + this.attributeInParent, validationErrors);
        }
        return this;
    }

    public ValidationErrors add(String attribute, ConfigValidationException watchValidationException) {
        this.add(attribute, watchValidationException.getValidationErrors());
        return this;
    }

    public String toJson() {
        try {
            XContentBuilder builder = JsonXContent.contentBuilder();
            this.toXContent(builder, ToXContent.EMPTY_PARAMS);
            return Strings.toString((XContentBuilder)builder);
        }
        catch (Exception e) {
            log.error(e.toString(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (Map.Entry entry : this.attributeToErrorMap.entries()) {
            result.append((String)entry.getKey()).append(":\n\t").append(entry.getValue());
            result.append("\n");
        }
        return result.toString();
    }

    public int size() {
        return this.attributeToErrorMap.size();
    }

    public ValidationError getOnlyValidationError() {
        if (this.attributeToErrorMap.size() == 1) {
            ValidationError result = (ValidationError)this.attributeToErrorMap.values().iterator().next();
            result.setAttribute((String)this.attributeToErrorMap.keys().iterator().next());
            return result;
        }
        return null;
    }

    public Exception getCause() {
        for (ValidationError validationError : this.attributeToErrorMap.values()) {
            if (validationError.getCause() == null) continue;
            return validationError.getCause();
        }
        return null;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        for (Map.Entry entry : this.attributeToErrorMap.asMap().entrySet()) {
            builder.field(entry.getKey() != null ? (String)entry.getKey() : "_");
            builder.startArray();
            for (ValidationError validationError : (Collection)entry.getValue()) {
                builder.value((Object)validationError);
            }
            builder.endArray();
        }
        builder.endObject();
        return builder;
    }
}

