/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.config.validation;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.floragunn.searchsupport.config.validation.ConfigValidationException;
import com.floragunn.searchsupport.config.validation.JsonValidationError;
import com.floragunn.searchsupport.config.validation.ValidationError;
import java.io.IOException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.elasticsearch.SpecialPermission;

public class ValidatingJsonParser {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static JsonNode readTree(String string) throws ConfigValidationException {
        try {
            return ValidatingJsonParser.readTree0(string);
        }
        catch (JsonParseException e) {
            throw new ConfigValidationException(new JsonValidationError(null, e));
        }
        catch (IOException e) {
            throw new ConfigValidationException(new ValidationError(null, "Error while parsing JSON document: " + e.getMessage(), null).cause(e));
        }
    }

    public static ObjectNode readObject(String string) throws ConfigValidationException {
        JsonNode jsonNode = ValidatingJsonParser.readTree(string);
        if (jsonNode instanceof ObjectNode) {
            return (ObjectNode)jsonNode;
        }
        throw new ConfigValidationException(new ValidationError(null, "The JSON root node must be an object"));
    }

    private static JsonNode readTree0(final String string) throws IOException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<JsonNode>(){

                @Override
                public JsonNode run() throws Exception {
                    return objectMapper.readTree(string);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }
}

