/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.config.validation;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.floragunn.searchsupport.config.elements.EnumValueParser;
import com.floragunn.searchsupport.config.elements.InlineMustacheTemplate;
import com.floragunn.searchsupport.config.validation.ConfigValidationException;
import com.floragunn.searchsupport.config.validation.InvalidAttributeValue;
import com.floragunn.searchsupport.config.validation.JsonNodeParser;
import com.floragunn.searchsupport.config.validation.MissingAttribute;
import com.floragunn.searchsupport.config.validation.UnsupportedAttribute;
import com.floragunn.searchsupport.config.validation.ValidatingFunction;
import com.floragunn.searchsupport.config.validation.ValidationErrors;
import com.floragunn.searchsupport.config.validation.ValueParser;
import com.floragunn.searchsupport.util.temporal.DurationExpression;
import com.floragunn.searchsupport.util.temporal.DurationFormat;
import com.floragunn.searchsupport.util.temporal.TemporalAmountFormat;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.Function;
import org.apache.commons.validator.routines.EmailValidator;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.script.ScriptService;

public class ValidatingJsonNode {
    private ValidationErrors validationErrors;
    private ScriptService scriptService;
    private JsonNode jsonNode;
    private Set<String> unconsumedAttributes;
    private Set<String> consumedAttributes = new HashSet<String>();

    public ValidatingJsonNode(JsonNode jsonNode, ValidationErrors validationErrors) {
        this.jsonNode = jsonNode;
        this.validationErrors = validationErrors;
        this.unconsumedAttributes = this.getAttributeNames(jsonNode);
    }

    public ValidatingJsonNode(ValidatingJsonNode vJsonNode, ValidationErrors validationErrors) {
        this.jsonNode = vJsonNode.jsonNode;
        this.validationErrors = validationErrors;
        this.unconsumedAttributes = vJsonNode.unconsumedAttributes;
        this.consumedAttributes = vJsonNode.consumedAttributes;
    }

    public ValidatingJsonNode with(ScriptService scriptService) {
        this.scriptService = scriptService;
        return this;
    }

    public void used(String ... attributes) {
        String[] stringArray = attributes;
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            this.consume(attribute);
            ++n2;
        }
    }

    public void used(Set<String> attributes) {
        if (attributes != null) {
            for (String attribute : attributes) {
                this.consume(attribute);
            }
        }
    }

    public JsonNode get(String attribute) {
        this.consume(attribute);
        if (this.jsonNode.hasNonNull(attribute)) {
            return this.jsonNode.get(attribute);
        }
        return null;
    }

    public ValidatingJsonNode getValidatingJsonNode(String attribute) {
        JsonNode node = this.get(attribute);
        if (node != null) {
            ValidationErrors attributeValidationErrors = new ValidationErrors(this.validationErrors, attribute);
            return new ValidatingJsonNode(node, attributeValidationErrors);
        }
        return null;
    }

    public ValidatingJsonNode getRequiredValidatingJsonNode(String attribute) {
        JsonNode node = this.get(attribute);
        if (node != null) {
            ValidationErrors attributeValidationErrors = new ValidationErrors(this.validationErrors, attribute);
            return new ValidatingJsonNode(node, attributeValidationErrors);
        }
        this.validationErrors.add(new MissingAttribute(attribute, this.jsonNode));
        return null;
    }

    public ObjectNode getObjectNode(String attribute) {
        JsonNode attributeNode = this.get(attribute);
        if (attributeNode == null) {
            return null;
        }
        if (attributeNode instanceof ObjectNode) {
            return (ObjectNode)attributeNode;
        }
        this.validationErrors.add(new InvalidAttributeValue(attribute, (Object)attributeNode, (Object)"JSON object", attributeNode));
        return null;
    }

    public boolean hasNonNull(String attribute) {
        this.consume(attribute);
        return this.jsonNode.hasNonNull(attribute);
    }

    public String requiredString(String attribute) {
        this.consume(attribute);
        if (this.jsonNode.hasNonNull(attribute)) {
            return this.jsonNode.get(attribute).asText();
        }
        this.validationErrors.add(new MissingAttribute(attribute, this.jsonNode));
        return null;
    }

    public int requiredInt(String attribute) {
        this.consume(attribute);
        if (this.jsonNode.hasNonNull(attribute)) {
            JsonNode attributeNode = this.jsonNode.get(attribute);
            if (attributeNode.isNumber()) {
                return attributeNode.asInt();
            }
            this.validationErrors.add(new InvalidAttributeValue(attribute, (Object)attributeNode.toString(), (Object)"number", attributeNode));
            return 0;
        }
        this.validationErrors.add(new MissingAttribute(attribute, this.jsonNode));
        return 0;
    }

    public long requiredLong(String attribute) {
        this.consume(attribute);
        if (this.jsonNode.hasNonNull(attribute)) {
            JsonNode attributeNode = this.jsonNode.get(attribute);
            if (attributeNode.isNumber()) {
                return attributeNode.asLong();
            }
            this.validationErrors.add(new InvalidAttributeValue(attribute, (Object)attributeNode.toString(), (Object)"number", attributeNode));
            return 0L;
        }
        this.validationErrors.add(new MissingAttribute(attribute, this.jsonNode));
        return 0L;
    }

    public BigDecimal requiredBigDecimal(String attribute) {
        this.consume(attribute);
        if (this.jsonNode.hasNonNull(attribute)) {
            JsonNode attributeNode = this.jsonNode.get(attribute);
            if (attributeNode.isNumber()) {
                return attributeNode.decimalValue();
            }
            this.validationErrors.add(new InvalidAttributeValue(attribute, (Object)attributeNode.toString(), (Object)"number", attributeNode));
            return null;
        }
        this.validationErrors.add(new MissingAttribute(attribute, this.jsonNode));
        return null;
    }

    public BigDecimal decimalValue(String attribute, BigDecimal defaultValue) {
        this.consume(attribute);
        if (this.jsonNode.hasNonNull(attribute)) {
            JsonNode attributeNode = this.jsonNode.get(attribute);
            if (attributeNode.isNumber()) {
                return attributeNode.decimalValue();
            }
            this.validationErrors.add(new InvalidAttributeValue(attribute, (Object)attributeNode.toString(), (Object)"number", attributeNode));
            return null;
        }
        return defaultValue;
    }

    public ArrayNode requiredArray(String attribute) {
        this.consume(attribute);
        if (this.jsonNode.hasNonNull(attribute)) {
            JsonNode attributeNode = this.jsonNode.get(attribute);
            if (attributeNode instanceof ArrayNode) {
                return (ArrayNode)attributeNode;
            }
            this.validationErrors.add(new InvalidAttributeValue(attribute, (Object)attributeNode.toString(), (Object)"Array", attributeNode));
            return null;
        }
        this.validationErrors.add(new MissingAttribute(attribute, this.jsonNode));
        return null;
    }

    public ObjectNode requiredObject(String attribute) {
        this.consume(attribute);
        if (this.jsonNode.hasNonNull(attribute)) {
            JsonNode attributeNode = this.jsonNode.get(attribute);
            if (attributeNode instanceof ObjectNode) {
                return (ObjectNode)attributeNode;
            }
            this.validationErrors.add(new InvalidAttributeValue(attribute, (Object)attributeNode.toString(), (Object)"Object", attributeNode));
            return null;
        }
        this.validationErrors.add(new MissingAttribute(attribute, this.jsonNode));
        return null;
    }

    public String string(String attribute) {
        this.consume(attribute);
        if (this.jsonNode.hasNonNull(attribute)) {
            return this.jsonNode.get(attribute).asText();
        }
        return null;
    }

    public String string(String attribute, String defaultValue) {
        this.consume(attribute);
        if (this.jsonNode.hasNonNull(attribute)) {
            return this.jsonNode.get(attribute).asText();
        }
        return defaultValue;
    }

    public String emailAddress(String attribute) {
        this.consume(attribute);
        if (this.jsonNode.hasNonNull(attribute)) {
            String value = this.jsonNode.get(attribute).asText();
            if (EmailValidator.getInstance((boolean)true, (boolean)true).isValid(value)) {
                return value;
            }
            this.validationErrors.add(new InvalidAttributeValue(attribute, (Object)value, (Object)"E-mail address", this.jsonNode));
            return null;
        }
        return null;
    }

    public List<String> emailAddressList(String attribute) {
        this.consume(attribute);
        if (this.jsonNode.hasNonNull(attribute)) {
            List<String> result;
            JsonNode subNode = this.jsonNode.get(attribute);
            if (subNode.isArray()) {
                ArrayNode arrayNode = (ArrayNode)subNode;
                result = new ArrayList<String>(arrayNode.size());
                for (JsonNode child : arrayNode) {
                    result.add(child.asText());
                }
            } else {
                result = Collections.singletonList(subNode.textValue());
            }
            int errorCount = 0;
            for (String address : result) {
                if (EmailValidator.getInstance((boolean)true, (boolean)true).isValid(address)) continue;
                this.validationErrors.add(new InvalidAttributeValue(attribute, (Object)address, (Object)"E-mail address", this.jsonNode));
                ++errorCount;
            }
            if (errorCount == 0) {
                return result;
            }
            return null;
        }
        return null;
    }

    public String[] emailAddressArray(String attribute) {
        this.consume(attribute);
        List<String> result = this.emailAddressList(attribute);
        if (result != null) {
            return result.toArray(new String[result.size()]);
        }
        return null;
    }

    public Integer intNumber(String attribute, Integer defaultValue) {
        this.consume(attribute);
        if (this.jsonNode.hasNonNull(attribute)) {
            JsonNode attributeNode = this.jsonNode.get(attribute);
            if (attributeNode.isNumber()) {
                return attributeNode.asInt();
            }
            return defaultValue;
        }
        return defaultValue;
    }

    public Long longNumber(String attribute, Long defaultValue) {
        this.consume(attribute);
        if (this.jsonNode.hasNonNull(attribute)) {
            JsonNode attributeNode = this.jsonNode.get(attribute);
            if (attributeNode.isNumber()) {
                return attributeNode.asLong();
            }
            return defaultValue;
        }
        return defaultValue;
    }

    public Boolean booleanAttribute(String attribute, Boolean defaultValue) {
        this.consume(attribute);
        if (this.jsonNode.hasNonNull(attribute)) {
            JsonNode attributeNode = this.jsonNode.get(attribute);
            if (attributeNode.isBoolean()) {
                return attributeNode.asBoolean();
            }
            return defaultValue;
        }
        return defaultValue;
    }

    public Boolean booleanAttributeStrict(String attribute, Boolean defaultValue) {
        this.consume(attribute);
        if (this.jsonNode.hasNonNull(attribute)) {
            JsonNode attributeNode = this.jsonNode.get(attribute);
            if (attributeNode.isBoolean()) {
                return attributeNode.asBoolean();
            }
            this.validationErrors.add(new InvalidAttributeValue(attribute, this.jsonNode.get(attribute), "Must be true or false"));
            return defaultValue;
        }
        return defaultValue;
    }

    public List<String> requiredStringList(String attribute, int minLength) {
        this.consume(attribute);
        if (this.jsonNode.hasNonNull(attribute)) {
            List<String> result = this.stringList(attribute);
            if (result != null && result.size() < minLength) {
                if (minLength == 1) {
                    this.validationErrors.add(new InvalidAttributeValue(attribute, this.jsonNode.get(attribute), "At least one element is required"));
                } else {
                    this.validationErrors.add(new InvalidAttributeValue(attribute, this.jsonNode.get(attribute), "At least " + minLength + " elements are required"));
                }
            }
            return result;
        }
        this.validationErrors.add(new MissingAttribute(attribute, this.jsonNode));
        return null;
    }

    public List<String> stringList(String attribute) {
        return this.stringList(attribute, null);
    }

    public List<String> stringList(String attribute, List<String> defaultValue) {
        this.consume(attribute);
        if (this.jsonNode.hasNonNull(attribute)) {
            JsonNode subNode = this.jsonNode.get(attribute);
            if (subNode.isArray()) {
                ArrayNode arrayNode = (ArrayNode)subNode;
                ArrayList<String> result = new ArrayList<String>(arrayNode.size());
                for (JsonNode child : arrayNode) {
                    result.add(child.asText());
                }
                return result;
            }
            return Collections.singletonList(subNode.textValue());
        }
        return defaultValue;
    }

    public String[] stringArray(String attribute) {
        this.consume(attribute);
        List<String> list = this.stringList(attribute);
        if (list != null) {
            return list.toArray(new String[list.size()]);
        }
        return null;
    }

    public TimeZone timeZone(String attribute) {
        this.consume(attribute);
        if (this.jsonNode.hasNonNull(attribute)) {
            String timeZoneId = this.jsonNode.get(attribute).asText();
            TimeZone timeZone = TimeZone.getTimeZone(timeZoneId);
            if (timeZone == null) {
                this.validationErrors.add(new InvalidAttributeValue(attribute, (Object)timeZoneId, TimeZone.class, this.jsonNode));
            }
            return timeZone;
        }
        return null;
    }

    public Duration duration(String attribute) {
        this.consume(attribute);
        if (this.jsonNode.hasNonNull(attribute)) {
            try {
                return DurationFormat.INSTANCE.parse(this.jsonNode.get(attribute).textValue());
            }
            catch (ConfigValidationException e) {
                this.validationErrors.add(attribute, e);
                return null;
            }
        }
        return null;
    }

    public DurationExpression durationExpression(String attribute) {
        this.consume(attribute);
        if (this.jsonNode.hasNonNull(attribute)) {
            try {
                return DurationExpression.parse(this.jsonNode.get(attribute).textValue());
            }
            catch (ConfigValidationException e) {
                this.validationErrors.add(attribute, e);
                return null;
            }
        }
        return null;
    }

    public TemporalAmount temporalAmount(String attribute) {
        this.consume(attribute);
        if (this.jsonNode.hasNonNull(attribute)) {
            try {
                return TemporalAmountFormat.INSTANCE.parse(this.jsonNode.get(attribute).textValue());
            }
            catch (ConfigValidationException e) {
                this.validationErrors.add(attribute, e);
                return null;
            }
        }
        return null;
    }

    public TimeValue timeValue(String attribute) {
        this.consume(attribute);
        if (this.jsonNode.hasNonNull(attribute)) {
            try {
                return TimeValue.parseTimeValue((String)this.jsonNode.get(attribute).textValue(), (String)attribute);
            }
            catch (IllegalArgumentException e) {
                this.validationErrors.add(new InvalidAttributeValue(attribute, (Object)this.jsonNode.get(attribute).textValue(), "<time value> (d|h|m|s|ms)"));
                return null;
            }
        }
        return null;
    }

    public InlineMustacheTemplate<String> template(String attribute) {
        this.consume(attribute);
        if (this.jsonNode.hasNonNull(attribute)) {
            try {
                return InlineMustacheTemplate.parse(this.scriptService, this.jsonNode.get(attribute).asText());
            }
            catch (ConfigValidationException e) {
                this.validationErrors.add(attribute, e);
                return null;
            }
        }
        return null;
    }

    public <R> InlineMustacheTemplate<R> template(String attribute, ValidatingFunction<String, R> conversionFunction, Object expectedValue) {
        this.consume(attribute);
        if (this.jsonNode.hasNonNull(attribute)) {
            try {
                return InlineMustacheTemplate.parse(this.scriptService, this.jsonNode.get(attribute).asText(), conversionFunction, expectedValue);
            }
            catch (ConfigValidationException e) {
                this.validationErrors.add(attribute, e);
                return null;
            }
        }
        return null;
    }

    public <R extends Enum<R>> InlineMustacheTemplate<R> template(String attribute, Class<R> enumClass) {
        this.consume(attribute);
        if (this.jsonNode.hasNonNull(attribute)) {
            try {
                return InlineMustacheTemplate.parse(this.scriptService, this.jsonNode.get(attribute).asText(), new EnumValueParser<R>(enumClass), enumClass);
            }
            catch (ConfigValidationException e) {
                this.validationErrors.add(attribute, e);
                return null;
            }
        }
        return null;
    }

    public InlineMustacheTemplate<String> requiredTemplate(String attribute) {
        this.consume(attribute);
        if (this.jsonNode.hasNonNull(attribute)) {
            return this.template(attribute);
        }
        this.validationErrors.add(new MissingAttribute(attribute, this.jsonNode));
        return null;
    }

    public <R> InlineMustacheTemplate<R> requiredTemplate(String attribute, ValidatingFunction<String, R> conversionFunction, Object expectedValue) {
        this.consume(attribute);
        if (this.jsonNode.hasNonNull(attribute)) {
            return this.template(attribute, conversionFunction, expectedValue);
        }
        this.validationErrors.add(new MissingAttribute(attribute, this.jsonNode));
        return null;
    }

    public <R extends Enum<R>> InlineMustacheTemplate<R> requiredTemplate(String attribute, Class<R> enumClass) {
        this.consume(attribute);
        if (this.jsonNode.hasNonNull(attribute)) {
            return this.template(attribute, enumClass);
        }
        this.validationErrors.add(new MissingAttribute(attribute, this.jsonNode));
        return null;
    }

    public <R> R requiredValue(String attribute, Function<String, R> conversionFunction, Object expected) {
        this.consume(attribute);
        if (this.jsonNode.hasNonNull(attribute)) {
            return this.value(attribute, conversionFunction, expected, null);
        }
        this.validationErrors.add(new MissingAttribute(attribute, this.jsonNode));
        return null;
    }

    public <R> R value(String attribute, Function<String, R> conversionFunction, Object expected, R defaultValue) {
        this.consume(attribute);
        if (!this.jsonNode.hasNonNull(attribute)) {
            return defaultValue;
        }
        String value = this.jsonNode.get(attribute).asText();
        try {
            return conversionFunction.apply(value);
        }
        catch (Exception e) {
            this.validationErrors.add(new InvalidAttributeValue(attribute, (Object)value, expected, this.jsonNode).cause(e));
            return defaultValue;
        }
    }

    public <R> R requiredValue(String attribute, ValueParser<R> valueParser) {
        this.consume(attribute);
        if (this.jsonNode.hasNonNull(attribute)) {
            return this.value(attribute, valueParser, null);
        }
        this.validationErrors.add(new MissingAttribute(attribute, this.jsonNode));
        return null;
    }

    public <R> R value(String attribute, ValueParser<R> valueParser, R defaultValue) {
        this.consume(attribute);
        if (!this.jsonNode.hasNonNull(attribute)) {
            return defaultValue;
        }
        String value = this.jsonNode.get(attribute).asText();
        try {
            return valueParser.parse(value);
        }
        catch (ConfigValidationException e) {
            this.validationErrors.add(attribute, e.getValidationErrors());
            return defaultValue;
        }
        catch (Exception e) {
            this.validationErrors.add(new InvalidAttributeValue(attribute, (Object)value, (Object)valueParser.getExpectedValue(), this.jsonNode).cause(e));
            return defaultValue;
        }
    }

    public <R> R requiredValue(String attribute, JsonNodeParser<R> valueParser) {
        this.consume(attribute);
        if (this.jsonNode.hasNonNull(attribute)) {
            return this.value(attribute, valueParser, null);
        }
        this.validationErrors.add(new MissingAttribute(attribute, this.jsonNode));
        return null;
    }

    public <R> R value(String attribute, JsonNodeParser<R> conversionFunction, R defaultValue) {
        this.consume(attribute);
        if (!this.jsonNode.hasNonNull(attribute)) {
            return defaultValue;
        }
        JsonNode subNode = this.jsonNode.get(attribute);
        try {
            return conversionFunction.parse(subNode);
        }
        catch (ConfigValidationException e) {
            this.validationErrors.add(attribute, e.getValidationErrors());
            return defaultValue;
        }
        catch (Exception e) {
            this.validationErrors.add(new InvalidAttributeValue(attribute, (Object)subNode, (Object)conversionFunction.getExpectedValue(), this.jsonNode).cause(e));
            return defaultValue;
        }
    }

    public <R> List<R> list(String attribute, JsonNodeParser<R> conversionFunction) {
        return this.list(attribute, conversionFunction, Collections.emptyList());
    }

    public <R> List<R> list(String attribute, JsonNodeParser<R> conversionFunction, List<R> defaultValue) {
        this.consume(attribute);
        if (!this.jsonNode.hasNonNull(attribute)) {
            return defaultValue;
        }
        JsonNode value = this.jsonNode.get(attribute);
        if (!value.isArray()) {
            this.validationErrors.add(new InvalidAttributeValue(attribute, (Object)value, (Object)"Array", this.jsonNode));
            return defaultValue;
        }
        ArrayNode arrayNode = (ArrayNode)value;
        ArrayList<R> result = new ArrayList<R>(arrayNode.size());
        for (JsonNode elementNode : arrayNode) {
            try {
                result.add(conversionFunction.parse(elementNode));
            }
            catch (Exception e) {
                this.validationErrors.add(new InvalidAttributeValue(attribute, (Object)value, null, this.jsonNode).cause(e));
                return defaultValue;
            }
        }
        return result;
    }

    public <E extends Enum<E>> E caseInsensitiveEnum(String attribute, Class<E> enumClass, E defaultValue) {
        this.consume(attribute);
        if (!this.jsonNode.hasNonNull(attribute)) {
            return defaultValue;
        }
        String value = this.jsonNode.get(attribute).asText();
        Enum[] enumArray = (Enum[])enumClass.getEnumConstants();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enum enum_ = enumArray[n2];
            if (value.equalsIgnoreCase(enum_.name())) {
                return (E)enum_;
            }
            ++n2;
        }
        this.validationErrors.add(new InvalidAttributeValue(attribute, (Object)value, enumClass, this.jsonNode));
        return defaultValue;
    }

    public <E extends Enum<E>> E requiredCaseInsensitiveEnum(String attribute, Class<E> enumClass) {
        if (!this.jsonNode.hasNonNull(attribute)) {
            this.validationErrors.add(new MissingAttribute(attribute, this.jsonNode));
            return null;
        }
        return this.caseInsensitiveEnum(attribute, enumClass, null);
    }

    public URI requiredURI(String attribute) {
        this.consume(attribute);
        if (this.jsonNode.hasNonNull(attribute)) {
            String value = this.jsonNode.get(attribute).asText();
            try {
                URI result = new URI(value);
                if (!result.isAbsolute()) {
                    this.validationErrors.add(new InvalidAttributeValue(attribute, (Object)value, (Object)"URI", this.jsonNode).message("Must be an absolute URI"));
                }
                return result;
            }
            catch (URISyntaxException e) {
                this.validationErrors.add(new InvalidAttributeValue(attribute, (Object)value, (Object)"URI", this.jsonNode).message(e.getMessage()).cause(e));
                return null;
            }
        }
        this.validationErrors.add(new MissingAttribute(attribute, this.jsonNode));
        return null;
    }

    public void validateUnusedAttributes() {
        for (String attribute : this.unconsumedAttributes) {
            this.validationErrors.add(new UnsupportedAttribute(attribute, (Object)(this.jsonNode.get(attribute) != null ? this.jsonNode.get(attribute).toString() : null), this.jsonNode));
        }
    }

    public JsonNode getDelegate() {
        return this.jsonNode;
    }

    private Set<String> getAttributeNames(JsonNode jsonNode) {
        if (!(jsonNode instanceof ObjectNode)) {
            return new HashSet<String>();
        }
        ObjectNode objectNode = (ObjectNode)jsonNode;
        HashSet<String> result = new HashSet<String>(objectNode.size());
        Iterator iter = objectNode.fieldNames();
        while (iter.hasNext()) {
            result.add((String)iter.next());
        }
        return result;
    }

    private void consume(String attribute) {
        this.unconsumedAttributes.remove(attribute);
        this.consumedAttributes.add(attribute);
    }
}

