/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.config.validation;

import com.floragunn.searchsupport.config.validation.ValidationError;
import java.io.IOException;
import org.apache.logging.log4j.util.Strings;
import org.elasticsearch.script.ScriptException;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class ScriptValidationError
extends ValidationError {
    private String context;

    public ScriptValidationError(String attribute, ScriptException scriptException) {
        super(attribute, ScriptValidationError.getMessage(scriptException));
        this.cause((Exception)scriptException);
        if (scriptException.getScriptStack() != null && scriptException.getScriptStack().size() > 0) {
            this.context = Strings.join((Iterable)scriptException.getScriptStack(), (char)'\n');
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("error", this.getMessage());
        if (this.context != null) {
            builder.field("context", this.context);
        }
        builder.endObject();
        return builder;
    }

    private static String getMessage(ScriptException scriptException) {
        if ("compile error".equals(scriptException.getMessage())) {
            if (scriptException.getCause() != null) {
                return scriptException.getCause().getMessage();
            }
            return "Compilation Error";
        }
        return scriptException.getMessage();
    }
}

