/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.config.validation;

import com.floragunn.searchsupport.config.validation.ValidationError;
import java.io.IOException;
import org.apache.logging.log4j.util.Strings;
import org.elasticsearch.script.ScriptException;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class ScriptExecutionError
extends ValidationError {
    private String context;

    public ScriptExecutionError(String attribute, ScriptException scriptException) {
        super(attribute, ScriptExecutionError.getMessage(scriptException));
        this.cause((Exception)scriptException);
        if (scriptException.getScriptStack() != null && scriptException.getScriptStack().size() > 0) {
            this.context = Strings.join((Iterable)scriptException.getScriptStack(), (char)'\n');
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("error", this.getMessage());
        if (this.context != null) {
            builder.field("context", this.context);
        }
        builder.endObject();
        return builder;
    }

    private static String getMessage(ScriptException scriptException) {
        if ("runtime error".equals(scriptException.getMessage())) {
            if (scriptException.getCause() != null) {
                return ScriptExecutionError.constructMessage(scriptException.getCause());
            }
            return "Runtime Error";
        }
        return ScriptExecutionError.constructMessage((Throwable)scriptException);
    }

    private static String constructMessage(Throwable throwable) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < 10) {
            String message = throwable.getMessage();
            if (message == null) {
                message = throwable.toString();
            }
            if (result.indexOf(message) == -1) {
                if (result.length() != 0) {
                    result.append(":\n");
                }
                result.append(message);
            }
            if (throwable.getCause() == throwable || throwable.getCause() == null) break;
            throwable = throwable.getCause();
            ++i;
        }
        return result.toString();
    }
}

