/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.config.validation;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.floragunn.searchsupport.config.validation.ValidationError;
import java.io.IOException;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class JsonValidationError
extends ValidationError {
    private JsonLocation jsonLocation;
    private String context;

    JsonValidationError(String attribute, JsonParseException jsonParseException) {
        super(attribute, "Error while parsing JSON document: " + jsonParseException.getOriginalMessage());
        this.cause((Exception)((Object)jsonParseException));
        this.jsonLocation = jsonParseException.getLocation();
        this.context = jsonParseException.getRequestPayloadAsString();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("error", this.getMessage());
        if (this.jsonLocation != null) {
            builder.field("line", this.jsonLocation.getLineNr());
        }
        if (this.jsonLocation != null) {
            builder.field("column", this.jsonLocation.getColumnNr());
        }
        if (this.context != null) {
            builder.field("context", this.context);
        }
        builder.endObject();
        return builder;
    }
}

