/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.config.validation;

import com.fasterxml.jackson.databind.JsonNode;
import com.floragunn.searchsupport.config.validation.ValidatingJsonNode;
import com.floragunn.searchsupport.config.validation.ValidationError;
import java.io.IOException;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class InvalidAttributeValue
extends ValidationError {
    private final Object expected;
    private final Object value;

    public InvalidAttributeValue(String attribute, Object value, Object expected, JsonNode jsonNode) {
        super(attribute, "Invalid value", jsonNode);
        this.expected = expected;
        this.value = value;
    }

    public InvalidAttributeValue(String attribute, Object value, Object expected, ValidatingJsonNode jsonNode) {
        this(attribute, value, expected, jsonNode.getDelegate());
    }

    public InvalidAttributeValue(String attribute, Object value, Object expected) {
        this(attribute, value, expected, (JsonNode)null);
    }

    public Object getExpected() {
        return this.expected;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("error", this.getMessage());
        builder.field("value", this.value);
        if (this.expected != null) {
            builder.field("expected", InvalidAttributeValue.expectedToString(this.expected));
        }
        builder.endObject();
        return builder;
    }

    private static String expectedToString(Object expected) {
        if (expected == null) {
            return null;
        }
        if (expected instanceof Class && ((Class)expected).isEnum()) {
            return InvalidAttributeValue.getEnumValues((Class)expected);
        }
        return expected.toString();
    }

    private static <E extends Enum<E>> String getEnumValues(Class<E> enumClass) {
        StringBuilder result = new StringBuilder();
        Enum[] enumArray = (Enum[])enumClass.getEnumConstants();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enum enum_ = enumArray[n2];
            if (result.length() > 0) {
                result.append("|");
            }
            result.append(enum_.name());
            ++n2;
        }
        return result.toString();
    }

    @Override
    public String toString() {
        return "InvalidAttributeValue [expected=" + this.expected + ", value=" + this.value + ", attribute=" + this.getAttribute() + "]";
    }
}

