/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.config.proxy;

import com.floragunn.searchsupport.config.validation.ConfigValidationException;
import com.floragunn.searchsupport.config.validation.InvalidAttributeValue;
import org.apache.http.HttpHost;
import org.apache.http.impl.client.HttpClientBuilder;
import org.elasticsearch.common.settings.Settings;

public class ProxyConfig {
    private final HttpHost host;

    public ProxyConfig(HttpHost host) {
        this.host = host;
    }

    public void apply(HttpClientBuilder httpClientBuilder) {
        if (this.host != null) {
            httpClientBuilder.setProxy(this.host);
        }
    }

    public static ProxyConfig parse(Settings settings, String property) throws ConfigValidationException {
        Settings subSettings = settings.getByPrefix(String.valueOf(property) + ".");
        if (!subSettings.isEmpty() && subSettings.hasValue("host")) {
            String hostName = subSettings.get("host");
            int port = subSettings.getAsInt("port", Integer.valueOf(80));
            String scheme = subSettings.get("scheme", "https");
            return new ProxyConfig(new HttpHost(hostName, port, scheme));
        }
        if (settings.hasValue(property)) {
            String simpleString = settings.get(property);
            try {
                return new ProxyConfig(HttpHost.create((String)simpleString));
            }
            catch (IllegalArgumentException e) {
                throw new ConfigValidationException(new InvalidAttributeValue(property, (Object)"HTTP host URL", simpleString).cause(e));
            }
        }
        return new ProxyConfig(null);
    }

    public HttpHost getHost() {
        return this.host;
    }
}

