/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.client;

import com.floragunn.searchsupport.diag.DiagnosticContext;
import com.floragunn.searchsupport.diag.LogContextPreservingActionListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.FilterClient;
import org.elasticsearch.common.util.concurrent.ThreadContext;

public class ContextHeaderDecoratorClient
extends FilterClient {
    private Map<String, String> headers;

    public ContextHeaderDecoratorClient(Client in, Map<String, String> headers) {
        super(in);
        this.headers = headers != null ? headers : Collections.emptyMap();
    }

    public ContextHeaderDecoratorClient(Client in, String ... headers) {
        this(in, ContextHeaderDecoratorClient.arrayToMap(headers));
    }

    protected <Request extends ActionRequest, Response extends ActionResponse> void doExecute(ActionType<Response> action, Request request, ActionListener<Response> listener) {
        ThreadContext threadContext = this.threadPool().getThreadContext();
        LogContextPreservingActionListener<Response> wrappedListener = LogContextPreservingActionListener.wrapPreservingContext(listener, threadContext);
        String actionStack = DiagnosticContext.getActionStack(threadContext);
        Throwable throwable = null;
        Object var8_9 = null;
        try (ThreadContext.StoredContext ctx = threadContext.stashContext();){
            threadContext.putHeader(this.headers);
            if (actionStack != null) {
                threadContext.putHeader("x_action_stack", actionStack);
                DiagnosticContext.fixupLoggingContext(threadContext);
            }
            super.doExecute(action, request, wrappedListener);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static Map<String, String> arrayToMap(String[] headers) {
        if (headers == null) {
            return null;
        }
        if (headers.length % 2 != 0) {
            throw new IllegalArgumentException("The headers array must consist of key-value pairs");
        }
        HashMap<String, String> result = new HashMap<String, String>(headers.length / 2);
        int i = 0;
        while (i < headers.length) {
            result.put(headers[i], headers[i + 1]);
            i += 2;
        }
        return result;
    }
}

