/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.array;

import java.io.Serializable;

public class Long2IntOpenHashMap
implements Serializable,
Cloneable {
    protected static final float FILL_FACTOR = 0.75f;
    protected static final int INITIAL_ELEMENT_COUNT = 16;
    protected transient long[] key;
    protected transient int[] value;
    protected transient int mask;
    protected transient boolean containsNullKey;
    protected transient int n;
    protected transient int maxFill;
    protected final transient int minN;
    protected int size;
    protected int defRetValue;

    public Long2IntOpenHashMap() {
        this.minN = this.n = Long2IntOpenHashMap.arraySize(16, 0.75f);
        this.mask = this.n - 1;
        this.maxFill = Long2IntOpenHashMap.maxFill(this.n, 0.75f);
        this.key = new long[this.n + 1];
        this.value = new int[this.n + 1];
    }

    public void setDefaultReturnValue(int rv) {
        this.defRetValue = rv;
    }

    public int getDefaultReturnValue() {
        return this.defRetValue;
    }

    public int addTo(long k, int incr) {
        int pos;
        if (k == 0L) {
            if (this.containsNullKey) {
                return this.addToValue(this.n, incr);
            }
            pos = this.n;
            this.containsNullKey = true;
        } else {
            long[] key = this.key;
            pos = (int)Long2IntOpenHashMap.mix(k) & this.mask;
            long curr = key[pos];
            if (curr != 0L) {
                if (curr == k) {
                    return this.addToValue(pos, incr);
                }
                while (curr != 0L) {
                    if (curr == k) {
                        return this.addToValue(pos, incr);
                    }
                    pos = pos + 1 & this.mask;
                    curr = key[pos];
                }
            }
        }
        this.key[pos] = k;
        this.value[pos] = this.defRetValue + incr;
        if (this.size++ >= this.maxFill) {
            this.rehash(Long2IntOpenHashMap.arraySize(this.size + 1, 0.75f));
        }
        return this.defRetValue;
    }

    public int get(long k) {
        if (k == 0L) {
            return this.containsNullKey ? this.value[this.n] : this.defRetValue;
        }
        long[] key = this.key;
        int pos = (int)Long2IntOpenHashMap.mix(k) & this.mask;
        long curr = key[pos];
        if (curr == 0L) {
            return this.defRetValue;
        }
        if (k == curr) {
            return this.value[pos];
        }
        while (curr != 0L) {
            if (k == curr) {
                return this.value[pos];
            }
            pos = pos + 1 & this.mask;
            curr = key[pos];
        }
        return this.defRetValue;
    }

    public int remove(long k) {
        if (k == 0L) {
            return this.containsNullKey ? this.removeNullEntry() : this.defRetValue;
        }
        long[] key = this.key;
        int pos = (int)Long2IntOpenHashMap.mix(k) & this.mask;
        long curr = key[pos];
        if (curr == 0L) {
            return this.defRetValue;
        }
        if (k == curr) {
            return this.removeEntry(pos);
        }
        while (curr != 0L) {
            if (k == curr) {
                return this.removeEntry(pos);
            }
            pos = pos + 1 & this.mask;
            curr = key[pos];
        }
        return this.defRetValue;
    }

    public int size() {
        return this.size;
    }

    protected void rehash(int newN) {
        long[] key = this.key;
        int[] value = this.value;
        int mask = newN - 1;
        long[] newKey = new long[newN + 1];
        int[] newValue = new int[newN + 1];
        int i = this.n;
        int size = this.realSize();
        while (size-- != 0) {
            while (key[--i] == 0L) {
            }
            int pos = (int)Long2IntOpenHashMap.mix(key[i]) & mask;
            if (newKey[pos] != 0L) {
                while (newKey[pos] != 0L) {
                    pos = pos + 1 & mask;
                }
            }
            newKey[pos] = key[i];
            newValue[pos] = value[i];
        }
        newValue[newN] = value[this.n];
        this.n = newN;
        this.mask = mask;
        this.maxFill = Long2IntOpenHashMap.maxFill(this.n, 0.75f);
        this.key = newKey;
        this.value = newValue;
    }

    private int addToValue(int pos, int incr) {
        int oldValue = this.value[pos];
        this.value[pos] = oldValue + incr;
        return oldValue;
    }

    private int removeNullEntry() {
        this.containsNullKey = false;
        int oldValue = this.value[this.n];
        --this.size;
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return oldValue;
    }

    private int removeEntry(int pos) {
        int oldValue = this.value[pos];
        --this.size;
        this.shiftKeys(pos);
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return oldValue;
    }

    private static int arraySize(int expected, float f) {
        long s = Math.max(2L, Long2IntOpenHashMap.nextPowerOfTwo((long)Math.ceil((float)expected / f)));
        if (s > 0x40000000L) {
            throw new IllegalArgumentException("Too large (" + expected + " expected elements with load factor " + f + ")");
        }
        return (int)s;
    }

    private static int maxFill(int n, float f) {
        return Math.min((int)Math.ceil((float)n * f), n - 1);
    }

    public static long mix(long x) {
        long h = x * -7046029254386353131L;
        h ^= h >>> 32;
        return h ^ h >>> 16;
    }

    protected final void shiftKeys(int pos) {
        long[] key = this.key;
        while (true) {
            long curr;
            int last = pos;
            pos = pos + 1 & this.mask;
            while (true) {
                if ((curr = key[pos]) == 0L) {
                    key[last] = 0L;
                    return;
                }
                int slot = (int)Long2IntOpenHashMap.mix(curr) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & this.mask;
            }
            key[last] = curr;
            this.value[last] = this.value[pos];
        }
    }

    private int realSize() {
        return this.containsNullKey ? this.size - 1 : this.size;
    }

    private static long nextPowerOfTwo(long x) {
        if (x == 0L) {
            return 1L;
        }
        --x;
        x |= x >> 1;
        x |= x >> 2;
        x |= x >> 4;
        x |= x >> 8;
        x |= x >> 16;
        return (x | x >> 32) + 1L;
    }
}

