/*
 * Decompiled with CFR 0.152.
 */
package com.exceptionfactory.jagged.x25519;

import com.exceptionfactory.jagged.framework.crypto.CipherKey;
import com.exceptionfactory.jagged.framework.crypto.HashedDerivedKeyProducer;
import com.exceptionfactory.jagged.framework.crypto.MacKey;
import com.exceptionfactory.jagged.framework.crypto.SharedSaltKey;
import com.exceptionfactory.jagged.framework.crypto.SharedSecretKey;
import com.exceptionfactory.jagged.x25519.RecipientIndicator;
import com.exceptionfactory.jagged.x25519.RecipientKeyType;
import com.exceptionfactory.jagged.x25519.SharedWrapKeyProducer;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.util.Objects;
import javax.crypto.SecretKey;

class X25519SharedWrapKeyProducer
extends HashedDerivedKeyProducer
implements SharedWrapKeyProducer {
    private static final byte[] KEY_INFORMATION = RecipientIndicator.KEY_INFORMATION.getIndicator().getBytes(StandardCharsets.UTF_8);
    private static final int PUBLIC_COORDINATE_LENGTH = RecipientKeyType.X25519.getKeyLength();
    private static final int SHARED_SALT_KEY_LENGTH = 64;
    private final byte[] recipientPublicCoordinate;

    X25519SharedWrapKeyProducer(PublicKey recipientPublicKey) {
        this.recipientPublicCoordinate = X25519SharedWrapKeyProducer.getPublicCoordinate(Objects.requireNonNull(recipientPublicKey, "Recipient Public Key required"));
    }

    @Override
    public CipherKey getWrapKey(SharedSecretKey sharedSecretKey, PublicKey ephemeralPublicKey) throws GeneralSecurityException {
        Objects.requireNonNull(sharedSecretKey, "Shared Secret Key required");
        Objects.requireNonNull(ephemeralPublicKey, "Ephemeral Public Key required");
        SharedSaltKey sharedSaltKey = this.getSharedSaltKey(ephemeralPublicKey);
        byte[] wrapKey = this.getDerivedKey((SecretKey)sharedSecretKey, (MacKey)sharedSaltKey, KEY_INFORMATION);
        return new CipherKey(wrapKey);
    }

    private SharedSaltKey getSharedSaltKey(PublicKey ephemeralPublicKey) {
        byte[] saltKey = new byte[64];
        byte[] ephemeralPublicCoordinate = X25519SharedWrapKeyProducer.getPublicCoordinate(ephemeralPublicKey);
        System.arraycopy(ephemeralPublicCoordinate, 0, saltKey, 0, PUBLIC_COORDINATE_LENGTH);
        System.arraycopy(this.recipientPublicCoordinate, 0, saltKey, PUBLIC_COORDINATE_LENGTH, PUBLIC_COORDINATE_LENGTH);
        return new SharedSaltKey(saltKey);
    }

    private static byte[] getPublicCoordinate(PublicKey publicKey) {
        byte[] encoded = publicKey.getEncoded();
        int encodedLength = encoded.length;
        int headerLength = encodedLength - PUBLIC_COORDINATE_LENGTH;
        return X25519SharedWrapKeyProducer.getPublicCoordinate(encoded, headerLength);
    }

    private static byte[] getPublicCoordinate(byte[] encoded, int startPosition) {
        byte[] publicCoordinate = new byte[PUBLIC_COORDINATE_LENGTH];
        System.arraycopy(encoded, startPosition, publicCoordinate, 0, PUBLIC_COORDINATE_LENGTH);
        return publicCoordinate;
    }
}

