/*
 * Decompiled with CFR 0.152.
 */
package com.exceptionfactory.jagged.x25519;

import com.exceptionfactory.jagged.RecipientStanzaReader;
import com.exceptionfactory.jagged.bech32.Bech32;
import com.exceptionfactory.jagged.bech32.Bech32Address;
import com.exceptionfactory.jagged.framework.crypto.FileKeyDecryptor;
import com.exceptionfactory.jagged.framework.crypto.FileKeyDecryptorFactory;
import com.exceptionfactory.jagged.framework.crypto.SharedSecretKey;
import com.exceptionfactory.jagged.x25519.BasePointPublicKey;
import com.exceptionfactory.jagged.x25519.IdentityIndicator;
import com.exceptionfactory.jagged.x25519.KeyAgreementFactory;
import com.exceptionfactory.jagged.x25519.KeyPairGeneratorFactory;
import com.exceptionfactory.jagged.x25519.RecipientKeyFactory;
import com.exceptionfactory.jagged.x25519.SharedSecretKeyProducer;
import com.exceptionfactory.jagged.x25519.SharedWrapKeyProducer;
import com.exceptionfactory.jagged.x25519.StandardRecipientKeyFactory;
import com.exceptionfactory.jagged.x25519.X25519RecipientStanzaReader;
import com.exceptionfactory.jagged.x25519.X25519SharedSecretKeyProducer;
import com.exceptionfactory.jagged.x25519.X25519SharedWrapKeyProducer;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.util.Objects;

public final class X25519RecipientStanzaReaderFactory {
    private static final BasePointPublicKey BASE_POINT_PUBLIC_KEY = new BasePointPublicKey();

    private X25519RecipientStanzaReaderFactory() {
    }

    public static RecipientStanzaReader newRecipientStanzaReader(CharSequence encodedPrivateKey) throws GeneralSecurityException {
        FileKeyDecryptorFactory fileKeyDecryptorFactory = new FileKeyDecryptorFactory();
        KeyAgreementFactory keyAgreementFactory = new KeyAgreementFactory();
        KeyPairGeneratorFactory keyPairGeneratorFactory = new KeyPairGeneratorFactory();
        return X25519RecipientStanzaReaderFactory.newRecipientStanzaReader(encodedPrivateKey, fileKeyDecryptorFactory, keyAgreementFactory, keyPairGeneratorFactory);
    }

    public static RecipientStanzaReader newRecipientStanzaReader(CharSequence encodedPrivateKey, Provider provider) throws GeneralSecurityException {
        FileKeyDecryptorFactory fileKeyDecryptorFactory = new FileKeyDecryptorFactory(provider);
        KeyAgreementFactory keyAgreementFactory = new KeyAgreementFactory(provider);
        KeyPairGeneratorFactory keyPairGeneratorFactory = new KeyPairGeneratorFactory(provider);
        return X25519RecipientStanzaReaderFactory.newRecipientStanzaReader(encodedPrivateKey, fileKeyDecryptorFactory, keyAgreementFactory, keyPairGeneratorFactory);
    }

    private static RecipientStanzaReader newRecipientStanzaReader(CharSequence encodedPrivateKey, FileKeyDecryptorFactory fileKeyDecryptorFactory, KeyAgreementFactory keyAgreementFactory, KeyPairGeneratorFactory keyPairGeneratorFactory) throws GeneralSecurityException {
        FileKeyDecryptor fileKeyDecryptor = fileKeyDecryptorFactory.newFileKeyDecryptor();
        StandardRecipientKeyFactory recipientKeyFactory = new StandardRecipientKeyFactory(keyPairGeneratorFactory);
        PrivateKey privateKey = X25519RecipientStanzaReaderFactory.getPrivateKey(encodedPrivateKey, recipientKeyFactory);
        X25519SharedSecretKeyProducer sharedSecretKeyProducer = new X25519SharedSecretKeyProducer(privateKey, keyAgreementFactory);
        return X25519RecipientStanzaReaderFactory.newRecipientStanzaReader(sharedSecretKeyProducer, recipientKeyFactory, fileKeyDecryptor);
    }

    private static PrivateKey getPrivateKey(CharSequence encodedPrivateKey, RecipientKeyFactory recipientKeyFactory) throws GeneralSecurityException {
        Objects.requireNonNull(encodedPrivateKey, "Encoded Private Key required");
        Bech32.Decoder decoder = Bech32.getDecoder();
        Bech32Address address = decoder.decode(encodedPrivateKey);
        CharSequence humanReadablePart = address.getHumanReadablePart();
        if (IdentityIndicator.PRIVATE_KEY_HUMAN_READABLE_PART.getIndicator().contentEquals(humanReadablePart)) {
            byte[] privateKeyEncoded = address.getData();
            return recipientKeyFactory.getPrivateKey(privateKeyEncoded);
        }
        String message = String.format("Private Key Human-Readable Part not matched [%s]", humanReadablePart);
        throw new InvalidKeyException(message);
    }

    private static RecipientStanzaReader newRecipientStanzaReader(SharedSecretKeyProducer sharedSecretKeyProducer, RecipientKeyFactory recipientKeyFactory, FileKeyDecryptor fileKeyDecryptor) throws GeneralSecurityException {
        SharedWrapKeyProducer sharedWrapKeyProducer = X25519RecipientStanzaReaderFactory.getWrapKeyProducer(sharedSecretKeyProducer, recipientKeyFactory);
        return new X25519RecipientStanzaReader(recipientKeyFactory, sharedSecretKeyProducer, sharedWrapKeyProducer, fileKeyDecryptor);
    }

    private static SharedWrapKeyProducer getWrapKeyProducer(SharedSecretKeyProducer sharedSecretKeyProducer, RecipientKeyFactory recipientKeyFactory) throws GeneralSecurityException {
        PublicKey basePointPublicKey = recipientKeyFactory.getPublicKey(BASE_POINT_PUBLIC_KEY.getEncoded());
        SharedSecretKey basePointSharedSecretKey = sharedSecretKeyProducer.getSharedSecretKey(basePointPublicKey);
        byte[] basePointSharedSecretKeyEncoded = basePointSharedSecretKey.getEncoded();
        PublicKey recipientPublicKey = recipientKeyFactory.getPublicKey(basePointSharedSecretKeyEncoded);
        return new X25519SharedWrapKeyProducer(recipientPublicKey);
    }
}

