/*
 * Decompiled with CFR 0.152.
 */
package com.exceptionfactory.jagged.x25519;

import com.exceptionfactory.jagged.RecipientStanza;
import com.exceptionfactory.jagged.x25519.RecipientIndicator;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

class X25519RecipientStanza
implements RecipientStanza {
    private final List<String> arguments;
    private final byte[] body;

    X25519RecipientStanza(String ephemeralShare, byte[] body) {
        this.arguments = Collections.singletonList(Objects.requireNonNull(ephemeralShare, "Ephemeral Share required"));
        this.body = Objects.requireNonNull(body, "Stanza Body required");
    }

    public String getType() {
        return RecipientIndicator.STANZA_TYPE.getIndicator();
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public byte[] getBody() {
        return (byte[])this.body.clone();
    }
}

