/*
 * Decompiled with CFR 0.152.
 */
package com.exceptionfactory.jagged.x25519;

import com.exceptionfactory.jagged.x25519.KeyPairGeneratorFactory;
import com.exceptionfactory.jagged.x25519.RecipientIndicator;
import com.exceptionfactory.jagged.x25519.RecipientKeyFactory;
import com.exceptionfactory.jagged.x25519.RecipientKeyType;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Objects;

final class StandardRecipientKeyFactory
implements RecipientKeyFactory {
    private static final int COORDINATE_LENGTH = RecipientKeyType.X25519.getKeyLength();
    private static final int PRIVATE_KEY_SPECIFICATION_ENCODED_LENGTH = 48;
    private static final int PRIVATE_KEY_DER_ENCODED_LENGTH = 46;
    private static final int PRIVATE_KEY_DER_ENCODED_LENGTH_INDEX = 1;
    private static final int PRIVATE_KEY_DER_HEADER_LENGTH = 16;
    private final KeyFactory keyFactory;
    private final int publicKeyEncodedLength;
    private final byte[] publicKeyHeader;
    private final byte[] privateKeyHeader;

    StandardRecipientKeyFactory(KeyPairGeneratorFactory keyPairGeneratorFactory) throws GeneralSecurityException {
        KeyPairGenerator keyPairGenerator = keyPairGeneratorFactory.getKeyPairGenerator();
        Provider provider = keyPairGenerator.getProvider();
        this.keyFactory = KeyFactory.getInstance(RecipientIndicator.KEY_ALGORITHM.getIndicator(), provider);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        PrivateKey privateKey = keyPair.getPrivate();
        this.privateKeyHeader = StandardRecipientKeyFactory.getPrivateKeyHeader(privateKey);
        PublicKey publicKey = keyPair.getPublic();
        byte[] publicKeyEncoded = publicKey.getEncoded();
        this.publicKeyEncodedLength = publicKeyEncoded.length;
        int publicKeyHeaderLength = this.publicKeyEncodedLength - COORDINATE_LENGTH;
        this.publicKeyHeader = Arrays.copyOfRange(publicKeyEncoded, 0, publicKeyHeaderLength);
    }

    @Override
    public PublicKey getPublicKey(byte[] publicKeyEncoded) throws GeneralSecurityException {
        Objects.requireNonNull(publicKeyEncoded, "Public Key required");
        int encodedLength = publicKeyEncoded.length;
        if (COORDINATE_LENGTH == encodedLength) {
            X509EncodedKeySpec publicKeySpec = this.getPublicKeySpec(publicKeyEncoded);
            return this.keyFactory.generatePublic(publicKeySpec);
        }
        String message = String.format("Public key length [%d] not required length [%d]", encodedLength, COORDINATE_LENGTH);
        throw new InvalidKeyException(message);
    }

    @Override
    public PrivateKey getPrivateKey(byte[] privateKeyEncoded) throws GeneralSecurityException {
        Objects.requireNonNull(privateKeyEncoded, "Private Key required");
        int encodedLength = privateKeyEncoded.length;
        if (COORDINATE_LENGTH == encodedLength) {
            PKCS8EncodedKeySpec privateKeySpec = this.getPrivateKeySpec(privateKeyEncoded);
            return this.keyFactory.generatePrivate(privateKeySpec);
        }
        String message = String.format("Private key length [%d] not required length [%d]", encodedLength, COORDINATE_LENGTH);
        throw new InvalidKeyException(message);
    }

    private PKCS8EncodedKeySpec getPrivateKeySpec(byte[] privateKeyEncoded) {
        byte[] keySpec = new byte[48];
        System.arraycopy(this.privateKeyHeader, 0, keySpec, 0, this.privateKeyHeader.length);
        System.arraycopy(privateKeyEncoded, 0, keySpec, this.privateKeyHeader.length, privateKeyEncoded.length);
        return new PKCS8EncodedKeySpec(keySpec);
    }

    private X509EncodedKeySpec getPublicKeySpec(byte[] publicKeyEncoded) {
        byte[] keySpec = new byte[this.publicKeyEncodedLength];
        System.arraycopy(this.publicKeyHeader, 0, keySpec, 0, this.publicKeyHeader.length);
        System.arraycopy(publicKeyEncoded, 0, keySpec, this.publicKeyHeader.length, publicKeyEncoded.length);
        return new X509EncodedKeySpec(keySpec);
    }

    private static byte[] getPrivateKeyHeader(PrivateKey privateKey) {
        byte[] privateKeyEncoded = privateKey.getEncoded();
        byte[] privateKeyHeader = Arrays.copyOfRange(privateKeyEncoded, 0, 16);
        privateKeyHeader[1] = 46;
        return privateKeyHeader;
    }
}

