/*
 * Decompiled with CFR 0.152.
 */
package com.exceptionfactory.jagged.bech32;

import com.exceptionfactory.jagged.bech32.Bech32;
import com.exceptionfactory.jagged.bech32.Bech32Address;
import com.exceptionfactory.jagged.bech32.SharedCoder;
import com.exceptionfactory.jagged.bech32.StandardBech32Address;
import java.nio.ByteBuffer;
import java.util.Arrays;

class StandardDecoder
extends SharedCoder
implements Bech32.Decoder {
    private static final int PART_SEPARATOR_OFFSET = 1;
    private static final int CHARACTER_INDEX_NOT_FOUND = -1;

    StandardDecoder() {
    }

    @Override
    public Bech32Address decode(CharSequence encoded) {
        byte[] checksumDecoded;
        byte[] dataChecksumDecoded;
        byte[] dataDecoded;
        CharSequence normalized = this.getNormalized(encoded);
        int partSeparatorIndex = this.getPartSeparatorIndex(normalized);
        CharSequence humanReadablePart = this.getHumanReadablePart(encoded, partSeparatorIndex);
        if (this.isChecksumVerified(humanReadablePart, dataDecoded = this.getDataDecoded(dataChecksumDecoded = this.getDecoded(normalized, partSeparatorIndex)), checksumDecoded = this.getChecksumDecoded(dataChecksumDecoded))) {
            byte[] data = this.getDataConverted(dataDecoded, SharedCoder.ConversionMode.DECODING);
            return new StandardBech32Address(humanReadablePart, data);
        }
        throw new IllegalArgumentException("Bech32 checksum not verified");
    }

    private CharSequence getNormalized(CharSequence encoded) {
        CharSequence normalized;
        if (encoded == null) {
            throw new IllegalArgumentException("Encoded Bech32 string required");
        }
        if (this.isLowerCase(encoded)) {
            normalized = encoded;
        } else if (this.isUpperCase(encoded)) {
            normalized = this.getLowerCase(encoded);
        } else {
            throw new IllegalArgumentException("Encoded Bech32 string must be lowercase or uppercase not mixed");
        }
        return normalized;
    }

    private CharSequence getLowerCase(CharSequence characters) {
        return characters.codePoints().map(Character::toLowerCase).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append);
    }

    private CharSequence getHumanReadablePart(CharSequence encoded, int partSeparatorIndex) {
        CharSequence humanReadablePart = encoded.subSequence(0, partSeparatorIndex);
        return this.getHumanReadablePartValidated(humanReadablePart);
    }

    private byte[] getDecoded(CharSequence normalized, int partSeparatorIndex) {
        int dataPartStartIndex = partSeparatorIndex + 1;
        CharSequence dataEncoded = normalized.subSequence(dataPartStartIndex, normalized.length());
        return this.getDecoded(dataEncoded);
    }

    private byte[] getChecksumDecoded(byte[] dataChecksumDecoded) {
        int checksumStartIndex = dataChecksumDecoded.length - 6;
        return Arrays.copyOfRange(dataChecksumDecoded, checksumStartIndex, dataChecksumDecoded.length);
    }

    private byte[] getDataDecoded(byte[] dataChecksumDecoded) {
        int dataEndIndex = dataChecksumDecoded.length - 6;
        return Arrays.copyOfRange(dataChecksumDecoded, 0, dataEndIndex);
    }

    private byte[] getDecoded(CharSequence charactersEncoded) {
        int[] characters = charactersEncoded.codePoints().toArray();
        ByteBuffer decoded = ByteBuffer.allocate(characters.length);
        for (int characterEncoded : characters) {
            int characterDecoded = "qpzry9x8gf2tvdw0s3jn54khce6mua7l".indexOf(characterEncoded);
            if (characterDecoded == -1) {
                String message = String.format("Bech32 Data character [%d] not valid", characterEncoded);
                throw new IllegalArgumentException(message);
            }
            decoded.put((byte)characterDecoded);
        }
        byte[] charactersDecoded = new byte[decoded.position()];
        decoded.flip();
        decoded.get(charactersDecoded);
        return charactersDecoded;
    }

    private int getPartSeparatorIndex(CharSequence encoded) {
        int endIndex;
        int checksumStartIndex = encoded.length() - 6;
        for (int index = endIndex = encoded.length() - 1; index > 0; --index) {
            char character = encoded.charAt(index);
            if (character != '1') continue;
            if (index >= checksumStartIndex) {
                String message = String.format("Bech32 Part Separator [1] position [%d] found in checksum", index);
                throw new IllegalArgumentException(message);
            }
            return index;
        }
        throw new IllegalArgumentException("Bech32 Part Separator [1] not found");
    }

    private boolean isChecksumVerified(CharSequence humanReadablePart, byte[] dataDecoded, byte[] checksumDecoded) {
        byte[] humanReadablePartExpanded = this.getHumanReadablePartExpanded(humanReadablePart);
        int polynomialModulus = this.getPolynomialModulus(humanReadablePartExpanded, dataDecoded, checksumDecoded);
        return 1 == polynomialModulus;
    }
}

