/*
 * Decompiled with CFR 0.152.
 */
package com.exceptionfactory.jagged.bech32;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.OptionalInt;

class SharedCoder {
    protected static final String BEC32_CHARACTER_SET = "qpzry9x8gf2tvdw0s3jn54khce6mua7l";
    protected static final char PART_SEPARATOR = '1';
    protected static final int[] GENERATOR = new int[]{996825010, 642813549, 513874426, 1027748829, 705979059};
    protected static final int CHECKSUM_LENGTH = 6;
    protected static final int BECH32_ENCODING_CONSTANT = 1;
    protected static final byte EXPANDED_LOW_BIT_SHIFT = 31;
    protected static final byte EXPANDED_HIGH_BIT_SHIFT = 5;
    private static final int EXPANDED_LENGTH_MULTIPLIER = 2;
    private static final int EXPANDED_SEPARATOR_LENGTH = 1;
    private static final byte EXPANDED_SEPARATOR = 0;
    private static final int INITIAL_COEFFICIENT_BITS = 25;
    private static final int REMAINING_COEFFICIENT_BITS = 0x1FFFFFF;
    private static final int UNSIGNED_INTEGER_BITS = 255;
    private static final byte MINIMUM_HUMAN_READABLE_PART_ASCII_CODE = 33;
    private static final byte MAXIMUM_HUMAN_READABLE_PART_ASCII_CODE = 126;
    private static final int MAXIMUM_HUMAN_READABLE_PART_LENGTH = 83;
    private static final int MAXIMUM_DATA_LENGTH = 256;

    SharedCoder() {
    }

    protected CharSequence getHumanReadablePartValidated(CharSequence humanReadablePart) {
        Objects.requireNonNull(humanReadablePart, "Human-Readable Part required");
        int humanReadablePartLength = humanReadablePart.length();
        if (humanReadablePartLength > 83) {
            String message = String.format("Human-Readable Part length [%d] greater than maximum [%d]", humanReadablePartLength, 83);
            throw new IllegalArgumentException(message);
        }
        OptionalInt invalidCharacterCodeFound = humanReadablePart.codePoints().filter(this::isHumanReadablePartCharacterInvalid).findFirst();
        if (invalidCharacterCodeFound.isPresent()) {
            int characterCode = invalidCharacterCodeFound.getAsInt();
            String message = String.format("Human-Readable Part contains invalid character code [%d]", characterCode);
            throw new IllegalArgumentException(message);
        }
        return humanReadablePart;
    }

    protected byte[] getHumanReadablePartExpanded(CharSequence humanReadablePart) {
        int expandedLength = humanReadablePart.length() * 2 + 1;
        ByteBuffer expanded = ByteBuffer.allocate(expandedLength);
        humanReadablePart.codePoints().map(Character::toLowerCase).map(character -> character >> 5).forEach(characterHighBits -> expanded.put((byte)characterHighBits));
        expanded.put((byte)0);
        humanReadablePart.codePoints().map(Character::toLowerCase).map(character -> character & 0x1F).forEach(characterLowBits -> expanded.put((byte)characterLowBits));
        return expanded.array();
    }

    protected byte[] getDataConverted(byte[] data, ConversionMode conversionMode) {
        ByteBuffer convertedBuffer = ByteBuffer.allocate(256);
        int accumulator = 0;
        byte bits = 0;
        for (byte octet : data) {
            int octetUnsignedInteger = this.getUnsignedInteger(octet);
            accumulator = accumulator << conversionMode.inputBits | octetUnsignedInteger;
            bits = (byte)(bits + conversionMode.inputBits);
            while (bits >= conversionMode.outputBits) {
                bits = (byte)(bits - conversionMode.outputBits);
                int characterConverted = accumulator >> bits & conversionMode.maximumOutputBits;
                convertedBuffer.put((byte)characterConverted);
            }
        }
        if (ConversionMode.ENCODING == conversionMode && bits > 0) {
            int remainingBits = conversionMode.outputBits - bits;
            int paddingCharacterConverted = accumulator << remainingBits & conversionMode.maximumOutputBits;
            convertedBuffer.put((byte)paddingCharacterConverted);
        }
        byte[] converted = new byte[convertedBuffer.position()];
        convertedBuffer.flip();
        convertedBuffer.get(converted);
        return converted;
    }

    protected boolean isLowerCase(CharSequence characters) {
        return characters.codePoints().noneMatch(Character::isUpperCase);
    }

    protected boolean isUpperCase(CharSequence characters) {
        return characters.codePoints().noneMatch(Character::isLowerCase);
    }

    protected boolean hasUpperCaseCharacters(CharSequence characters) {
        return characters.codePoints().anyMatch(Character::isUpperCase);
    }

    protected int getPolynomialModulus(byte[] humanReadablePartExpanded, byte[] dataDecoded, byte[] checksumDecoded) {
        int humanReadablePartExpandedModulus = this.getPolynomialModulus(humanReadablePartExpanded, 1);
        int dataDecodedModulus = this.getPolynomialModulus(dataDecoded, humanReadablePartExpandedModulus);
        return this.getPolynomialModulus(checksumDecoded, dataDecodedModulus);
    }

    private int getPolynomialModulus(byte[] values, int initialCoefficient) {
        int packed = initialCoefficient;
        for (byte value : values) {
            int firstCoefficient = packed >> 25;
            packed = (packed & 0x1FFFFFF) << 5;
            packed ^= value;
            for (int i = 0; i < GENERATOR.length; ++i) {
                int firstCoefficientBit = firstCoefficient >> i & 1;
                if (firstCoefficientBit != 1) continue;
                int generator = GENERATOR[i];
                packed ^= generator;
            }
        }
        return packed;
    }

    private boolean isHumanReadablePartCharacterInvalid(int characterCode) {
        return characterCode < 33 || characterCode > 126;
    }

    private int getUnsignedInteger(byte octet) {
        return octet & 0xFF;
    }

    protected static enum ConversionMode {
        DECODING(5, 8, 255),
        ENCODING(8, 5, 31);

        private final byte inputBits;
        private final byte outputBits;
        private final int maximumOutputBits;

        private ConversionMode(int inputBits, int outputBits, int maximumOutputBits) {
            this.inputBits = (byte)inputBits;
            this.outputBits = (byte)outputBits;
            this.maximumOutputBits = maximumOutputBits;
        }
    }
}

