/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamBase;
import com.esri.core.geometry.AttributeStreamOfInt32;
import com.esri.core.geometry.BucketSort;
import com.esri.core.geometry.ClassicSort;
import com.esri.core.geometry.Envelope1D;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.IndexMultiDCList;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.StridedIndexTypeCollection;
import com.esri.core.geometry.Treap;
import java.util.ArrayList;

final class IntervalTreeImpl {
    private boolean m_b_offline_dynamic;
    private ArrayList<Envelope1D> m_intervals;
    private StridedIndexTypeCollection m_primary_nodes;
    private StridedIndexTypeCollection m_interval_nodes;
    private AttributeStreamOfInt32 m_interval_handles;
    private IndexMultiDCList m_secondary_lists;
    private Treap m_secondary_treaps;
    private AttributeStreamOfInt32 m_end_indices_unique;
    private int m_c_count;
    private int m_root;
    private boolean m_b_sort_intervals;
    private boolean m_b_constructing;
    private boolean m_b_construction_ended;
    private BucketSort m_bucket_sort;

    IntervalTreeImpl(boolean b_offline_dynamic) {
        this.m_b_offline_dynamic = b_offline_dynamic;
        this.m_b_constructing = false;
        this.m_b_construction_ended = false;
    }

    void startConstruction() {
        this.reset_(true);
    }

    void addInterval(Envelope1D interval) {
        if (!this.m_b_constructing) {
            throw new GeometryException("invalid call");
        }
        this.m_intervals.add(interval);
    }

    void addInterval(double min, double max) {
        if (!this.m_b_constructing) {
            throw new GeometryException("invald call");
        }
        this.m_intervals.add(new Envelope1D(min, max));
    }

    void endConstruction() {
        if (!this.m_b_constructing) {
            throw new GeometryException("invalid call");
        }
        this.m_b_constructing = false;
        this.m_b_construction_ended = true;
        if (!this.m_b_offline_dynamic) {
            this.insertIntervalsStatic_();
            this.m_c_count = this.m_intervals.size();
        }
    }

    void insert(int index) {
        if (!this.m_b_offline_dynamic || !this.m_b_construction_ended) {
            throw new IllegalArgumentException("invalid call");
        }
        if (this.m_root == -1) {
            int size = this.m_intervals.size();
            if (this.m_b_sort_intervals) {
                AttributeStreamOfInt32 end_point_indices_sorted = new AttributeStreamOfInt32(0);
                end_point_indices_sorted.reserve(2 * size);
                this.querySortedEndPointIndices_(end_point_indices_sorted);
                this.m_end_indices_unique.reserve(2 * size);
                this.m_end_indices_unique.resize(0);
                this.querySortedDuplicatesRemoved_(end_point_indices_sorted);
                this.m_interval_handles.resize(size, -1.0);
                this.m_interval_handles.setRange(-1.0, 0, size);
                this.m_b_sort_intervals = false;
            } else {
                this.m_interval_handles.setRange(-1.0, 0, size);
            }
            this.m_root = this.createPrimaryNode_();
        }
        int interval_handle = this.insertIntervalEnd_(index << 1, this.m_root);
        int secondary_handle = this.getSecondaryFromInterval_(interval_handle);
        int right_end_handle = this.m_secondary_treaps.addElement((index << 1) + 1, secondary_handle);
        this.setRightEnd_(interval_handle, right_end_handle);
        this.m_interval_handles.set(index, interval_handle);
        ++this.m_c_count;
    }

    void remove(int index) {
        if (!this.m_b_offline_dynamic || !this.m_b_construction_ended) {
            throw new GeometryException("invalid call");
        }
        int interval_handle = this.m_interval_handles.get(index);
        if (interval_handle == -1) {
            throw new IllegalArgumentException("the interval does not exist in the interval tree");
        }
        this.m_interval_handles.set(index, -1);
        assert (this.getSecondaryFromInterval_(interval_handle) != -1);
        assert (this.getLeftEnd_(interval_handle) != -1);
        assert (this.getRightEnd_(interval_handle) != -1);
        --this.m_c_count;
        int secondary_handle = this.getSecondaryFromInterval_(interval_handle);
        int primary_handle = this.m_secondary_treaps.getTreapData(secondary_handle);
        this.m_secondary_treaps.deleteNode(this.getLeftEnd_(interval_handle), secondary_handle);
        this.m_secondary_treaps.deleteNode(this.getRightEnd_(interval_handle), secondary_handle);
        int size = this.m_secondary_treaps.size(secondary_handle);
        if (size == 0) {
            this.m_secondary_treaps.deleteTreap(secondary_handle);
            this.setSecondaryToPrimary_(primary_handle, -1);
        }
        this.m_interval_nodes.deleteElement(interval_handle);
        int tertiary_handle = this.getPPTR_(primary_handle);
        int lptr = this.getLPTR_(primary_handle);
        int rptr = this.getRPTR_(primary_handle);
        int iterations = 0;
        while (size <= 0 && primary_handle != this.m_root && (lptr == -1 || rptr == -1)) {
            assert (size == 0);
            assert (lptr == -1 || rptr == -1);
            assert (primary_handle != 0);
            if (primary_handle == this.getLPTR_(tertiary_handle)) {
                if (lptr != -1) {
                    this.setLPTR_(tertiary_handle, lptr);
                    this.setPPTR_(lptr, tertiary_handle);
                    this.setLPTR_(primary_handle, -1);
                    this.setPPTR_(primary_handle, -1);
                } else if (rptr != -1) {
                    this.setLPTR_(tertiary_handle, rptr);
                    this.setPPTR_(rptr, tertiary_handle);
                    this.setRPTR_(primary_handle, -1);
                    this.setPPTR_(primary_handle, -1);
                } else {
                    this.setLPTR_(tertiary_handle, -1);
                    this.setPPTR_(primary_handle, -1);
                }
            } else if (lptr != -1) {
                this.setRPTR_(tertiary_handle, lptr);
                this.setPPTR_(lptr, tertiary_handle);
                this.setLPTR_(primary_handle, -1);
                this.setPPTR_(primary_handle, -1);
            } else if (rptr != -1) {
                this.setRPTR_(tertiary_handle, rptr);
                this.setPPTR_(rptr, tertiary_handle);
                this.setRPTR_(primary_handle, -1);
                this.setPPTR_(primary_handle, -1);
            } else {
                this.setRPTR_(tertiary_handle, -1);
                this.setPPTR_(primary_handle, -1);
            }
            ++iterations;
            primary_handle = tertiary_handle;
            secondary_handle = this.getSecondaryFromPrimary(primary_handle);
            size = secondary_handle != -1 ? this.m_secondary_treaps.size(secondary_handle) : 0;
            lptr = this.getLPTR_(primary_handle);
            rptr = this.getRPTR_(primary_handle);
            tertiary_handle = this.getPPTR_(primary_handle);
        }
        assert (iterations <= 2);
    }

    void reset() {
        if (!this.m_b_offline_dynamic || !this.m_b_construction_ended) {
            throw new IllegalArgumentException("invalid call");
        }
        this.reset_(false);
    }

    int size() {
        return this.m_c_count;
    }

    IntervalTreeIteratorImpl getIterator(Envelope1D query, double tolerance) {
        return new IntervalTreeIteratorImpl(this, query, tolerance);
    }

    IntervalTreeIteratorImpl getIterator(double query, double tolerance) {
        return new IntervalTreeIteratorImpl(this, query, tolerance);
    }

    IntervalTreeIteratorImpl getIterator() {
        return new IntervalTreeIteratorImpl(this);
    }

    private void querySortedEndPointIndices_(AttributeStreamOfInt32 end_indices) {
        int size = this.m_intervals.size();
        for (int i = 0; i < 2 * size; ++i) {
            end_indices.add(i);
        }
        this.sortEndIndices_(end_indices, 0, 2 * size);
    }

    private void querySortedDuplicatesRemoved_(AttributeStreamOfInt32 end_indices_sorted) {
        double prev = Double.NaN;
        for (int i = 0; i < end_indices_sorted.size(); ++i) {
            int e = end_indices_sorted.get(i);
            double v = this.getValue_(e);
            if (v == prev) continue;
            this.m_end_indices_unique.add(e);
            prev = v;
        }
    }

    private void insertIntervalsStatic_() {
        int size = this.m_intervals.size();
        assert (this.m_b_sort_intervals);
        AttributeStreamOfInt32 end_indices_sorted = new AttributeStreamOfInt32(0);
        end_indices_sorted.reserve(2 * size);
        this.querySortedEndPointIndices_(end_indices_sorted);
        this.m_end_indices_unique.reserve(2 * size);
        this.m_end_indices_unique.resize(0);
        this.querySortedDuplicatesRemoved_(end_indices_sorted);
        assert (this.m_primary_nodes.size() == 0);
        this.m_interval_nodes.setCapacity(size);
        this.m_secondary_lists.reserveNodes(2 * size);
        AttributeStreamOfInt32 interval_handles = (AttributeStreamOfInt32)AttributeStreamBase.createIndexStream(size);
        interval_handles.setRange(-1.0, 0, size);
        this.m_root = this.createPrimaryNode_();
        for (int i = 0; i < end_indices_sorted.size(); ++i) {
            int e = end_indices_sorted.get(i);
            int interval_handle = interval_handles.get(e >> 1);
            if (interval_handle != -1) {
                assert (IntervalTreeImpl.isRight_(e));
                int secondary_handle = this.getSecondaryFromInterval_(interval_handle);
                this.setRightEnd_(interval_handle, this.m_secondary_lists.addElement(secondary_handle, e));
                continue;
            }
            assert (IntervalTreeImpl.isLeft_(e));
            interval_handle = this.insertIntervalEnd_(e, this.m_root);
            interval_handles.set(e >> 1, interval_handle);
        }
        assert (this.m_secondary_lists.getNodeCount() == 2 * size);
    }

    private int insertIntervalEnd_(int end_index, int root) {
        assert (IntervalTreeImpl.isLeft_(end_index));
        int primary_handle = root;
        int tertiary_handle = root;
        int ptr = root;
        int interval_handle = -1;
        int il = 0;
        int ir = this.m_end_indices_unique.size() - 1;
        int im = 0;
        int index = end_index >> 1;
        double discriminant_tertiary = Double.NaN;
        double discriminant_ptr = Double.NaN;
        boolean bSearching = true;
        double min = this.getMin_(index);
        double max = this.getMax_(index);
        while (bSearching) {
            if (il < ir) {
                im = il + (ir - il) / 2;
                if (this.getDiscriminantIndex1_(primary_handle) == -1) {
                    this.setDiscriminantIndices_(primary_handle, this.m_end_indices_unique.get(im), this.m_end_indices_unique.get(im + 1));
                }
            } else {
                assert (il == ir);
                assert (min == max);
                if (this.getDiscriminantIndex1_(primary_handle) == -1) {
                    this.setDiscriminantIndices_(primary_handle, this.m_end_indices_unique.get(il), this.m_end_indices_unique.get(il));
                }
            }
            double discriminant = this.getDiscriminant_(primary_handle);
            assert (!NumberUtils.isNaN(discriminant));
            if (max < discriminant) {
                int left_handle;
                if (ptr != -1) {
                    if (ptr == primary_handle) {
                        tertiary_handle = primary_handle;
                        discriminant_tertiary = discriminant;
                        ptr = this.getLPTR_(primary_handle);
                        discriminant_ptr = ptr != -1 ? this.getDiscriminant_(ptr) : Double.NaN;
                    } else if (discriminant_ptr > discriminant) {
                        if (discriminant < discriminant_tertiary) {
                            this.setLPTR_(tertiary_handle, primary_handle);
                        } else {
                            this.setRPTR_(tertiary_handle, primary_handle);
                        }
                        this.setRPTR_(primary_handle, ptr);
                        if (this.m_b_offline_dynamic) {
                            this.setPPTR_(primary_handle, tertiary_handle);
                            this.setPPTR_(ptr, primary_handle);
                        }
                        tertiary_handle = primary_handle;
                        discriminant_tertiary = discriminant;
                        ptr = -1;
                        discriminant_ptr = Double.NaN;
                        assert (this.getLPTR_(primary_handle) == -1);
                        assert (this.getRightPrimary_(primary_handle) != -1);
                    }
                }
                if ((left_handle = this.getLeftPrimary_(primary_handle)) == -1) {
                    left_handle = this.createPrimaryNode_();
                    this.setLeftPrimary_(primary_handle, left_handle);
                }
                primary_handle = left_handle;
                ir = im;
                continue;
            }
            if (min > discriminant) {
                int right_handle;
                if (ptr != -1) {
                    if (ptr == primary_handle) {
                        tertiary_handle = primary_handle;
                        discriminant_tertiary = discriminant;
                        ptr = this.getRPTR_(primary_handle);
                        discriminant_ptr = ptr != -1 ? this.getDiscriminant_(ptr) : Double.NaN;
                    } else if (discriminant_ptr < discriminant) {
                        if (discriminant < discriminant_tertiary) {
                            this.setLPTR_(tertiary_handle, primary_handle);
                        } else {
                            this.setRPTR_(tertiary_handle, primary_handle);
                        }
                        this.setLPTR_(primary_handle, ptr);
                        if (this.m_b_offline_dynamic) {
                            this.setPPTR_(primary_handle, tertiary_handle);
                            this.setPPTR_(ptr, primary_handle);
                        }
                        tertiary_handle = primary_handle;
                        discriminant_tertiary = discriminant;
                        ptr = -1;
                        discriminant_ptr = Double.NaN;
                        assert (this.getRPTR_(primary_handle) == -1);
                        assert (this.getLeftPrimary_(primary_handle) != -1);
                    }
                }
                if ((right_handle = this.getRightPrimary_(primary_handle)) == -1) {
                    right_handle = this.createPrimaryNode_();
                    this.setRightPrimary_(primary_handle, right_handle);
                }
                primary_handle = right_handle;
                il = im + 1;
                continue;
            }
            int secondary_handle = this.getSecondaryFromPrimary(primary_handle);
            if (secondary_handle == -1) {
                secondary_handle = this.createSecondary_(primary_handle);
                this.setSecondaryToPrimary_(primary_handle, secondary_handle);
            }
            int left_end_handle = this.addEndIndex(secondary_handle, end_index);
            interval_handle = this.createIntervalNode_();
            this.setSecondaryToInterval_(interval_handle, secondary_handle);
            this.setLeftEnd_(interval_handle, left_end_handle);
            if (primary_handle != ptr) {
                assert (primary_handle != -1);
                assert (!(this.getLPTR_(primary_handle) != -1 || this.getRPTR_(primary_handle) != -1 || this.m_b_offline_dynamic && this.getPPTR_(primary_handle) != -1));
                if (discriminant < discriminant_tertiary) {
                    this.setLPTR_(tertiary_handle, primary_handle);
                } else {
                    this.setRPTR_(tertiary_handle, primary_handle);
                }
                if (this.m_b_offline_dynamic) {
                    this.setPPTR_(primary_handle, tertiary_handle);
                }
                if (ptr != -1) {
                    if (discriminant_ptr < discriminant) {
                        this.setLPTR_(primary_handle, ptr);
                    } else {
                        this.setRPTR_(primary_handle, ptr);
                    }
                    if (this.m_b_offline_dynamic) {
                        this.setPPTR_(ptr, primary_handle);
                    }
                }
            }
            bSearching = false;
        }
        return interval_handle;
    }

    private int createPrimaryNode_() {
        return this.m_primary_nodes.newElement();
    }

    private int createSecondary_(int primary_handle) {
        if (!this.m_b_offline_dynamic) {
            return this.m_secondary_lists.createList(primary_handle);
        }
        return this.m_secondary_treaps.createTreap(primary_handle);
    }

    private int createIntervalNode_() {
        return this.m_interval_nodes.newElement();
    }

    private void reset_(boolean b_new_intervals) {
        if (b_new_intervals) {
            this.m_b_sort_intervals = true;
            this.m_b_constructing = true;
            this.m_b_construction_ended = false;
            if (this.m_end_indices_unique == null) {
                this.m_end_indices_unique = (AttributeStreamOfInt32)AttributeStreamBase.createIndexStream(0);
            } else {
                this.m_end_indices_unique.resize(0);
            }
            if (this.m_intervals == null) {
                this.m_intervals = new ArrayList(0);
            } else {
                this.m_intervals.clear();
            }
        } else {
            assert (this.m_b_offline_dynamic && this.m_b_construction_ended);
            this.m_b_sort_intervals = false;
        }
        if (this.m_b_offline_dynamic) {
            if (this.m_interval_handles == null) {
                this.m_interval_handles = (AttributeStreamOfInt32)AttributeStreamBase.createIndexStream(0);
                this.m_secondary_treaps = new Treap();
                this.m_secondary_treaps.setComparator(new SecondaryComparator(this));
            } else {
                this.m_secondary_treaps.clear();
            }
        } else if (this.m_secondary_lists == null) {
            this.m_secondary_lists = new IndexMultiDCList();
        } else {
            this.m_secondary_lists.clear();
        }
        if (this.m_primary_nodes == null) {
            this.m_interval_nodes = new StridedIndexTypeCollection(3);
            this.m_primary_nodes = new StridedIndexTypeCollection(this.m_b_offline_dynamic ? 8 : 7);
        } else {
            this.m_interval_nodes.deleteAll(false);
            this.m_primary_nodes.deleteAll(false);
        }
        this.m_root = -1;
        this.m_c_count = 0;
    }

    private void setDiscriminantIndices_(int primary_handle, int e_1, int e_2) {
        this.setDiscriminantIndex1_(primary_handle, e_1);
        this.setDiscriminantIndex2_(primary_handle, e_2);
    }

    private double getDiscriminant_(int primary_handle) {
        double v_2;
        int e_1 = this.getDiscriminantIndex1_(primary_handle);
        if (e_1 == -1) {
            return Double.NaN;
        }
        int e_2 = this.getDiscriminantIndex2_(primary_handle);
        assert (e_2 != -1);
        double v_1 = this.getValue_(e_1);
        if (v_1 == (v_2 = this.getValue_(e_2))) {
            return v_1;
        }
        return 0.5 * (v_1 + v_2);
    }

    private boolean isActive_(int primary_handle) {
        int secondary_handle = this.getSecondaryFromPrimary(primary_handle);
        if (secondary_handle != -1) {
            return true;
        }
        int left_handle = this.getLeftPrimary_(primary_handle);
        if (left_handle == -1) {
            return false;
        }
        int right_handle = this.getRightPrimary_(primary_handle);
        return right_handle != -1;
    }

    private void setDiscriminantIndex1_(int primary_handle, int end_index) {
        this.m_primary_nodes.setField(primary_handle, 0, end_index);
    }

    private void setDiscriminantIndex2_(int primary_handle, int end_index) {
        this.m_primary_nodes.setField(primary_handle, 1, end_index);
    }

    private void setLeftPrimary_(int primary_handle, int left_handle) {
        this.m_primary_nodes.setField(primary_handle, 3, left_handle);
    }

    private void setRightPrimary_(int primary_handle, int right_handle) {
        this.m_primary_nodes.setField(primary_handle, 4, right_handle);
    }

    private void setSecondaryToPrimary_(int primary_handle, int secondary_handle) {
        this.m_primary_nodes.setField(primary_handle, 2, secondary_handle);
    }

    private void setLPTR_(int primary_handle, int lptr) {
        this.m_primary_nodes.setField(primary_handle, 5, lptr);
    }

    private void setRPTR_(int primary_handle, int rptr) {
        this.m_primary_nodes.setField(primary_handle, 6, rptr);
    }

    private void setPPTR_(int primary_handle, int pptr) {
        this.m_primary_nodes.setField(primary_handle, 7, pptr);
    }

    private void setSecondaryToInterval_(int interval_handle, int secondary_handle) {
        this.m_interval_nodes.setField(interval_handle, 0, secondary_handle);
    }

    private int addEndIndex(int secondary_handle, int end_index) {
        int end_index_handle = !this.m_b_offline_dynamic ? this.m_secondary_lists.addElement(secondary_handle, end_index) : this.m_secondary_treaps.addElement(end_index, secondary_handle);
        return end_index_handle;
    }

    private void setLeftEnd_(int interval_handle, int left_end_handle) {
        this.m_interval_nodes.setField(interval_handle, 1, left_end_handle);
    }

    private void setRightEnd_(int interval_handle, int right_end_handle) {
        this.m_interval_nodes.setField(interval_handle, 2, right_end_handle);
    }

    private int getFirst_(int secondary_handle) {
        if (!this.m_b_offline_dynamic) {
            return this.m_secondary_lists.getFirst(secondary_handle);
        }
        return this.m_secondary_treaps.getFirst(secondary_handle);
    }

    private int getLast_(int secondary_handle) {
        if (!this.m_b_offline_dynamic) {
            return this.m_secondary_lists.getLast(secondary_handle);
        }
        return this.m_secondary_treaps.getLast(secondary_handle);
    }

    private static boolean isLeft_(int end_index) {
        return (end_index & 1) == 0;
    }

    private static boolean isRight_(int end_index) {
        return (end_index & 1) == 1;
    }

    private int getDiscriminantIndex1_(int primary_handle) {
        return this.m_primary_nodes.getField(primary_handle, 0);
    }

    private int getDiscriminantIndex2_(int primary_handle) {
        return this.m_primary_nodes.getField(primary_handle, 1);
    }

    private int getSecondaryFromPrimary(int primary_handle) {
        return this.m_primary_nodes.getField(primary_handle, 2);
    }

    private int getLeftPrimary_(int primary_handle) {
        return this.m_primary_nodes.getField(primary_handle, 3);
    }

    private int getRightPrimary_(int primary_handle) {
        return this.m_primary_nodes.getField(primary_handle, 4);
    }

    private int getLPTR_(int primary_handle) {
        return this.m_primary_nodes.getField(primary_handle, 5);
    }

    private int getRPTR_(int primary_handle) {
        return this.m_primary_nodes.getField(primary_handle, 6);
    }

    private int getPPTR_(int primary_handle) {
        return this.m_primary_nodes.getField(primary_handle, 7);
    }

    private int getSecondaryFromInterval_(int interval_handle) {
        return this.m_interval_nodes.getField(interval_handle, 0);
    }

    private int getLeftEnd_(int interval_handle) {
        return this.m_interval_nodes.getField(interval_handle, 1);
    }

    private int getRightEnd_(int interval_handle) {
        return this.m_interval_nodes.getField(interval_handle, 2);
    }

    private double getMin_(int i) {
        Envelope1D interval = this.m_intervals.get(i);
        return interval.vmin;
    }

    private double getMax_(int i) {
        Envelope1D interval = this.m_intervals.get(i);
        return interval.vmax;
    }

    private void sortEndIndices_(AttributeStreamOfInt32 end_indices, int begin_, int end_) {
        if (this.m_bucket_sort == null) {
            this.m_bucket_sort = new BucketSort();
        }
        IntervalTreeBucketSortHelper sorter = new IntervalTreeBucketSortHelper(this);
        this.m_bucket_sort.sort(end_indices, begin_, end_, sorter);
    }

    private void sortEndIndicesHelper_(AttributeStreamOfInt32 end_indices, int begin_, int end_) {
        end_indices.Sort(begin_, end_, new EndPointsComparer(this));
    }

    private double getValue_(int e) {
        Envelope1D interval = this.m_intervals.get(e >> 1);
        double v = IntervalTreeImpl.isLeft_(e) ? interval.vmin : interval.vmax;
        return v;
    }

    private class IntervalTreeBucketSortHelper
    extends ClassicSort {
        private IntervalTreeImpl m_interval_tree;

        IntervalTreeBucketSortHelper(IntervalTreeImpl interval_tree) {
            this.m_interval_tree = interval_tree;
        }

        @Override
        public void userSort(int begin, int end, AttributeStreamOfInt32 indices) {
            this.m_interval_tree.sortEndIndicesHelper_(indices, begin, end);
        }

        @Override
        public double getValue(int e) {
            return this.m_interval_tree.getValue_(e);
        }
    }

    private static final class EndPointsComparer
    extends AttributeStreamOfInt32.IntComparator {
        private IntervalTreeImpl m_interval_tree;

        EndPointsComparer(IntervalTreeImpl interval_tree) {
            this.m_interval_tree = interval_tree;
        }

        @Override
        public int compare(int e_1, int e_2) {
            double v_2;
            double v_1 = this.m_interval_tree.getValue_(e_1);
            if (v_1 < (v_2 = this.m_interval_tree.getValue_(e_2)) || v_1 == v_2 && IntervalTreeImpl.isLeft_(e_1) && IntervalTreeImpl.isRight_(e_2)) {
                return -1;
            }
            return 1;
        }
    }

    private static final class SecondaryComparator
    extends Treap.Comparator {
        private IntervalTreeImpl m_interval_tree;

        SecondaryComparator(IntervalTreeImpl interval_tree) {
            this.m_interval_tree = interval_tree;
        }

        @Override
        public int compare(Treap treap, int e_1, int node) {
            double v_2;
            int e_2 = treap.getElement(node);
            double v_1 = this.m_interval_tree.getValue_(e_1);
            if (v_1 < (v_2 = this.m_interval_tree.getValue_(e_2))) {
                return -1;
            }
            if (v_1 == v_2) {
                if (IntervalTreeImpl.isLeft_(e_1) && IntervalTreeImpl.isRight_(e_2)) {
                    return -1;
                }
                if (IntervalTreeImpl.isLeft_(e_2) && IntervalTreeImpl.isRight_(e_1)) {
                    return 1;
                }
                return 0;
            }
            return 1;
        }
    }

    static final class IntervalTreeIteratorImpl {
        private IntervalTreeImpl m_interval_tree;
        private Envelope1D m_query = new Envelope1D();
        private int m_primary_handle;
        private int m_next_primary_handle;
        private int m_forked_handle;
        private int m_current_end_handle;
        private int m_next_end_handle;
        private AttributeStreamOfInt32 m_tertiary_stack = new AttributeStreamOfInt32(0);
        private int m_function_index;
        private int[] m_function_stack = new int[2];

        void resetIterator(Envelope1D query, double tolerance) {
            this.m_query.vmin = query.vmin - tolerance;
            this.m_query.vmax = query.vmax + tolerance;
            this.m_tertiary_stack.resize(0);
            this.m_function_index = 0;
            this.m_function_stack[0] = 0;
        }

        void resetIterator(double query_min, double query_max, double tolerance) {
            if (query_min > query_max) {
                throw new IllegalArgumentException();
            }
            this.m_query.vmin = query_min - tolerance;
            this.m_query.vmax = query_max + tolerance;
            this.m_tertiary_stack.resize(0);
            this.m_function_index = 0;
            this.m_function_stack[0] = 0;
        }

        void resetIterator(double query, double tolerance) {
            this.m_query.vmin = query - tolerance;
            this.m_query.vmax = query + tolerance;
            this.m_tertiary_stack.resize(0);
            this.m_function_index = 0;
            this.m_function_stack[0] = 0;
        }

        int next() {
            if (!this.m_interval_tree.m_b_construction_ended) {
                throw new GeometryException("invalid call");
            }
            if (this.m_function_index < 0) {
                return -1;
            }
            boolean b_searching = true;
            block10: while (b_searching) {
                switch (this.m_function_stack[this.m_function_index]) {
                    case 1: {
                        b_searching = this.pIn_();
                        continue block10;
                    }
                    case 2: {
                        b_searching = this.pL_();
                        continue block10;
                    }
                    case 3: {
                        b_searching = this.pR_();
                        continue block10;
                    }
                    case 4: {
                        b_searching = this.pT_();
                        continue block10;
                    }
                    case 5: {
                        b_searching = this.right_();
                        continue block10;
                    }
                    case 6: {
                        b_searching = this.left_();
                        continue block10;
                    }
                    case 7: {
                        b_searching = this.all_();
                        continue block10;
                    }
                    case 0: {
                        b_searching = this.initialize_();
                        continue block10;
                    }
                }
                throw GeometryException.GeometryInternalError();
            }
            if (this.m_current_end_handle != -1) {
                return this.getCurrentEndIndex_() >> 1;
            }
            return -1;
        }

        IntervalTreeIteratorImpl(IntervalTreeImpl interval_tree, Envelope1D query, double tolerance) {
            this.m_interval_tree = interval_tree;
            this.m_tertiary_stack.reserve(20);
            this.resetIterator(query, tolerance);
        }

        IntervalTreeIteratorImpl(IntervalTreeImpl interval_tree, double query, double tolerance) {
            this.m_interval_tree = interval_tree;
            this.m_tertiary_stack.reserve(20);
            this.resetIterator(query, tolerance);
        }

        IntervalTreeIteratorImpl(IntervalTreeImpl interval_tree) {
            this.m_interval_tree = interval_tree;
            this.m_tertiary_stack.reserve(20);
            this.m_function_index = -1;
        }

        private boolean initialize_() {
            this.m_primary_handle = -1;
            this.m_next_primary_handle = -1;
            this.m_forked_handle = -1;
            this.m_current_end_handle = -1;
            if (this.m_interval_tree.m_primary_nodes != null && this.m_interval_tree.m_primary_nodes.size() > 0) {
                this.m_function_stack[0] = 1;
                this.m_next_primary_handle = this.m_interval_tree.m_root;
                return true;
            }
            this.m_function_index = -1;
            return false;
        }

        private boolean pIn_() {
            this.m_primary_handle = this.m_next_primary_handle;
            if (this.m_primary_handle == -1) {
                this.m_function_index = -1;
                this.m_current_end_handle = -1;
                return false;
            }
            double discriminant = this.m_interval_tree.getDiscriminant_(this.m_primary_handle);
            if (this.m_query.vmax < discriminant) {
                int secondary_handle = this.m_interval_tree.getSecondaryFromPrimary(this.m_primary_handle);
                this.m_next_primary_handle = this.m_interval_tree.getLPTR_(this.m_primary_handle);
                if (secondary_handle != -1) {
                    this.m_next_end_handle = this.m_interval_tree.getFirst_(secondary_handle);
                    this.m_function_stack[++this.m_function_index] = 6;
                }
                return true;
            }
            if (discriminant < this.m_query.vmin) {
                int secondary_handle = this.m_interval_tree.getSecondaryFromPrimary(this.m_primary_handle);
                this.m_next_primary_handle = this.m_interval_tree.getRPTR_(this.m_primary_handle);
                if (secondary_handle != -1) {
                    this.m_next_end_handle = this.m_interval_tree.getLast_(secondary_handle);
                    this.m_function_stack[++this.m_function_index] = 5;
                }
                return true;
            }
            assert (this.m_query.contains(discriminant));
            this.m_function_stack[this.m_function_index] = 2;
            this.m_forked_handle = this.m_primary_handle;
            int secondary_handle = this.m_interval_tree.getSecondaryFromPrimary(this.m_primary_handle);
            this.m_next_primary_handle = this.m_interval_tree.getLPTR_(this.m_primary_handle);
            if (secondary_handle != -1) {
                this.m_next_end_handle = this.m_interval_tree.getFirst_(secondary_handle);
                this.m_function_stack[++this.m_function_index] = 7;
            }
            return true;
        }

        private boolean pL_() {
            int rptr;
            this.m_primary_handle = this.m_next_primary_handle;
            if (this.m_primary_handle == -1) {
                this.m_function_stack[this.m_function_index] = 3;
                this.m_next_primary_handle = this.m_interval_tree.getRPTR_(this.m_forked_handle);
                return true;
            }
            double discriminant = this.m_interval_tree.getDiscriminant_(this.m_primary_handle);
            if (discriminant < this.m_query.vmin) {
                int secondary_handle = this.m_interval_tree.getSecondaryFromPrimary(this.m_primary_handle);
                this.m_next_primary_handle = this.m_interval_tree.getRPTR_(this.m_primary_handle);
                if (secondary_handle != -1) {
                    this.m_next_end_handle = this.m_interval_tree.getLast_(secondary_handle);
                    this.m_function_stack[++this.m_function_index] = 5;
                }
                return true;
            }
            assert (this.m_query.contains(discriminant));
            int secondary_handle = this.m_interval_tree.getSecondaryFromPrimary(this.m_primary_handle);
            this.m_next_primary_handle = this.m_interval_tree.getLPTR_(this.m_primary_handle);
            if (secondary_handle != -1) {
                this.m_next_end_handle = this.m_interval_tree.getFirst_(secondary_handle);
                this.m_function_stack[++this.m_function_index] = 7;
            }
            if ((rptr = this.m_interval_tree.getRPTR_(this.m_primary_handle)) != -1) {
                this.m_tertiary_stack.add(rptr);
            }
            return true;
        }

        private boolean pR_() {
            int lptr;
            this.m_primary_handle = this.m_next_primary_handle;
            if (this.m_primary_handle == -1) {
                this.m_function_stack[this.m_function_index] = 4;
                return true;
            }
            double discriminant = this.m_interval_tree.getDiscriminant_(this.m_primary_handle);
            if (this.m_query.vmax < discriminant) {
                int secondary_handle = this.m_interval_tree.getSecondaryFromPrimary(this.m_primary_handle);
                this.m_next_primary_handle = this.m_interval_tree.getLPTR_(this.m_primary_handle);
                if (secondary_handle != -1) {
                    this.m_next_end_handle = this.m_interval_tree.getFirst_(secondary_handle);
                    this.m_function_stack[++this.m_function_index] = 6;
                }
                return true;
            }
            assert (this.m_query.contains(discriminant));
            int secondary_handle = this.m_interval_tree.getSecondaryFromPrimary(this.m_primary_handle);
            this.m_next_primary_handle = this.m_interval_tree.getRPTR_(this.m_primary_handle);
            if (secondary_handle != -1) {
                this.m_next_end_handle = this.m_interval_tree.getFirst_(secondary_handle);
                this.m_function_stack[++this.m_function_index] = 7;
            }
            if ((lptr = this.m_interval_tree.getLPTR_(this.m_primary_handle)) != -1) {
                this.m_tertiary_stack.add(lptr);
            }
            return true;
        }

        private boolean pT_() {
            if (this.m_tertiary_stack.size() == 0) {
                this.m_function_index = -1;
                this.m_current_end_handle = -1;
                return false;
            }
            this.m_primary_handle = this.m_tertiary_stack.get(this.m_tertiary_stack.size() - 1);
            this.m_tertiary_stack.resize(this.m_tertiary_stack.size() - 1);
            int secondary_handle = this.m_interval_tree.getSecondaryFromPrimary(this.m_primary_handle);
            if (secondary_handle != -1) {
                this.m_next_end_handle = this.m_interval_tree.getFirst_(secondary_handle);
                this.m_function_stack[++this.m_function_index] = 7;
            }
            if (this.m_interval_tree.getLPTR_(this.m_primary_handle) != -1) {
                this.m_tertiary_stack.add(this.m_interval_tree.getLPTR_(this.m_primary_handle));
            }
            if (this.m_interval_tree.getRPTR_(this.m_primary_handle) != -1) {
                this.m_tertiary_stack.add(this.m_interval_tree.getRPTR_(this.m_primary_handle));
            }
            return true;
        }

        private boolean left_() {
            this.m_current_end_handle = this.m_next_end_handle;
            if (this.m_current_end_handle != -1 && IntervalTreeImpl.isLeft_(this.getCurrentEndIndex_()) && this.m_interval_tree.getValue_(this.getCurrentEndIndex_()) <= this.m_query.vmax) {
                this.m_next_end_handle = this.getNext_();
                return false;
            }
            --this.m_function_index;
            return true;
        }

        private boolean right_() {
            this.m_current_end_handle = this.m_next_end_handle;
            if (this.m_current_end_handle != -1 && IntervalTreeImpl.isRight_(this.getCurrentEndIndex_()) && this.m_interval_tree.getValue_(this.getCurrentEndIndex_()) >= this.m_query.vmin) {
                this.m_next_end_handle = this.getPrev_();
                return false;
            }
            --this.m_function_index;
            return true;
        }

        private boolean all_() {
            this.m_current_end_handle = this.m_next_end_handle;
            if (this.m_current_end_handle != -1 && IntervalTreeImpl.isLeft_(this.getCurrentEndIndex_())) {
                this.m_next_end_handle = this.getNext_();
                return false;
            }
            --this.m_function_index;
            return true;
        }

        private int getNext_() {
            if (!this.m_interval_tree.m_b_offline_dynamic) {
                return this.m_interval_tree.m_secondary_lists.getNext(this.m_current_end_handle);
            }
            return this.m_interval_tree.m_secondary_treaps.getNext(this.m_current_end_handle);
        }

        private int getPrev_() {
            if (!this.m_interval_tree.m_b_offline_dynamic) {
                return this.m_interval_tree.m_secondary_lists.getPrev(this.m_current_end_handle);
            }
            return this.m_interval_tree.m_secondary_treaps.getPrev(this.m_current_end_handle);
        }

        private int getCurrentEndIndex_() {
            if (!this.m_interval_tree.m_b_offline_dynamic) {
                return this.m_interval_tree.m_secondary_lists.getData(this.m_current_end_handle);
            }
            return this.m_interval_tree.m_secondary_treaps.getElement(this.m_current_end_handle);
        }

        private static interface State {
            public static final int initialize = 0;
            public static final int pIn = 1;
            public static final int pL = 2;
            public static final int pR = 3;
            public static final int pT = 4;
            public static final int right = 5;
            public static final int left = 6;
            public static final int all = 7;
        }
    }
}

