/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.hash;

import com.diffplug.common.annotations.Beta;
import com.diffplug.common.base.Preconditions;
import com.diffplug.common.hash.HashCode;
import com.diffplug.common.hash.HashFunction;
import com.diffplug.common.hash.Hasher;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.CheckReturnValue;

@Beta
public final class HashingInputStream
extends FilterInputStream {
    private final Hasher hasher;

    public HashingInputStream(HashFunction hashFunction, InputStream in) {
        super((InputStream)Preconditions.checkNotNull((Object)in));
        this.hasher = (Hasher)Preconditions.checkNotNull((Object)hashFunction.newHasher());
    }

    @Override
    public int read() throws IOException {
        int b = this.in.read();
        if (b != -1) {
            this.hasher.putByte((byte)b);
        }
        return b;
    }

    @Override
    public int read(byte[] bytes, int off, int len) throws IOException {
        int numOfBytesRead = this.in.read(bytes, off, len);
        if (numOfBytesRead != -1) {
            this.hasher.putBytes(bytes, off, numOfBytesRead);
        }
        return numOfBytesRead;
    }

    @Override
    @CheckReturnValue
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("reset not supported");
    }

    @CheckReturnValue
    public HashCode hash() {
        return this.hasher.hash();
    }
}

