/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc42.internal.apache.arrow.vector.complex.impl;

import com.databricks.client.jdbc42.internal.apache.arrow.memory.ArrowBuf;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.FieldVector;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.NullVector;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.ValueVector;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.complex.AbstractStructVector;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.complex.FixedSizeListVector;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.complex.LargeListVector;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.complex.ListVector;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.complex.ListViewVector;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.complex.MapVector;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.complex.StructVector;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.complex.UnionVector;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.complex.impl.AbstractFieldWriter;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.complex.impl.AbstractPromotableFieldWriter;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.complex.impl.NullableStructWriterFactory;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.complex.impl.UnionListWriter;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.complex.impl.UnionMapWriter;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.complex.impl.UnionWriter;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.complex.writer.FieldWriter;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.holders.Decimal256Holder;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.holders.DecimalHolder;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.types.Types;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.types.pojo.ArrowType;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.types.pojo.Field;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.types.pojo.FieldType;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.util.Text;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.util.TransferPair;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Locale;

public class PromotableWriter
extends AbstractPromotableFieldWriter {
    private final AbstractStructVector parentContainer;
    private final ListVector listVector;
    private final ListViewVector listViewVector;
    private final FixedSizeListVector fixedListVector;
    private final LargeListVector largeListVector;
    private final NullableStructWriterFactory nullableStructWriterFactory;
    private int position;
    private static final int MAX_DECIMAL_PRECISION = 38;
    private static final int MAX_DECIMAL256_PRECISION = 76;
    private Types.MinorType type;
    private ValueVector vector;
    private UnionVector unionVector;
    private State state;
    private FieldWriter writer;

    public PromotableWriter(ValueVector v, AbstractStructVector parentContainer) {
        this(v, parentContainer, NullableStructWriterFactory.getNullableStructWriterFactoryInstance());
    }

    public PromotableWriter(ValueVector v, AbstractStructVector parentContainer, NullableStructWriterFactory nullableStructWriterFactory) {
        this.parentContainer = parentContainer;
        this.listVector = null;
        this.listViewVector = null;
        this.fixedListVector = null;
        this.largeListVector = null;
        this.nullableStructWriterFactory = nullableStructWriterFactory;
        this.init(v);
    }

    public PromotableWriter(ValueVector v, ListVector listVector) {
        this(v, listVector, NullableStructWriterFactory.getNullableStructWriterFactoryInstance());
    }

    public PromotableWriter(ValueVector v, FixedSizeListVector fixedListVector) {
        this(v, fixedListVector, NullableStructWriterFactory.getNullableStructWriterFactoryInstance());
    }

    public PromotableWriter(ValueVector v, LargeListVector largeListVector) {
        this(v, largeListVector, NullableStructWriterFactory.getNullableStructWriterFactoryInstance());
    }

    public PromotableWriter(ValueVector v, ListVector listVector, NullableStructWriterFactory nullableStructWriterFactory) {
        this.listVector = listVector;
        this.listViewVector = null;
        this.parentContainer = null;
        this.fixedListVector = null;
        this.largeListVector = null;
        this.nullableStructWriterFactory = nullableStructWriterFactory;
        this.init(v);
    }

    public PromotableWriter(ValueVector v, ListViewVector listViewVector, NullableStructWriterFactory nullableStructWriterFactory) {
        this.listViewVector = listViewVector;
        this.listVector = null;
        this.parentContainer = null;
        this.fixedListVector = null;
        this.largeListVector = null;
        this.nullableStructWriterFactory = nullableStructWriterFactory;
        this.init(v);
    }

    public PromotableWriter(ValueVector v, FixedSizeListVector fixedListVector, NullableStructWriterFactory nullableStructWriterFactory) {
        this.fixedListVector = fixedListVector;
        this.parentContainer = null;
        this.listVector = null;
        this.listViewVector = null;
        this.largeListVector = null;
        this.nullableStructWriterFactory = nullableStructWriterFactory;
        this.init(v);
    }

    public PromotableWriter(ValueVector v, LargeListVector largeListVector, NullableStructWriterFactory nullableStructWriterFactory) {
        this.largeListVector = largeListVector;
        this.fixedListVector = null;
        this.parentContainer = null;
        this.listVector = null;
        this.listViewVector = null;
        this.nullableStructWriterFactory = nullableStructWriterFactory;
        this.init(v);
    }

    private void init(ValueVector v) {
        if (v instanceof UnionVector) {
            this.state = State.UNION;
            this.unionVector = (UnionVector)v;
            this.writer = new UnionWriter(this.unionVector, this.nullableStructWriterFactory);
        } else if (v instanceof NullVector) {
            this.state = State.UNTYPED;
        } else {
            this.setWriter(v);
        }
    }

    @Override
    public void setAddVectorAsNullable(boolean nullable) {
        super.setAddVectorAsNullable(nullable);
        if (this.writer instanceof AbstractFieldWriter) {
            ((AbstractFieldWriter)this.writer).setAddVectorAsNullable(nullable);
        }
    }

    private void setWriter(ValueVector v) {
        this.state = State.SINGLE;
        this.vector = v;
        this.type = v.getMinorType();
        switch (this.type) {
            case STRUCT: {
                this.writer = this.nullableStructWriterFactory.build((StructVector)this.vector);
                break;
            }
            case LIST: {
                this.writer = new UnionListWriter((ListVector)this.vector, this.nullableStructWriterFactory);
                break;
            }
            case MAP: {
                this.writer = new UnionMapWriter((MapVector)this.vector);
                break;
            }
            case UNION: {
                this.writer = new UnionWriter((UnionVector)this.vector, this.nullableStructWriterFactory);
                break;
            }
            default: {
                this.writer = this.type.getNewFieldWriter(this.vector);
            }
        }
    }

    @Override
    public void writeNull() {
        FieldWriter w = this.getWriter();
        if (w != null) {
            w.writeNull();
        }
        this.setPosition(this.idx() + 1);
    }

    @Override
    public void setPosition(int index) {
        super.setPosition(index);
        FieldWriter w = this.getWriter();
        if (w == null) {
            this.position = index;
        } else {
            w.setPosition(index);
        }
    }

    private boolean requiresArrowType(Types.MinorType type) {
        return type == Types.MinorType.DECIMAL || type == Types.MinorType.MAP || type == Types.MinorType.DURATION || type == Types.MinorType.FIXEDSIZEBINARY || type.name().startsWith("TIMESTAMP") && type.name().endsWith("TZ");
    }

    @Override
    protected FieldWriter getWriter(Types.MinorType type, ArrowType arrowType) {
        if (this.state == State.UNION) {
            if (this.requiresArrowType(type)) {
                ((UnionWriter)this.writer).getWriter(type, arrowType);
            } else {
                ((UnionWriter)this.writer).getWriter(type);
            }
        } else if (this.state == State.UNTYPED) {
            if (type == null) {
                return null;
            }
            if (arrowType == null) {
                arrowType = type.getType();
            }
            FieldType fieldType = new FieldType(this.addVectorAsNullable, arrowType, null, null);
            Object v = this.listVector != null ? this.listVector.addOrGetVector(fieldType).getVector() : (this.fixedListVector != null ? this.fixedListVector.addOrGetVector(fieldType).getVector() : (this.listViewVector != null ? this.listViewVector.addOrGetVector(fieldType).getVector() : this.largeListVector.addOrGetVector(fieldType).getVector()));
            v.allocateNew();
            this.setWriter((ValueVector)v);
            this.writer.setPosition(this.position);
        } else if (type != this.type) {
            this.promoteToUnion();
            if (this.requiresArrowType(type)) {
                ((UnionWriter)this.writer).getWriter(type, arrowType);
            } else {
                ((UnionWriter)this.writer).getWriter(type);
            }
        }
        return this.writer;
    }

    @Override
    public boolean isEmptyStruct() {
        return this.writer.isEmptyStruct();
    }

    @Override
    protected FieldWriter getWriter() {
        return this.writer;
    }

    private FieldWriter promoteToUnion() {
        String name = this.vector.getField().getName();
        TransferPair tp = this.vector.getTransferPair(this.vector.getMinorType().name().toLowerCase(Locale.ROOT), this.vector.getAllocator());
        tp.transfer();
        if (this.parentContainer != null) {
            this.unionVector = this.parentContainer.addOrGetUnion(name);
            this.unionVector.allocateNew();
        } else if (this.listVector != null) {
            this.unionVector = this.listVector.promoteToUnion();
        } else if (this.fixedListVector != null) {
            this.unionVector = this.fixedListVector.promoteToUnion();
        } else if (this.largeListVector != null) {
            this.unionVector = this.largeListVector.promoteToUnion();
        } else if (this.listViewVector != null) {
            this.unionVector = this.listViewVector.promoteToUnion();
        }
        this.unionVector.addVector((FieldVector)tp.getTo());
        this.writer = new UnionWriter(this.unionVector, this.nullableStructWriterFactory);
        this.writer.setPosition(this.idx());
        for (int i = 0; i <= this.idx(); ++i) {
            this.unionVector.setType(i, this.vector.getMinorType());
        }
        this.vector = null;
        this.state = State.UNION;
        return this.writer;
    }

    @Override
    public void write(DecimalHolder holder) {
        this.getWriter(Types.MinorType.DECIMAL, new ArrowType.Decimal(38, holder.scale, 128)).write(holder);
    }

    @Override
    public void writeDecimal(long start, ArrowBuf buffer, ArrowType arrowType) {
        this.getWriter(Types.MinorType.DECIMAL, new ArrowType.Decimal(38, ((ArrowType.Decimal)arrowType).getScale(), 128)).writeDecimal(start, buffer, arrowType);
    }

    @Override
    public void writeDecimal(BigDecimal value) {
        this.getWriter(Types.MinorType.DECIMAL, new ArrowType.Decimal(38, value.scale(), 128)).writeDecimal(value);
    }

    @Override
    public void writeBigEndianBytesToDecimal(byte[] value, ArrowType arrowType) {
        this.getWriter(Types.MinorType.DECIMAL, new ArrowType.Decimal(38, ((ArrowType.Decimal)arrowType).getScale(), 128)).writeBigEndianBytesToDecimal(value, arrowType);
    }

    @Override
    public void write(Decimal256Holder holder) {
        this.getWriter(Types.MinorType.DECIMAL256, new ArrowType.Decimal(76, holder.scale, 256)).write(holder);
    }

    @Override
    public void writeDecimal256(long start, ArrowBuf buffer, ArrowType arrowType) {
        this.getWriter(Types.MinorType.DECIMAL256, new ArrowType.Decimal(76, ((ArrowType.Decimal)arrowType).getScale(), 256)).writeDecimal256(start, buffer, arrowType);
    }

    @Override
    public void writeDecimal256(BigDecimal value) {
        this.getWriter(Types.MinorType.DECIMAL256, new ArrowType.Decimal(76, value.scale(), 256)).writeDecimal256(value);
    }

    @Override
    public void writeBigEndianBytesToDecimal256(byte[] value, ArrowType arrowType) {
        this.getWriter(Types.MinorType.DECIMAL256, new ArrowType.Decimal(76, ((ArrowType.Decimal)arrowType).getScale(), 256)).writeBigEndianBytesToDecimal256(value, arrowType);
    }

    @Override
    public void writeVarBinary(byte[] value) {
        this.getWriter(Types.MinorType.VARBINARY).writeVarBinary(value);
    }

    @Override
    public void writeVarBinary(byte[] value, int offset, int length) {
        this.getWriter(Types.MinorType.VARBINARY).writeVarBinary(value, offset, length);
    }

    @Override
    public void writeVarBinary(ByteBuffer value) {
        this.getWriter(Types.MinorType.VARBINARY).writeVarBinary(value);
    }

    @Override
    public void writeVarBinary(ByteBuffer value, int offset, int length) {
        this.getWriter(Types.MinorType.VARBINARY).writeVarBinary(value, offset, length);
    }

    @Override
    public void writeLargeVarBinary(byte[] value) {
        this.getWriter(Types.MinorType.LARGEVARBINARY).writeLargeVarBinary(value);
    }

    @Override
    public void writeLargeVarBinary(byte[] value, int offset, int length) {
        this.getWriter(Types.MinorType.LARGEVARBINARY).writeLargeVarBinary(value, offset, length);
    }

    @Override
    public void writeLargeVarBinary(ByteBuffer value) {
        this.getWriter(Types.MinorType.LARGEVARBINARY).writeLargeVarBinary(value);
    }

    @Override
    public void writeLargeVarBinary(ByteBuffer value, int offset, int length) {
        this.getWriter(Types.MinorType.LARGEVARBINARY).writeLargeVarBinary(value, offset, length);
    }

    @Override
    public void writeVarChar(Text value) {
        this.getWriter(Types.MinorType.VARCHAR).writeVarChar(value);
    }

    @Override
    public void writeVarChar(String value) {
        this.getWriter(Types.MinorType.VARCHAR).writeVarChar(value);
    }

    @Override
    public void writeLargeVarChar(Text value) {
        this.getWriter(Types.MinorType.LARGEVARCHAR).writeLargeVarChar(value);
    }

    @Override
    public void writeLargeVarChar(String value) {
        this.getWriter(Types.MinorType.LARGEVARCHAR).writeLargeVarChar(value);
    }

    @Override
    public void allocate() {
        this.getWriter().allocate();
    }

    @Override
    public void clear() {
        this.getWriter().clear();
    }

    @Override
    public Field getField() {
        return this.getWriter().getField();
    }

    @Override
    public int getValueCapacity() {
        return this.getWriter().getValueCapacity();
    }

    @Override
    public void close() throws Exception {
        this.getWriter().close();
    }

    private static enum State {
        UNTYPED,
        SINGLE,
        UNION;

    }
}

