/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.collection;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.error.ScopeNotFoundException;
import com.couchbase.client.core.manager.CoreCollectionManager;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.manager.collection.CollectionSpec;
import com.couchbase.client.java.manager.collection.CreateCollectionOptions;
import com.couchbase.client.java.manager.collection.CreateScopeOptions;
import com.couchbase.client.java.manager.collection.DropCollectionOptions;
import com.couchbase.client.java.manager.collection.DropScopeOptions;
import com.couchbase.client.java.manager.collection.GetAllScopesOptions;
import com.couchbase.client.java.manager.collection.GetScopeOptions;
import com.couchbase.client.java.manager.collection.ScopeSpec;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@Stability.Volatile
public class AsyncCollectionManager {
    private final CoreCollectionManager coreCollectionManager;

    @Stability.Internal
    public AsyncCollectionManager(CoreCollectionManager coreCollectionManager) {
        this.coreCollectionManager = Objects.requireNonNull(coreCollectionManager);
    }

    public CompletableFuture<Void> createCollection(CollectionSpec collectionSpec) {
        return this.createCollection(collectionSpec, CreateCollectionOptions.createCollectionOptions());
    }

    public CompletableFuture<Void> createCollection(CollectionSpec collectionSpec, CreateCollectionOptions options) {
        return this.coreCollectionManager.createCollection(collectionSpec.scopeName(), collectionSpec.name(), collectionSpec.maxExpiry(), (CoreCommonOptions)options.build());
    }

    public CompletableFuture<Void> createScope(String scopeName) {
        return this.createScope(scopeName, CreateScopeOptions.createScopeOptions());
    }

    public CompletableFuture<Void> createScope(String scopeName, CreateScopeOptions options) {
        return this.coreCollectionManager.createScope(scopeName, (CoreCommonOptions)options.build());
    }

    public CompletableFuture<Void> dropCollection(CollectionSpec collectionSpec) {
        return this.dropCollection(collectionSpec, DropCollectionOptions.dropCollectionOptions());
    }

    public CompletableFuture<Void> dropCollection(CollectionSpec collectionSpec, DropCollectionOptions options) {
        return this.coreCollectionManager.dropCollection(collectionSpec.scopeName(), collectionSpec.name(), (CoreCommonOptions)options.build());
    }

    public CompletableFuture<Void> dropScope(String scopeName) {
        return this.dropScope(scopeName, DropScopeOptions.dropScopeOptions());
    }

    public CompletableFuture<Void> dropScope(String scopeName, DropScopeOptions options) {
        return this.coreCollectionManager.dropScope(scopeName, (CoreCommonOptions)options.build());
    }

    @Deprecated
    public CompletableFuture<ScopeSpec> getScope(String scopeName) {
        return this.getScope(scopeName, GetScopeOptions.getScopeOptions());
    }

    @Deprecated
    public CompletableFuture<ScopeSpec> getScope(String scopeName, GetScopeOptions options) {
        Validators.notNullOrEmpty((String)scopeName, (String)"ScopeName");
        Validators.notNull((Object)options, (String)"Options");
        GetScopeOptions.Built opts = options.build();
        GetAllScopesOptions toPassOptions = GetAllScopesOptions.getAllScopesOptions();
        opts.timeout().ifPresent(toPassOptions::timeout);
        opts.retryStrategy().ifPresent(toPassOptions::retryStrategy);
        return this.getAllScopes(toPassOptions).thenApply(scopes -> {
            Optional<ScopeSpec> scope = scopes.stream().filter(s -> s.name().equals(scopeName)).findFirst();
            if (scope.isPresent()) {
                return scope.get();
            }
            throw ScopeNotFoundException.forScope((String)scopeName);
        });
    }

    public CompletableFuture<List<ScopeSpec>> getAllScopes() {
        return this.getAllScopes(GetAllScopesOptions.getAllScopesOptions());
    }

    public CompletableFuture<List<ScopeSpec>> getAllScopes(GetAllScopesOptions options) {
        return this.coreCollectionManager.getAllScopes((CoreCommonOptions)options.build()).thenApply(manifest -> manifest.scopes().stream().map(s -> ScopeSpec.create(s.name(), s.collections().stream().map(c -> CollectionSpec.create(c.name(), s.name(), Duration.ofSeconds(c.maxExpiry()))).collect(Collectors.toSet()))).collect(Collectors.toList()));
    }
}

