/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.Reactor;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.kv.CoreGetResult;
import com.couchbase.client.core.api.kv.CoreKvOps;
import com.couchbase.client.core.api.kv.CoreSubdocMutateResult;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.error.context.ReducedKeyValueErrorContext;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.kv.CoreScanOptions;
import com.couchbase.client.core.msg.Request;
import com.couchbase.client.core.msg.kv.SubdocGetRequest;
import com.couchbase.client.core.util.CbCollections;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.AsyncCollection;
import com.couchbase.client.java.ReactiveBinaryCollection;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.codec.Transcoder;
import com.couchbase.client.java.env.ClusterEnvironment;
import com.couchbase.client.java.kv.ExistsOptions;
import com.couchbase.client.java.kv.ExistsResult;
import com.couchbase.client.java.kv.Expiry;
import com.couchbase.client.java.kv.GetAllReplicasOptions;
import com.couchbase.client.java.kv.GetAndLockOptions;
import com.couchbase.client.java.kv.GetAndTouchOptions;
import com.couchbase.client.java.kv.GetAnyReplicaOptions;
import com.couchbase.client.java.kv.GetOptions;
import com.couchbase.client.java.kv.GetReplicaResult;
import com.couchbase.client.java.kv.GetResult;
import com.couchbase.client.java.kv.InsertOptions;
import com.couchbase.client.java.kv.LookupInAccessor;
import com.couchbase.client.java.kv.LookupInOptions;
import com.couchbase.client.java.kv.LookupInResult;
import com.couchbase.client.java.kv.LookupInSpec;
import com.couchbase.client.java.kv.MutateInOptions;
import com.couchbase.client.java.kv.MutateInResult;
import com.couchbase.client.java.kv.MutateInSpec;
import com.couchbase.client.java.kv.MutationResult;
import com.couchbase.client.java.kv.RemoveOptions;
import com.couchbase.client.java.kv.ReplaceOptions;
import com.couchbase.client.java.kv.ScanOptions;
import com.couchbase.client.java.kv.ScanResult;
import com.couchbase.client.java.kv.ScanType;
import com.couchbase.client.java.kv.TouchOptions;
import com.couchbase.client.java.kv.UnlockOptions;
import com.couchbase.client.java.kv.UpsertOptions;
import com.couchbase.client.java.manager.query.ReactiveCollectionQueryIndexManager;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveCollection {
    static final ExistsOptions DEFAULT_EXISTS_OPTIONS = ExistsOptions.existsOptions();
    static final GetAndLockOptions DEFAULT_GET_AND_LOCK_OPTIONS = GetAndLockOptions.getAndLockOptions();
    static final GetAndTouchOptions DEFAULT_GET_AND_TOUCH_OPTIONS = GetAndTouchOptions.getAndTouchOptions();
    static final GetAllReplicasOptions DEFAULT_GET_ALL_REPLICAS_OPTIONS = GetAllReplicasOptions.getAllReplicasOptions();
    static final GetAnyReplicaOptions DEFAULT_GET_ANY_REPLICA_OPTIONS = GetAnyReplicaOptions.getAnyReplicaOptions();
    static final GetOptions DEFAULT_GET_OPTIONS = GetOptions.getOptions();
    static final InsertOptions DEFAULT_INSERT_OPTIONS = InsertOptions.insertOptions();
    static final LookupInOptions DEFAULT_LOOKUP_IN_OPTIONS = LookupInOptions.lookupInOptions();
    static final MutateInOptions DEFAULT_MUTATE_IN_OPTIONS = MutateInOptions.mutateInOptions();
    static final RemoveOptions DEFAULT_REMOVE_OPTIONS = RemoveOptions.removeOptions();
    static final ReplaceOptions DEFAULT_REPLACE_OPTIONS = ReplaceOptions.replaceOptions();
    static final TouchOptions DEFAULT_TOUCH_OPTIONS = TouchOptions.touchOptions();
    static final UnlockOptions DEFAULT_UNLOCK_OPTIONS = UnlockOptions.unlockOptions();
    static final UpsertOptions DEFAULT_UPSERT_OPTIONS = UpsertOptions.upsertOptions();
    private final AsyncCollection asyncCollection;
    private final CoreKvOps kvOps;
    private final ReactiveBinaryCollection reactiveBinaryCollection;
    private final ReactiveCollectionQueryIndexManager queryIndexManager;

    ReactiveCollection(AsyncCollection asyncCollection) {
        this.asyncCollection = asyncCollection;
        this.reactiveBinaryCollection = new ReactiveBinaryCollection(asyncCollection.binary());
        this.kvOps = asyncCollection.kvOps;
        this.queryIndexManager = new ReactiveCollectionQueryIndexManager(asyncCollection.queryIndexes());
    }

    public AsyncCollection async() {
        return this.asyncCollection;
    }

    public String name() {
        return this.asyncCollection.name();
    }

    public String bucketName() {
        return this.asyncCollection.bucketName();
    }

    public String scopeName() {
        return this.asyncCollection.scopeName();
    }

    @Stability.Volatile
    public Core core() {
        return this.asyncCollection.core();
    }

    public ClusterEnvironment environment() {
        return this.asyncCollection.environment();
    }

    public ReactiveBinaryCollection binary() {
        return this.reactiveBinaryCollection;
    }

    @Stability.Volatile
    public ReactiveCollectionQueryIndexManager queryIndexes() {
        return this.queryIndexManager;
    }

    public Mono<GetResult> get(String id) {
        return this.get(id, DEFAULT_GET_OPTIONS);
    }

    public Mono<GetResult> get(String id, GetOptions options) {
        GetOptions.Built opts = options.build();
        Transcoder transcoder = opts.transcoder() == null ? this.environment().transcoder() : opts.transcoder();
        return this.kvOps.getReactive((CoreCommonOptions)opts, id, opts.projections(), opts.withExpiry()).map(it -> new GetResult((CoreGetResult)it, transcoder));
    }

    public Mono<GetResult> getAndLock(String id, Duration lockTime) {
        return this.getAndLock(id, lockTime, DEFAULT_GET_AND_LOCK_OPTIONS);
    }

    public Mono<GetResult> getAndLock(String id, Duration lockTime, GetAndLockOptions options) {
        GetAndLockOptions.Built opts = options.build();
        Transcoder transcoder = opts.transcoder() == null ? this.environment().transcoder() : opts.transcoder();
        return this.kvOps.getAndLockReactive((CoreCommonOptions)opts, id, lockTime).map(it -> new GetResult((CoreGetResult)it, transcoder));
    }

    public Mono<GetResult> getAndTouch(String id, Duration expiry) {
        return this.getAndTouch(id, expiry, DEFAULT_GET_AND_TOUCH_OPTIONS);
    }

    public Mono<GetResult> getAndTouch(String id, Duration expiry, GetAndTouchOptions options) {
        GetAndTouchOptions.Built opts = options.build();
        Transcoder transcoder = opts.transcoder() == null ? this.environment().transcoder() : opts.transcoder();
        return this.kvOps.getAndTouchReactive((CoreCommonOptions)opts, id, Expiry.relative(expiry).encode()).map(it -> new GetResult((CoreGetResult)it, transcoder));
    }

    public Flux<GetReplicaResult> getAllReplicas(String id) {
        return this.getAllReplicas(id, DEFAULT_GET_ALL_REPLICAS_OPTIONS);
    }

    public Flux<GetReplicaResult> getAllReplicas(String id, GetAllReplicasOptions options) {
        Validators.notNull((Object)options, (String)"GetAllReplicasOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.asyncCollection.collectionIdentifier()));
        GetAllReplicasOptions.Built opts = options.build();
        Transcoder transcoder = Optional.ofNullable(opts.transcoder()).orElse(this.environment().transcoder());
        return this.kvOps.getAllReplicasReactive((CoreCommonOptions)opts, id).map(response -> GetReplicaResult.from(response, transcoder));
    }

    public Mono<GetReplicaResult> getAnyReplica(String id) {
        return this.getAnyReplica(id, DEFAULT_GET_ANY_REPLICA_OPTIONS);
    }

    public Mono<GetReplicaResult> getAnyReplica(String id, GetAnyReplicaOptions options) {
        Validators.notNull((Object)options, (String)"GetAnyReplicaOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.asyncCollection.collectionIdentifier()));
        GetAnyReplicaOptions.Built opts = options.build();
        Transcoder transcoder = Optional.ofNullable(opts.transcoder()).orElse(this.environment().transcoder());
        return this.kvOps.getAnyReplicaReactive((CoreCommonOptions)opts, id).map(response -> GetReplicaResult.from(response, transcoder));
    }

    public Mono<ExistsResult> exists(String id) {
        return this.exists(id, DEFAULT_EXISTS_OPTIONS);
    }

    public Mono<ExistsResult> exists(String id, ExistsOptions options) {
        ExistsOptions.Built opts = ((ExistsOptions)Validators.notNull((Object)options, (String)"ExistsOptions")).build();
        return this.kvOps.existsReactive((CoreCommonOptions)opts, id).map(ExistsResult::from);
    }

    public Mono<MutationResult> remove(String id) {
        return this.remove(id, DEFAULT_REMOVE_OPTIONS);
    }

    public Mono<MutationResult> remove(String id, RemoveOptions options) {
        Validators.notNull((Object)options, (String)"RemoveOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.asyncCollection.collectionIdentifier()));
        RemoveOptions.Built opts = options.build();
        return this.kvOps.removeReactive((CoreCommonOptions)opts, id, opts.cas(), opts.toCoreDurability()).map(MutationResult::new);
    }

    public Mono<MutationResult> insert(String id, Object content) {
        return this.insert(id, content, DEFAULT_INSERT_OPTIONS);
    }

    public Mono<MutationResult> insert(String id, Object content, InsertOptions options) {
        Validators.notNull((Object)options, (String)"InsertOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.asyncCollection.collectionIdentifier()));
        Validators.notNull((Object)content, (String)"Content", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.asyncCollection.collectionIdentifier()));
        InsertOptions.Built opts = options.build();
        Transcoder transcoder = opts.transcoder() == null ? this.environment().transcoder() : opts.transcoder();
        return this.kvOps.insertReactive((CoreCommonOptions)opts, id, () -> transcoder.encode(content), opts.toCoreDurability(), opts.expiry().encode()).map(MutationResult::new);
    }

    public Mono<MutationResult> upsert(String id, Object content) {
        return this.upsert(id, content, DEFAULT_UPSERT_OPTIONS);
    }

    public Mono<MutationResult> upsert(String id, Object content, UpsertOptions options) {
        Validators.notNull((Object)options, (String)"UpsertOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.asyncCollection.collectionIdentifier()));
        Validators.notNull((Object)content, (String)"Content", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.asyncCollection.collectionIdentifier()));
        UpsertOptions.Built opts = options.build();
        Transcoder transcoder = opts.transcoder() == null ? this.environment().transcoder() : opts.transcoder();
        return this.kvOps.upsertReactive((CoreCommonOptions)opts, id, () -> transcoder.encode(content), opts.toCoreDurability(), opts.expiry().encode(), opts.preserveExpiry()).map(MutationResult::new);
    }

    public Mono<MutationResult> replace(String id, Object content) {
        return this.replace(id, content, DEFAULT_REPLACE_OPTIONS);
    }

    public Mono<MutationResult> replace(String id, Object content, ReplaceOptions options) {
        Validators.notNull((Object)options, (String)"ReplaceOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.asyncCollection.collectionIdentifier()));
        Validators.notNull((Object)content, (String)"Content", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.asyncCollection.collectionIdentifier()));
        ReplaceOptions.Built opts = options.build();
        Transcoder transcoder = opts.transcoder() == null ? this.environment().transcoder() : opts.transcoder();
        return this.kvOps.replaceReactive((CoreCommonOptions)opts, id, () -> transcoder.encode(content), opts.cas(), opts.toCoreDurability(), opts.expiry().encode(), opts.preserveExpiry()).map(MutationResult::new);
    }

    public Mono<MutationResult> touch(String id, Duration expiry) {
        return this.touch(id, expiry, DEFAULT_TOUCH_OPTIONS);
    }

    public Mono<MutationResult> touch(String id, Duration expiry, TouchOptions options) {
        Validators.notNull((Object)options, (String)"TouchOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.asyncCollection.collectionIdentifier()));
        Validators.notNull((Object)expiry, (String)"Expiry", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.asyncCollection.collectionIdentifier()));
        TouchOptions.Built opts = options.build();
        return this.kvOps.touchReactive((CoreCommonOptions)opts, id, Expiry.relative(expiry).encode()).map(MutationResult::new);
    }

    public Mono<Void> unlock(String id, long cas) {
        return this.unlock(id, cas, DEFAULT_UNLOCK_OPTIONS);
    }

    public Mono<Void> unlock(String id, long cas, UnlockOptions options) {
        Validators.notNull((Object)options, (String)"UnlockOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.asyncCollection.collectionIdentifier()));
        UnlockOptions.Built opts = options.build();
        return this.kvOps.unlockReactive((CoreCommonOptions)opts, id, cas);
    }

    public Mono<LookupInResult> lookupIn(String id, List<LookupInSpec> specs) {
        return this.lookupIn(id, specs, DEFAULT_LOOKUP_IN_OPTIONS);
    }

    public Mono<LookupInResult> lookupIn(String id, List<LookupInSpec> specs, LookupInOptions options) {
        return Mono.defer(() -> {
            Validators.notNull((Object)options, (String)"LookupInOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.asyncCollection.collectionIdentifier()));
            LookupInOptions.Built opts = options.build();
            JsonSerializer serializer = opts.serializer() == null ? this.environment().jsonSerializer() : opts.serializer();
            SubdocGetRequest request = this.asyncCollection.lookupInRequest(id, specs, opts);
            return Reactor.wrap((Request)request, LookupInAccessor.lookupInAccessor(this.core(), request, serializer), (boolean)true);
        });
    }

    public Mono<MutateInResult> mutateIn(String id, List<MutateInSpec> specs) {
        return this.mutateIn(id, specs, DEFAULT_MUTATE_IN_OPTIONS);
    }

    public Mono<MutateInResult> mutateIn(String id, List<MutateInSpec> specs, MutateInOptions options) {
        Validators.notNull((Object)options, (String)"MutateInOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.async().collectionIdentifier()));
        Validators.notNull(specs, (String)"MutationSpecs", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.async().collectionIdentifier()));
        MutateInOptions.Built opts = options.build();
        JsonSerializer serializer = opts.serializer() == null ? this.environment().jsonSerializer() : opts.serializer();
        return this.kvOps.subdocMutateReactive((CoreCommonOptions)opts, id, () -> CbCollections.transform((Iterable)specs, it -> it.toCore(serializer)), opts.storeSemantics().toCore(), opts.cas(), opts.toCoreDurability(), opts.expiry().encode(), opts.preserveExpiry(), opts.accessDeleted(), opts.createAsDeleted()).map(it -> new MutateInResult((CoreSubdocMutateResult)it, serializer));
    }

    @Stability.Volatile
    public Flux<ScanResult> scan(ScanType scanType) {
        return this.scan(scanType, ScanOptions.scanOptions());
    }

    @Stability.Volatile
    public Flux<ScanResult> scan(ScanType scanType, ScanOptions options) {
        Validators.notNull((Object)scanType, (String)"ScanType", () -> ReducedKeyValueErrorContext.create(null, (CollectionIdentifier)this.asyncCollection.collectionIdentifier()));
        ScanOptions.Built opts = ((ScanOptions)Validators.notNull((Object)options, (String)"ScanOptions", () -> ReducedKeyValueErrorContext.create(null, (CollectionIdentifier)this.asyncCollection.collectionIdentifier()))).build();
        return this.kvOps.scanRequestReactive(scanType.build(), (CoreScanOptions)opts).map(r -> new ScanResult(opts.idsOnly(), r.key(), r.value(), r.flags(), r.cas(), Optional.ofNullable(r.expiry()), opts.transcoder()));
    }
}

