/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.util;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.config.ClusterConfig;
import com.couchbase.client.core.config.ConfigurationProvider;
import com.couchbase.client.core.config.CouchbaseBucketConfig;
import com.couchbase.client.core.config.MemcachedBucketConfig;
import com.couchbase.client.core.config.NodeInfo;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.internal.GetConfigProviderRequest;
import com.couchbase.client.core.message.internal.GetConfigProviderResponse;
import com.couchbase.client.deps.io.netty.util.CharsetUtil;
import com.couchbase.client.java.Bucket;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.CRC32;
import rx.functions.Action1;
import rx.functions.Func1;

@InterfaceStability.Uncommitted
@InterfaceAudience.Public
public class NodeLocatorHelper {
    private final AtomicReference<BucketConfig> bucketConfig;

    private NodeLocatorHelper(final Bucket bucket) {
        ConfigurationProvider configProvider = ((GetConfigProviderResponse)bucket.core().send((CouchbaseRequest)new GetConfigProviderRequest()).toBlocking().single()).provider();
        this.bucketConfig = new AtomicReference<BucketConfig>(configProvider.config().bucketConfig(bucket.name()));
        configProvider.configs().filter((Func1)new Func1<ClusterConfig, Boolean>(){

            public Boolean call(ClusterConfig clusterConfig) {
                return clusterConfig.hasBucket(bucket.name());
            }
        }).subscribe((Action1)new Action1<ClusterConfig>(){

            public void call(ClusterConfig config) {
                NodeLocatorHelper.this.bucketConfig.set(config.bucketConfig(bucket.name()));
            }
        });
    }

    public static NodeLocatorHelper create(Bucket bucket) {
        return new NodeLocatorHelper(bucket);
    }

    public InetAddress activeNodeForId(String id) {
        BucketConfig config = this.bucketConfig.get();
        if (config instanceof CouchbaseBucketConfig) {
            return NodeLocatorHelper.nodeForIdOnCouchbaseBucket(id, (CouchbaseBucketConfig)config);
        }
        if (config instanceof MemcachedBucketConfig) {
            return NodeLocatorHelper.nodeForIdOnMemcachedBucket(id, (MemcachedBucketConfig)config);
        }
        throw new UnsupportedOperationException("Bucket type not supported: " + config.getClass().getName());
    }

    public List<InetAddress> replicaNodesForId(String id) {
        BucketConfig config = this.bucketConfig.get();
        if (config instanceof CouchbaseBucketConfig) {
            CouchbaseBucketConfig cbc = (CouchbaseBucketConfig)config;
            ArrayList<InetAddress> replicas = new ArrayList<InetAddress>();
            for (int i = 1; i <= cbc.numberOfReplicas(); ++i) {
                replicas.add(this.replicaNodeForId(id, i));
            }
            return replicas;
        }
        throw new UnsupportedOperationException("Bucket type not supported: " + config.getClass().getName());
    }

    public List<InetAddress> availableReplicaNodesForId(String id) {
        BucketConfig config = this.bucketConfig.get();
        if (config instanceof CouchbaseBucketConfig) {
            CouchbaseBucketConfig cbc = (CouchbaseBucketConfig)config;
            ArrayList<InetAddress> replicas = new ArrayList<InetAddress>();
            for (int i = 1; i <= cbc.numberOfReplicas(); ++i) {
                InetAddress foundReplica = this.replicaNodeForId(id, i, false);
                if (foundReplica == null) continue;
                replicas.add(foundReplica);
            }
            return replicas;
        }
        throw new UnsupportedOperationException("Bucket type not supported: " + config.getClass().getName());
    }

    public InetAddress replicaNodeForId(String id, int replicaNum) {
        return this.replicaNodeForId(id, replicaNum, true);
    }

    private InetAddress replicaNodeForId(String id, int replicaNum, boolean throwOnNotAvailable) {
        if (replicaNum < 1 || replicaNum > 3) {
            throw new IllegalArgumentException("Replica number must be between 1 and 3.");
        }
        BucketConfig config = this.bucketConfig.get();
        if (config instanceof CouchbaseBucketConfig) {
            CouchbaseBucketConfig cbc = (CouchbaseBucketConfig)config;
            int partitionId = (int)NodeLocatorHelper.hashId(id) & cbc.numberOfPartitions() - 1;
            short nodeId = cbc.nodeIndexForReplica(partitionId, replicaNum - 1, false);
            if (nodeId == -1) {
                if (throwOnNotAvailable) {
                    throw new IllegalStateException("No partition assigned to node for Document ID: " + id);
                }
                return null;
            }
            if (nodeId == -2) {
                if (throwOnNotAvailable) {
                    throw new IllegalStateException("Replica not configured for this bucket.");
                }
                return null;
            }
            try {
                return InetAddress.getByName(cbc.nodeAtIndex((int)nodeId).hostname());
            }
            catch (UnknownHostException e) {
                throw new IllegalStateException(e);
            }
        }
        throw new UnsupportedOperationException("Bucket type not supported: " + config.getClass().getName());
    }

    public List<InetAddress> nodes() {
        ArrayList<InetAddress> allNodes = new ArrayList<InetAddress>();
        BucketConfig config = this.bucketConfig.get();
        for (NodeInfo nodeInfo : config.nodes()) {
            try {
                allNodes.add(InetAddress.getByName(nodeInfo.hostname()));
            }
            catch (UnknownHostException e) {
                throw new IllegalStateException(e);
            }
        }
        return allNodes;
    }

    private static InetAddress nodeForIdOnCouchbaseBucket(String id, CouchbaseBucketConfig config) {
        int partitionId = (int)NodeLocatorHelper.hashId(id) & config.numberOfPartitions() - 1;
        short nodeId = config.nodeIndexForMaster(partitionId, false);
        if (nodeId == -1) {
            throw new IllegalStateException("No partition assigned to node for Document ID: " + id);
        }
        try {
            return InetAddress.getByName(config.nodeAtIndex((int)nodeId).hostname());
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException(e);
        }
    }

    private static InetAddress nodeForIdOnMemcachedBucket(String id, MemcachedBucketConfig config) {
        long hash = NodeLocatorHelper.ketamaHash(id);
        if (!config.ketamaNodes().containsKey(hash)) {
            SortedMap tailMap = config.ketamaNodes().tailMap(hash);
            hash = tailMap.isEmpty() ? ((Long)config.ketamaNodes().firstKey()).longValue() : tailMap.firstKey().longValue();
        }
        try {
            return InetAddress.getByName(((NodeInfo)config.ketamaNodes().get(hash)).hostname());
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException(e);
        }
    }

    private static long hashId(String id) {
        CRC32 crc32 = new CRC32();
        try {
            crc32.update(id.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return crc32.getValue() >> 16 & 0x7FFFL;
    }

    private static long ketamaHash(String key) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(key.getBytes(CharsetUtil.UTF_8));
            byte[] digest = md5.digest();
            long rv = (long)(digest[3] & 0xFF) << 24 | (long)(digest[2] & 0xFF) << 16 | (long)(digest[1] & 0xFF) << 8 | (long)(digest[0] & 0xFF);
            return rv & 0xFFFFFFFFL;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Could not encode ketama hash.", e);
        }
    }
}

