/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.repository.mapping;

import com.couchbase.client.java.repository.annotation.EncryptedField;
import com.couchbase.client.java.repository.annotation.Field;
import com.couchbase.client.java.repository.annotation.Id;
import com.couchbase.client.java.repository.mapping.PropertyMetadata;
import com.couchbase.client.java.repository.mapping.RepositoryMappingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.HashSet;
import java.util.Set;

public class ReflectionBasedPropertyMetadata
implements PropertyMetadata {
    private final java.lang.reflect.Field fieldReference;
    private final boolean isId;
    private final boolean isField;
    private final String name;
    private final String realName;
    private final String encryptionProviderName;

    public ReflectionBasedPropertyMetadata(java.lang.reflect.Field fieldReference) {
        this.fieldReference = fieldReference;
        this.isId = ReflectionBasedPropertyMetadata.hasAnnotation(fieldReference, Id.class);
        this.isField = ReflectionBasedPropertyMetadata.hasAnnotation(fieldReference, Field.class);
        EncryptedField encryptedField = ReflectionBasedPropertyMetadata.findAnnotation(fieldReference, EncryptedField.class);
        this.encryptionProviderName = encryptedField != null ? encryptedField.provider() : null;
        this.realName = fieldReference.getName();
        this.name = ReflectionBasedPropertyMetadata.extractName(fieldReference);
        fieldReference.setAccessible(true);
    }

    @Override
    public boolean isId() {
        return this.isId;
    }

    @Override
    public boolean isField() {
        return this.isField;
    }

    @Override
    public String encryptionProviderName() {
        return this.encryptionProviderName;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String realName() {
        return this.realName;
    }

    @Override
    public Class<?> type() {
        return this.fieldReference.getType();
    }

    @Override
    public Object get(Object source) {
        try {
            return this.fieldReference.get(source);
        }
        catch (IllegalAccessException ex) {
            throw new RepositoryMappingException("Could not access field.", ex);
        }
    }

    @Override
    public void set(Object value, Object source) {
        try {
            this.fieldReference.set(source, value);
        }
        catch (IllegalAccessException ex) {
            throw new RepositoryMappingException("Could not access field.", ex);
        }
    }

    private static String extractName(java.lang.reflect.Field fieldReference) {
        Field annotation = ReflectionBasedPropertyMetadata.findAnnotation(fieldReference, Field.class);
        if (annotation == null || annotation.value().isEmpty()) {
            return fieldReference.getName();
        }
        return annotation.value();
    }

    private static boolean hasAnnotation(AnnotatedElement element, Class<? extends Annotation> annotationClass) {
        return ReflectionBasedPropertyMetadata.findAnnotation(element, annotationClass) != null;
    }

    private static <T extends Annotation> T findAnnotation(AnnotatedElement element, Class<T> annotationClass) {
        for (Annotation a : element.getAnnotations()) {
            T meta = ReflectionBasedPropertyMetadata.findAnnotationRecursive(a, annotationClass, new HashSet<Class>());
            if (meta == null) continue;
            return meta;
        }
        return null;
    }

    private static <T extends Annotation> T findAnnotationRecursive(Annotation annotation, Class<T> annotationClass, Set<Class> seen) {
        Class<? extends Annotation> c = annotation.annotationType();
        if (!seen.add(c)) {
            return null;
        }
        if (c.equals(annotationClass)) {
            return (T)((Annotation)annotationClass.cast(annotation));
        }
        for (Annotation meta : c.getAnnotations()) {
            T found = ReflectionBasedPropertyMetadata.findAnnotationRecursive(meta, annotationClass, seen);
            if (found == null) continue;
            return found;
        }
        return null;
    }
}

