/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.cluster;

import com.couchbase.client.core.ClusterFacade;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.utils.Blocking;
import com.couchbase.client.core.utils.ConnectionString;
import com.couchbase.client.java.cluster.AsyncClusterManager;
import com.couchbase.client.java.cluster.AuthDomain;
import com.couchbase.client.java.cluster.BucketSettings;
import com.couchbase.client.java.cluster.ClusterInfo;
import com.couchbase.client.java.cluster.ClusterManager;
import com.couchbase.client.java.cluster.DefaultAsyncClusterManager;
import com.couchbase.client.java.cluster.User;
import com.couchbase.client.java.cluster.UserSettings;
import com.couchbase.client.java.cluster.api.ClusterApiClient;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import java.util.List;
import java.util.concurrent.TimeUnit;
import rx.Observable;

public class DefaultClusterManager
implements ClusterManager {
    private static final TimeUnit TIMEOUT_UNIT = TimeUnit.MILLISECONDS;
    private final AsyncClusterManager asyncClusterManager;
    private final String username;
    private final String password;
    private final ClusterFacade core;
    private final long timeout;

    public DefaultClusterManager(AsyncClusterManager asyncClusterManager, String username, String password, CouchbaseEnvironment environment, ClusterFacade core) {
        this.asyncClusterManager = asyncClusterManager;
        this.timeout = environment.managementTimeout();
        this.username = username;
        this.password = password;
        this.core = core;
    }

    DefaultClusterManager(String username, String password, List<ConnectionString.UnresolvedSocket> seedNodes, CouchbaseEnvironment environment, ClusterFacade core) {
        this.asyncClusterManager = DefaultAsyncClusterManager.create(username, password, seedNodes, environment, core);
        this.timeout = environment.managementTimeout();
        this.username = username;
        this.password = password;
        this.core = core;
    }

    @Deprecated
    public static DefaultClusterManager create(String username, String password, ConnectionString connectionString, CouchbaseEnvironment environment, ClusterFacade core) {
        return DefaultClusterManager.create(username, password, connectionString.hosts(), environment, core);
    }

    public static DefaultClusterManager create(String username, String password, List<ConnectionString.UnresolvedSocket> seedNodes, CouchbaseEnvironment environment, ClusterFacade core) {
        return new DefaultClusterManager(username, password, seedNodes, environment, core);
    }

    @Override
    public AsyncClusterManager async() {
        return this.asyncClusterManager;
    }

    @Override
    public ClusterInfo info() {
        return this.info(this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public ClusterInfo info(long timeout, TimeUnit timeUnit) {
        return (ClusterInfo)Blocking.blockForSingle((Observable)this.asyncClusterManager.info().single(), (long)timeout, (TimeUnit)timeUnit);
    }

    @Override
    public List<BucketSettings> getBuckets() {
        return this.getBuckets(this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public List<BucketSettings> getBuckets(long timeout, TimeUnit timeUnit) {
        return (List)Blocking.blockForSingle((Observable)this.asyncClusterManager.getBuckets().toList(), (long)timeout, (TimeUnit)timeUnit);
    }

    @Override
    public BucketSettings getBucket(String name) {
        return this.getBucket(name, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public BucketSettings getBucket(String name, long timeout, TimeUnit timeUnit) {
        return (BucketSettings)Blocking.blockForSingle((Observable)this.asyncClusterManager.getBucket(name).singleOrDefault(null), (long)timeout, (TimeUnit)timeUnit);
    }

    @Override
    public Boolean hasBucket(String name) {
        return this.hasBucket(name, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public Boolean hasBucket(String name, long timeout, TimeUnit timeUnit) {
        return (Boolean)Blocking.blockForSingle((Observable)this.asyncClusterManager.hasBucket(name).single(), (long)timeout, (TimeUnit)timeUnit);
    }

    @Override
    public BucketSettings insertBucket(BucketSettings settings) {
        return this.insertBucket(settings, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public BucketSettings insertBucket(BucketSettings settings, long timeout, TimeUnit timeUnit) {
        return (BucketSettings)Blocking.blockForSingle((Observable)this.asyncClusterManager.insertBucket(settings).single(), (long)timeout, (TimeUnit)timeUnit);
    }

    @Override
    public BucketSettings updateBucket(BucketSettings settings) {
        return this.updateBucket(settings, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public BucketSettings updateBucket(BucketSettings settings, long timeout, TimeUnit timeUnit) {
        return (BucketSettings)Blocking.blockForSingle((Observable)this.asyncClusterManager.updateBucket(settings).single(), (long)timeout, (TimeUnit)timeUnit);
    }

    @Override
    public Boolean removeBucket(String name) {
        return this.removeBucket(name, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public Boolean removeBucket(String name, long timeout, TimeUnit timeUnit) {
        return (Boolean)Blocking.blockForSingle((Observable)this.asyncClusterManager.removeBucket(name).single(), (long)timeout, (TimeUnit)timeUnit);
    }

    @Override
    public Boolean upsertUser(AuthDomain domain, String username, UserSettings settings) {
        return this.upsertUser(domain, username, settings, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public Boolean upsertUser(AuthDomain domain, String username, UserSettings settings, long timeout, TimeUnit timeUnit) {
        return (Boolean)Blocking.blockForSingle((Observable)this.asyncClusterManager.upsertUser(domain, username, settings).single(), (long)timeout, (TimeUnit)timeUnit);
    }

    @Override
    public Boolean removeUser(AuthDomain domain, String username) {
        return this.removeUser(domain, username, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public Boolean removeUser(AuthDomain domain, String username, long timeout, TimeUnit timeUnit) {
        return (Boolean)Blocking.blockForSingle((Observable)this.asyncClusterManager.removeUser(domain, username).single(), (long)timeout, (TimeUnit)timeUnit);
    }

    @Override
    public List<User> getUsers(AuthDomain domain) {
        return this.getUsers(domain, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public List<User> getUsers(AuthDomain domain, long timeout, TimeUnit timeUnit) {
        return (List)Blocking.blockForSingle((Observable)this.asyncClusterManager.getUsers(domain).toList().single(), (long)timeout, (TimeUnit)timeUnit);
    }

    @Override
    public User getUser(AuthDomain domain, String userid) {
        return (User)Blocking.blockForSingle((Observable)this.asyncClusterManager.getUser(domain, userid).single(), (long)this.timeout, (TimeUnit)TIMEOUT_UNIT);
    }

    @Override
    public User getUser(AuthDomain domain, String userid, long timeout, TimeUnit timeUnit) {
        return (User)Blocking.blockForSingle((Observable)this.asyncClusterManager.getUser(domain, userid).single(), (long)timeout, (TimeUnit)timeUnit);
    }

    @Override
    @InterfaceStability.Experimental
    public ClusterApiClient apiClient() {
        return new ClusterApiClient(this.username, this.password, this.core, this.timeout, TIMEOUT_UNIT);
    }
}

