/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.transport.netty;

import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.channel.Channel;
import com.couchbase.client.core.deps.io.netty.channel.ChannelHandler;
import com.couchbase.client.core.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.core.deps.io.netty.util.AttributeKey;
import com.couchbase.client.dcp.Client;
import com.couchbase.client.dcp.ConnectionNameGenerator;
import com.couchbase.client.dcp.buffer.DcpOps;
import com.couchbase.client.dcp.config.CompressionMode;
import com.couchbase.client.dcp.config.DcpControl;
import com.couchbase.client.dcp.core.logging.RedactableArgument;
import com.couchbase.client.dcp.message.BucketSelectRequest;
import com.couchbase.client.dcp.message.DcpOpenConnectionRequest;
import com.couchbase.client.dcp.message.HelloFeature;
import com.couchbase.client.dcp.message.HelloRequest;
import com.couchbase.client.dcp.message.MessageUtil;
import com.couchbase.client.dcp.message.ResponseStatus;
import com.couchbase.client.dcp.message.VersionRequest;
import com.couchbase.client.dcp.transport.netty.ConnectInterceptingHandler;
import com.couchbase.client.dcp.util.Version;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DcpConnectHandler
extends ConnectInterceptingHandler<ByteBuf> {
    private final ConnectionStep version = new ConnectionStep("version"){

        @Override
        void issueRequest(ChannelHandlerContext ctx) {
            ByteBuf request = ctx.alloc().buffer();
            VersionRequest.init(request);
            ctx.writeAndFlush((Object)request);
        }

        @Override
        ConnectionStep handleResponse(ChannelHandlerContext ctx, ByteBuf msg) {
            String versionString = MessageUtil.getContentAsString(msg);
            LOGGER.info("{} Couchbase Server version {}", (Object)RedactableArgument.system(ctx.channel()), (Object)versionString);
            Version serverVersion = Version.parseVersion(versionString);
            ctx.channel().attr(SERVER_VERSION).set((Object)serverVersion);
            return DcpConnectHandler.this.hello;
        }
    };
    private final ConnectionStep hello = new ConnectionStep("hello"){

        @Override
        void issueRequest(ChannelHandlerContext ctx) {
            Version serverVersion = DcpConnectHandler.getServerVersion(ctx.channel());
            CompressionMode compressionMode = DcpConnectHandler.this.dcpControl.compression(serverVersion);
            HashSet<HelloFeature> extraFeatures = new HashSet<HelloFeature>(compressionMode.getHelloFeatures(serverVersion));
            if (DcpConnectHandler.this.env.collectionsAware()) {
                extraFeatures.add(HelloFeature.COLLECTIONS);
            }
            ByteBuf request = ctx.alloc().buffer();
            HelloRequest.init(request, DcpConnectHandler.this.connectionName, extraFeatures);
            ctx.writeAndFlush((Object)request);
        }

        @Override
        ConnectionStep handleResponse(ChannelHandlerContext ctx, ByteBuf msg) {
            Set<HelloFeature> features = HelloRequest.parseResponse(msg);
            LOGGER.info("{} Negotiated features: {}", (Object)ctx.channel(), features);
            ctx.channel().attr(NEGOTIATED_FEATURES).set(Collections.unmodifiableSet(features));
            return features.contains((Object)HelloFeature.SELECT_BUCKET) ? DcpConnectHandler.this.selectBucket : DcpConnectHandler.this.open;
        }
    };
    private final ConnectionStep selectBucket = new ConnectionStep("select bucket"){

        @Override
        void issueRequest(ChannelHandlerContext ctx) {
            ByteBuf request = ctx.alloc().buffer();
            BucketSelectRequest.init(request, DcpConnectHandler.this.bucket);
            ctx.writeAndFlush((Object)request);
        }

        @Override
        ConnectionStep handleResponse(ChannelHandlerContext ctx, ByteBuf msg) {
            return DcpConnectHandler.this.open;
        }
    };
    private final ConnectionStep open = new ConnectionStep("open"){

        @Override
        void issueRequest(ChannelHandlerContext ctx) {
            ByteBuf request = ctx.alloc().buffer();
            DcpOpenConnectionRequest.init(request, DcpConnectHandler.this.env.connectionFlags());
            DcpOpenConnectionRequest.connectionName(request, DcpConnectHandler.this.connectionName);
            ctx.writeAndFlush((Object)request);
        }

        @Override
        ConnectionStep handleResponse(ChannelHandlerContext ctx, ByteBuf msg) {
            return DcpConnectHandler.this.remove;
        }
    };
    private final ConnectionStep remove = new ConnectionStep("remove"){

        @Override
        void issueRequest(ChannelHandlerContext ctx) {
            ByteBuf request = ctx.alloc().buffer();
            MessageUtil.initRequest((byte)-75, request);
            ctx.writeAndFlush((Object)request);
            ctx.pipeline().remove((ChannelHandler)DcpConnectHandler.this);
            DcpConnectHandler.this.originalPromise().setSuccess();
            ctx.fireChannelActive();
            LOGGER.debug("DCP Connection opened with Name \"{}\" against Node {}", (Object)DcpConnectHandler.this.connectionName, (Object)ctx.channel().remoteAddress());
        }

        @Override
        ConnectionStep handleResponse(ChannelHandlerContext ctx, ByteBuf msg) {
            throw new AssertionError((Object)("Connection step '" + this + "' should not have a response to handle."));
        }
    };
    private static final Logger LOGGER = LoggerFactory.getLogger(DcpConnectHandler.class);
    private static final AttributeKey<Version> SERVER_VERSION = AttributeKey.valueOf((String)"serverVersion");
    private static final AttributeKey<Set<HelloFeature>> NEGOTIATED_FEATURES = AttributeKey.valueOf((String)"negotiatedFeatures");
    private final Client.Environment env;
    private final ConnectionNameGenerator connectionNameGenerator;
    private String connectionName;
    private final String bucket;
    private final DcpControl dcpControl;
    private ConnectionStep step = this.version;

    public static Version getServerVersion(Channel channel) {
        Version version = (Version)channel.attr(SERVER_VERSION).get();
        if (version == null) {
            throw new IllegalStateException("Server version attribute not yet set by " + DcpConnectHandler.class.getSimpleName());
        }
        return version;
    }

    public static Set<HelloFeature> getFeatures(Channel channel) {
        Set features = (Set)channel.attr(NEGOTIATED_FEATURES).get();
        if (features == null) {
            throw new IllegalStateException("Negotiated features attribute not yet set by " + DcpConnectHandler.class.getSimpleName());
        }
        return features;
    }

    DcpConnectHandler(Client.Environment env) {
        this.env = Objects.requireNonNull(env);
        this.connectionNameGenerator = env.connectionNameGenerator();
        this.bucket = env.bucket();
        this.dcpControl = env.dcpControl();
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        try {
            this.connectionName = DcpConnectHandler.connectionNameWorkaround(this.connectionNameGenerator.name());
            this.step.issueRequest(ctx);
        }
        catch (Throwable t) {
            this.fail(ctx, t);
        }
    }

    private static String connectionNameWorkaround(String name) {
        return name.replace("{", "").replace("}", "");
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        try {
            ResponseStatus status = MessageUtil.getResponseStatus(msg);
            if (!status.isSuccess()) {
                throw new DcpOps.BadResponseStatusException(status);
            }
            this.step = this.step.handleResponse(ctx, msg);
            this.step.issueRequest(ctx);
        }
        catch (Throwable t) {
            this.fail(ctx, new RuntimeException("Could not establish DCP connection; failed in the '" + this.step + "' step; " + t, t));
        }
    }

    private void fail(ChannelHandlerContext ctx, Throwable t) {
        this.originalPromise().setFailure(t);
        ctx.channel().close();
    }

    private abstract class ConnectionStep {
        private final String name;

        ConnectionStep(String name) {
            this.name = Objects.requireNonNull(name);
        }

        public String toString() {
            return this.name;
        }

        abstract void issueRequest(ChannelHandlerContext var1);

        abstract ConnectionStep handleResponse(ChannelHandlerContext var1, ByteBuf var2);
    }
}

