/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.metrics;

import com.couchbase.client.dcp.metrics.ActionCounter;
import com.couchbase.client.dcp.metrics.ActionTimer;
import com.couchbase.client.dcp.metrics.EventCounter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.Objects;

public class MetricsContext {
    private final MeterRegistry registry;
    private final String prefix;
    private final Tags tags;

    public MetricsContext(MeterRegistry registry, String prefix) {
        this(registry, prefix, Tags.empty());
    }

    public MetricsContext(MeterRegistry registry, String prefix, Tags tags) {
        this.registry = Objects.requireNonNull(registry);
        this.prefix = prefix.isEmpty() || prefix.endsWith(".") ? prefix : prefix + ".";
        this.tags = Objects.requireNonNull(tags);
    }

    public MeterRegistry registry() {
        return this.registry;
    }

    public MetricsContext withTags(Tags tags) {
        return new MetricsContext(this.registry, this.prefix, Tags.concat((Iterable)this.tags, (Iterable)tags));
    }

    public ActionCounter.Builder newActionCounter(String name) {
        return ActionCounter.builder(this.registry, this.prefix + name).tags((Iterable<Tag>)this.tags);
    }

    public EventCounter.Builder newEventCounter(String name) {
        return EventCounter.builder(this.registry, this.prefix + name).tags((Iterable<Tag>)this.tags);
    }

    public ActionTimer.Builder newActionTimer(String name) {
        return ActionTimer.builder(this.registry, name).tags((Iterable<Tag>)this.tags);
    }
}

