/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.metrics;

import com.couchbase.client.dcp.conductor.DcpChannel;
import com.couchbase.client.dcp.config.HostAndPort;
import com.couchbase.client.dcp.core.state.LifecycleState;
import com.couchbase.client.dcp.metrics.DcpChannelMetrics;
import com.couchbase.client.dcp.metrics.EventCounter;
import com.couchbase.client.dcp.metrics.MetricsContext;
import io.micrometer.core.instrument.MultiGauge;
import io.micrometer.core.instrument.Tags;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;

public class DcpClientMetrics {
    private final EventCounter reconfigure;
    private final EventCounter addChannel;
    private final EventCounter removeChannel;
    private final LongAdder scheduledPollingTasks;
    private final MultiGauge connectionStatus;
    private final MetricsContext ctx;

    public DcpClientMetrics(MetricsContext ctx) {
        this.ctx = Objects.requireNonNull(ctx);
        this.reconfigure = ctx.newEventCounter("reconfigure").build();
        this.addChannel = ctx.newEventCounter("add.channel").build();
        this.removeChannel = ctx.newEventCounter("remove.channel").build();
        this.scheduledPollingTasks = (LongAdder)ctx.registry().gauge("dcp.scheduled.polling.tasks", (Number)new LongAdder());
        this.connectionStatus = MultiGauge.builder((String)"dcp.connection.status").register(ctx.registry());
    }

    public void incrementReconfigure() {
        this.reconfigure.increment();
    }

    public void incrementAddChannel() {
        this.addChannel.increment();
    }

    public void incrementRemoveChannel() {
        this.removeChannel.increment();
    }

    public LongAdder scheduledPollingTasks() {
        return this.scheduledPollingTasks;
    }

    public DcpChannelMetrics channelMetrics(HostAndPort address) {
        return new DcpChannelMetrics(this.ctx.withTags(Tags.of((String)"remote", (String)address.format())));
    }

    public synchronized void registerConnectionStatusGauges(Collection<DcpChannel> channels) {
        List rows = channels.stream().map(channel -> {
            Tags tags = Tags.of((String)"remote", (String)channel.address().format());
            return MultiGauge.Row.of((Tags)tags, () -> channel.isState(LifecycleState.CONNECTED) ? 1 : 0);
        }).collect(Collectors.toList());
        boolean OVERWRITE = true;
        this.connectionStatus.register(rows, true);
    }
}

