/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.message;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public enum SnapshotMarkerFlag {
    MEMORY(1),
    DISK(2),
    CHECKPOINT(4),
    ACK(8),
    HISTORY(16),
    MAY_CONTAIN_DUPLICATE_KEYS(32);

    private final int value;
    private static final List<SnapshotMarkerFlag> valueList;

    private SnapshotMarkerFlag(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public boolean isSet(int flags) {
        return (flags & this.value) == this.value;
    }

    public static Set<SnapshotMarkerFlag> decode(int flags) {
        EnumSet<SnapshotMarkerFlag> result = EnumSet.noneOf(SnapshotMarkerFlag.class);
        for (SnapshotMarkerFlag f : valueList) {
            if (!f.isSet(flags)) continue;
            result.add(f);
        }
        return result;
    }

    static {
        valueList = Collections.unmodifiableList(Arrays.asList(SnapshotMarkerFlag.values()));
    }
}

