/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.message;

import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.dcp.conductor.BucketConfigSink;
import com.couchbase.client.dcp.conductor.DcpChannel;
import com.couchbase.client.dcp.config.HostAndPort;
import com.couchbase.client.dcp.core.logging.RedactableArgument;
import com.couchbase.client.dcp.message.MessageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerRequest {
    private static final Logger log = LoggerFactory.getLogger(ServerRequest.class);

    private ServerRequest() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static boolean isServerRequest(ByteBuf msg) {
        return msg.getByte(0) == -126;
    }

    public static void handleServerRequest(ChannelHandlerContext ctx, ByteBuf msg, BucketConfigSink bucketConfigSink) {
        if (!ServerRequest.isServerRequest(msg)) {
            throw new IllegalArgumentException("expected a server request but got message with magic " + msg.getByte(0));
        }
        switch (msg.getByte(1)) {
            case 1: {
                ServerRequest.handleConfigChangeNotification(ctx, msg, bucketConfigSink);
                break;
            }
            case 2: 
            case 3: {
                log.warn("Ignoring unexpected server request: {}", (Object)MessageUtil.getShortOpcodeName(msg));
                break;
            }
            default: {
                log.warn("Ignoring unrecognized server request: {}", (Object)MessageUtil.getShortOpcodeName(msg));
            }
        }
    }

    private static void handleConfigChangeNotification(ChannelHandlerContext ctx, ByteBuf message, BucketConfigSink bucketConfigSink) {
        log.debug("{} Received bucket config from server notification", (Object)RedactableArgument.system(ctx.channel()));
        String clustermap = MessageUtil.getContentAsString(message);
        HostAndPort remote = DcpChannel.getHostAndPort(ctx.channel());
        ByteBuf extras = MessageUtil.getExtras(message);
        if (extras.readableBytes() >= 16) {
            bucketConfigSink.accept(remote, clustermap);
        } else {
            bucketConfigSink.accept(remote, clustermap);
        }
    }
}

