/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.message;

import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.dcp.highlevel.CollectionCreated;
import com.couchbase.client.dcp.highlevel.CollectionDropped;
import com.couchbase.client.dcp.highlevel.CollectionFlushed;
import com.couchbase.client.dcp.highlevel.ScopeCreated;
import com.couchbase.client.dcp.highlevel.ScopeDropped;
import com.couchbase.client.dcp.highlevel.internal.CollectionsManifest;
import com.couchbase.client.dcp.message.MessageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DcpSystemEvent {
    private static final Logger log = LoggerFactory.getLogger(DcpSystemEvent.class);
    private final Type type;
    private final int vbucket;
    private final long seqno;
    private final int version;

    protected DcpSystemEvent(Type type, int vbucket, long seqno, int version) {
        this.vbucket = vbucket;
        this.type = type;
        this.seqno = seqno;
        this.version = version;
    }

    public Type getType() {
        return this.type;
    }

    public int getVbucket() {
        return this.vbucket;
    }

    public long getSeqno() {
        return this.seqno;
    }

    public int getVersion() {
        return this.version;
    }

    public static DcpSystemEvent parse(ByteBuf buffer) {
        int vbucket = MessageUtil.getVbucket(buffer);
        ByteBuf extras = MessageUtil.getExtras(buffer);
        long seqno = extras.readLong();
        int typeCode = extras.readInt();
        short version = extras.readUnsignedByte();
        switch (typeCode) {
            case 0: {
                return new CollectionCreated(vbucket, seqno, version, buffer);
            }
            case 1: {
                return new CollectionDropped(vbucket, seqno, version, buffer);
            }
            case 2: {
                return new CollectionFlushed(vbucket, seqno, version, buffer);
            }
            case 3: {
                return new ScopeCreated(vbucket, seqno, version, buffer);
            }
            case 4: {
                return new ScopeDropped(vbucket, seqno, version, buffer);
            }
        }
        log.warn("Ignoring unrecognized DCP system event type {}", (Object)typeCode);
        return null;
    }

    public static enum Type {
        COLLECTION_CREATED(0),
        COLLECTION_DROPPED(1),
        COLLECTION_FLUSHED(2),
        SCOPE_CREATED(3),
        SCOPE_DROPPED(4);

        private final int code;

        private Type(int code) {
            this.code = code;
        }

        public int code() {
            return this.code;
        }
    }

    public static interface CollectionsManifestEvent {
        public CollectionsManifest apply(CollectionsManifest var1);

        public long getManifestId();
    }
}

